program surface;
uses
  wingraph;
const
 max=50;
 steps=50;
 MaxX=400;
 MaxY=400;
var
 data:array[1..max,1..max] of shortint;
 gamma:real;

procedure RealToVisual(X,Y:integer;var XTag,YTag:integer);
begin
 X:=X-max div 2;Y:=Y -max div 2;
 XTag:=round(MaxX/max*(X*cos(gamma)-Y*sin(gamma)))+Width div 2;
 YTag:=round(MaxY/max*(X*sin(gamma)+Y*cos(gamma)))+Height div 2;
end;

function Zcoord(X,Y:integer):shortint;
begin
 {if Sqr(X)+Sqr(Y)=100 then }
 {ZCoord:=round(Sqrt(Sqr(X-Max div 2)+Sqr(Y-Max div 2)));}
 ZCoord:=round(Sin(X/8-1.57)*50+Sin(Y/8-1.57)*50); {   else ZCoord:=0;}
 {ZCoord:=Round(10*Sqrt(Sqr(X-Max div 2)+Sqr(Y-Max div 2)));}
 {if (Abs(X-Max div 2)>10) or (Abs(Y-Max div 2)>10)then ZCoord:=0 else
  ZCoord:=Round(20*Sin(X+Y));}
end;

procedure BuildData;
var i,j:byte;
begin
for i:=1 to max do
  for j:=1 to max do
    data[i,j]:=ZCoord(i,j);
end;

procedure Draw;
var i,j:integer;
   x,y:integer;
  NewLine:boolean;
begin
for i:=1 to max do
 begin
   NewLine:=true;
   for j:=1 to max do
   begin
    RealToVisual(i,j,x,y);
    y:=y-data[i,j];
    if NewLine then MoveTo(X,Y)
               else LineTo(x,y);
    NewLine:=false;
   end;
  end;
 for j:=1 to max do
 begin
  NewLine:=true;
  for i:=1 to max do
  begin
  RealToVisual(i,j,x,y);
  y:=y-data[i,j];
  if NewLine then MoveTo(X,Y)
             else LineTo(X,Y);
  NewLine:=false;
  end;
 end;
end;

var Done:boolean;

procedure Stop(X,Y:integer);
begin
  Done:=true;
end;

Begin
 OnClick:=Stop;
 Done:=false;
 BuildData;
 Pen.Color:=clWhite;
 Gamma:=0.11;
 brush.Color:=clBlack;
repeat
 While not done do begin
  ClearDevice;
  Draw;
  Gamma:=Gamma-0.1;
  Delay(10);
  RefreshMessages;
  end;
 Done:=false;
 delay(2000);
until false;
 Loop;
End.


