unit WingraphMenus;

interface

uses WinGraph;
type
TMenuHandler=procedure(Index:byte);
TItemHandler=procedure;
 TMenuItem=record
   caption:string;
   PosX,PosY:integer;
   handler:TItemHandler;
          end;
 TMenu=class
   private
    ItemNum:byte;
    procedure DrawMenu;
   public
    PX,PY:integer;
    Active:byte;
    callBack:TMenuhandler;
    Items:array of TMenuItem;
    vertical:boolean;
    ActiveColor,PassiveColor,TextColor:TColor;
    Transparent:boolean;
    constructor create(PosX,PosY:integer;Vert:boolean;
       ActiveCl:Tcolor=clSilver;PassiveCl:TColor=clBlack;
    Textcl:TColor=clWhite;TranspMenu:boolean=false;Handler:TMenuHandler=nil);
    procedure Next;
    procedure Previous;
    procedure AddItem(Name:string;callBack:TItemHandler=nil;PositionX:integer=0;PositionY:integer=0);
    procedure Execute;
    end;
implementation

constructor TMenu.create(PosX,PosY:integer;Vert:boolean;
    ActiveCl:Tcolor=clSilver;PassiveCl:TColor=clBlack;
    Textcl:TColor=clWhite;TranspMenu:boolean=false;Handler:TMenuHandler=nil);
begin
 ItemNum:=0;
 PX:=PosX; PY:=PosY;Vertical:=Vert;
 ActiveColor:=ActiveCl;PassiveColor:=PassiveCl;
 CallBack:=Handler;textColor:=TextCl;Transparent:=TranspMenu;
end;

procedure TMenu.DrawMenu;
var i:integer;
begin
 for i:=1 to High(Items) do
 begin
  if Active=i then SetTextStyle(TextColor,ActiveColor,Transparent)
              else SetTextStyle(TextColor,PassiveColor,Transparent);
  writeAt(Items[i].PosX,Items[i].PosY,Items[i].Caption);
 end;
end;

procedure TMenu.AddItem(Name:string;callBack:TItemHandler=nil;PositionX:integer=0;PositionY:integer=0);
begin
 Inc(ItemNum);
 SetLength(Items,ItemNum+1);
 with Items[ItemNum] do
  begin
   caption:=name;
   handler:=CallBack;
   if PositionX=0 then
    case Vertical of
     true: begin
      PosX:=PX;
      PosY:=PY+1;
           end;
     false:begin
      PosY:=PY;
      if ItemNum>1 then
        PosX:=PX+Length(Items[ItemNum-1].Caption)+1
                   else PosX:=Px;
           end;
    end
                 else
    begin
     PosX:=PositionX;
     posY:=PositionY;
    end;
  end;
  PX:=Items[ItemNum].PosX;
  PY:=Items[ItemNum].PosY;
end;

procedure TMenu.Execute;
var Input:integer;
begin
  Active:=1;
  DrawMenu;
  repeat
   Input:=readscan;
   case Input of
   38:Previous;
   40:Next;
   13:if Assigned(Items[Active].Handler) then Items[Active].Handler
       else if Assigned(callBack) then callBack(Active);
   end;
  until Input=13;
end;

procedure TMenu.Next;
begin
 if Active<>ItemNum then inc(Active) else Active:=1;
 DrawMenu;
end;

procedure TMenu.Previous;
begin
 if Active<>1 then dec(Active) else active:=ItemNum;
 DrawMenu;
end;

end.
