unit WinGraph;

////////////////////////////////////////////////////////////
{  Written by Khivrich Ilya  ( ilya_kh@yahoo.com )         }
{                                                          }
{  A unit for creating basic graphics in Delphi without    }
{  using VCL library                                       }
{                                                          }
{  Complete freeware.                                      }
{                                                          }
{ If you make any improvements, please send it to me also  }
{                                                          }
{ Please mention my name if you publish something great    }
{   if it was created using this pack                      }
////////////////////////////////////////////////////////////


interface
uses windows,messages;
{ Help types }

 (*Color constants*)
type
 TColor = -$7FFFFFFF-1..$7FFFFFFF;
const
  clBlack = TColor($000000);
  clMaroon = TColor($000080);
  clGreen = TColor($008000);
  clOlive = TColor($008080);
  clNavy = TColor($800000);
  clPurple = TColor($800080);
  clTeal = TColor($808000);
  clGray = TColor($808080);
  clSilver = TColor($C0C0C0);
  clRed = TColor($0000FF);
  clLime = TColor($00FF00);
  clYellow = TColor($00FFFF);
  clBlue = TColor($FF0000);
  clFuchsia = TColor($FF00FF);
  clAqua = TColor($FFFF00);
  clLtGray = TColor($C0C0C0);
  clDkGray = TColor($808080);
  clWhite = TColor($FFFFFF);
  clNone = TColor($1FFFFFFF);
  clDefault = TColor($20000000);
    (*Basic colors*)
  BasicColor:array[0..19] of TColor=(clNone,clBlack,clMaroon,clGreen,clOlive,
                                     clNavy,clPurple,clTeal,clGray,clSilver,
                                     clRed,clLime,clYellow,clBlue,clFuchsia,
                                     clAqua,clLtGray,clDkGray,clWhite,clDefault);

  cmBlackness   = BLACKNESS;
  cmDstInvert   = DSTINVERT;
  cmMergeCopy   = MERGECOPY;
  cmMergePaint  = MERGEPAINT;
  cmNotSrcCopy  = NOTSRCCOPY;
  cmNotSrcErase = NOTSRCERASE;
  cmPatCopy     = PATCOPY;
  cmPatInvert   = PATINVERT;
  cmPatPaint    = PATPAINT;
  cmSrcAnd      = SRCAND;
  cmSrcCopy     = SRCCOPY;
  cmSrcErase    = SRCERASE;
  cmSrcInvert   = SRCINVERT;
  cmSrcPaint    = SRCPAINT;
  cmWhiteness   = WHITENESS;

type
     (*Procedural types*)
  ClickProc=procedure (X,Y:integer);

  KeyProc  =procedure (Ch:Char);

  TProc    =procedure;

  TBool    =function:boolean;

  TPoint=record X,Y:integer end;
     (*Other types*)
  TPenStyles=(psSolid,psDash,psDot,psDashDot,psDashDotDot,psClear);

  TBrushStyle = (bsSolid, bsClear, bsHorizontal, bsVertical,
                 bsFDiagonal, bsBDiagonal, bsCross, bsDiagCross);
     (*A record for saving pen data*)
  TPenData = record
   Style:TPenStyles;
   Color:TColor;
   Width:Byte;
            end;
      (*A record for saving brush data*)
  TBrushData = record
   Style:TBrushStyle;
   Color:TColor;
               end;
     (*Visible constants/variables*)
Const
 ScreenMX=89;
 ScreenMY=29;
var  Screen:array[1..ScreenMX,1..ScreenMY] of char;
     rPosX,rPosY:byte;
     WindowSx:byte=1;
     WindowMx:byte=ScreenMx;
     WindowSy:byte=1;
     WindowMy:byte=ScreenMy;
     BackColor:TColor=clBlack;
     OnClick:ClickProc;
     OnMouseUp:ClickProc;
     OnMouseMove:ClickProc;
     OnRightDown:ClickProc;
     OnKeyPress:KeyProc;
     (*Visible procedures*)
     (* PROGRAM CONTROL *)

       procedure ProcessMessages;
       procedure RefreshMessages;
       procedure LoopUntil(Event:TBool);
       procedure Loop;
       procedure Delay(msec: Word);

     (* GRAPHICS*)
       function Width:integer;
       function Height:integer;
       function DeviceContext:integer;
       procedure LineTo(x,y:integer);
       procedure Line(x1,y1,x2,y2:integer);
       procedure Arc(X1,Y1,X2,Y2,X3,Y3,X4,Y4:integer);
       procedure Polyline(Points:array of TPoint);
       procedure Rectangle(X1,Y1,X2,Y2:integer);
       procedure Ellipse(X1,Y1,X2,Y2:integer);
       procedure Circle(X,Y,Radius:integer);
       procedure FloodFill(X,Y:integer;Color:TColor;SurfaceFill:boolean=false);
       procedure TextOut(X,Y:integer;const Text:String);
       procedure MoveTo(x,y:integer);
       procedure ClearDevice;
       procedure CopyRect(Source,Dest:TRect;CopyMode:longint=cmSrcCopy);
       procedure Polygon(Points: array of TPoint);
       procedure PolyBezier(const Points: array of TPoint);
       procedure PolyBezierTo(const Points: array of TPoint);
       procedure FrameRect(const Rect:TRect);
       procedure FillRect(const Rect:TRect);
       procedure RoundRect(X1,Y1,X2,Y2,X3,Y3:integer);
       procedure Pie(X1,Y1,X2,Y2,X3,Y3,X4,Y4:integer);

      (* TEXT I/O *)

       procedure UpDate;
       procedure DirectWrite(X,Y:integer;C:char);
       procedure WriteAt(X,Y:integer;S:string);
       procedure WriteLst(List:array of const);
       procedure Write(S:string);overload;
       procedure Write(N:integer;Spaces:byte=0);overload;
       procedure Write(N:extended;Spaces:byte=0);overload;
       procedure Writeln(S:String='');
       procedure Read(var S:string);overload;
       function  Read(var N:integer):bytebool;overload;
       function  Read(var N:real):bytebool;overload;
       function  ReadKey:char;
       function  ReadScan:integer;
       procedure ClearScreen;
       procedure GotoXY(X,Y:byte);
       procedure ShowCursor;
       procedure SetTextStyle(TextColor,BackColor:TColor;Transparent:boolean=false);
       procedure Window(X1,Y1,X2,Y2:integer);
       procedure SaveTextToFile(const FileName:string);
       procedure CaptureText(const FileName:string);
       procedure EndCapture;
       procedure Beep;
//////////CLASSES//////////
 type
//////////TTIMER//////////
TTimer=class
  private
    ID:integer;
  public
   constructor Create(Handler:TProc;Time:Word);
   destructor Done;
       end;
//////////TPIXELS/////////
TPixels=class
 private
  function  GetPixel(X,Y:integer):TColor;
  procedure SetPixel(X,Y:integer;Value:TColor);
 public
  property Pixels[X,Y:integer]:TColor read GetPixel write SetPixel;default;
        end;

//////////TBRUSH//////////

TBrush=class
  private
   pBrush:HBrush;
   rColor:TColor;
   rStyle:TBrushstyle;
   procedure SetCol(Value:TColor);
   procedure SetStyle(Value:TBrushStyle);
  public
   procedure SaveTo(out Brush:TBrushData);
   procedure LoadFrom(const Brush:TBrushData);
   procedure NewBrush(Style:TBrushStyle;Color:TColor);
   property Color:TColor read rColor Write SetCol;
   property Style:TBrushStyle read rStyle write SetStyle;
end;

///////////TPEN//////////

TPen = class
      private
       pPen:HPen;
       rPenstyle:TPenStyles;
       rColor:TColor;
       rWidth:byte;
       procedure SetStyle(Value:TPenStyles);
       procedure SetColor(Value:TColor);
       procedure SetWidth(Value:byte);
      public
       property Style:TPenStyles read rPenStyle write SetStyle;
       property Color:TColor read rColor write SetColor;
       property Width:byte read rWidth write SetWidth;
       procedure NewPen(Style:TPenStyles;Width:byte;Color:TColor);
       procedure SaveTo(out Pen: TPenData);
       procedure LoadFrom(const Pen:TPenData);
    end;


var
 Pen   :TPen;
 Brush :TBrush;
 Pixels:TPixels;
////////////////////////////////////////////////////////
IMPLEMENTATION             //                         //
                           //                         //
var                        //                         //
  WinClass: TWndClassA;    // The window              //
  Inst, Handle: Integer;   // Instance and the handle //
  Msg: TMsg;               // The window message      //
  wDC: Integer;            // Device Context          //
  rheight,rwidth:integer;  // Real Height and Width   //
////////////////////////////////////////////////////////
 ReadingHook:boolean=false;// Some vars for reading   //
 ReadingDone:boolean=true; //     purposes            //
 ReadBuf:String;           //                         //
 CharHook:boolean=false;   //                         //
 ScanCode:integer=0;       //                         //
 TextCapture:boolean=false;//                         //
 CaptureFile:string='';    //                         //
 CaptureF:text;            //                         //
////////////////////////////////////////////////////////
 Ps:TPoint;
 cPen:TPen;
 cBrush:TBrush;
 cFont:HFONT;
/////////////////TTIMER//////////////////////////////
var TimerNum:integer=0;                            //
constructor TTimer.Create(Handler:TProc;Time:word);//T
begin                                              //I
 inc(TimerNum);                                    //M
 ID:=SetTimer(handle,TimerNum,Time,@handler);      //E
end;                                               //R
                                                   //
destructor TTimer.Done;                            //
begin                                              //
 KillTimer(Handle,ID);
                                           //
end;                                               //
//////////////////////TPEN///////////////////////////
                                                   //
procedure TPen.NewPen( Style:TPenStyles; Width:byte//
                                   ; Color:TColor);//
begin                                              //
 rPenStyle:=style; rColor:=color; rWidth:=width;   //
 pPen:=CreatePen(ord(Style),Width,Color);          //
 SelectObject(wDC,pPen);                           //
end;                                               //
                                                   //
                                                   //
procedure TPen.SetStyle(Value:TPenStyles);         //
begin                                              //
  NewPen(Value,rWidth,rColor);                     //
end;                                               //
                                                   //
procedure TPen.SetColor(Value:TColor);             //
begin                                              //
  NewPen(rPenStyle,rWidth,Value);                  //
end;                                               //
                                                   //
procedure TPen.SetWidth(Value:byte);               //
begin                                              //
  NewPen(rPenStyle,Value,rColor);                  //
end;                                               //
                                                   //
procedure TPen.SaveTo(out Pen: TPenData);          //
begin                                              //
 Pen.Style:=rPenStyle;                             //
 Pen.Color:=rColor;                                //
 Pen.Width:=rWidth;                                //
end;                                               //
                                                   //
procedure TPen.LoadFrom(const Pen:TPenData);       //
begin                                              //
 NewPen(Pen.Style,Pen.Width,Pen.Color);            //
end;                                               //
///////////////TBRUSH////////////////////////////////
procedure TBrush.NewBrush(Style:TBrushStyle;       //
                                   Color:TColor);  //T
var WinStyle:byte;                                 //B
  forClear:LogBrush;                               //R
begin                                              //U
 WinStyle:=1;                                      //S
  if Style=bsSolid then                            //H
  pBrush:=CreateSolidBrush(Color)                  //
                  else                             //
 if Style=bsClear then                             //
 begin                                             //
  forClear.lbStyle:=bs_Null;                       //
  pBrush:=CreateBrushIndirect(forClear);           //
 end                                               //
                   else                            //
 begin                                             //
  case Style of                                    //
   bsVertical  : WinStyle:=HS_VERTICAL;            //
   bsHorizontal: WinStyle:=HS_HORIZONTAL;          //
   bsCross     : WinStyle:=HS_CROSS;               //
   bsDiagCross : WinStyle:=HS_DIAGCROSS;           //
   bsBDiagonal : WinStyle:=HS_BDIAGONAL;           //
   bsFDiagonal : WinStyle:=HS_FDIAGONAL;           //
 end;                                              //
  pBrush:=Windows.CreateHatchBrush(WinStyle,Color);//
 end;                                              //
 SelectObject(wDC,pBrush);                         //
 rStyle:=Style;                                    //
 rColor:=Color;                                    //
end;                                               //
                                                   //
procedure TBrush.SetCol(Value:TColor);             //
begin                                              //
 NewBrush(rStyle, Value);                          //
end;                                               //
                                                   //
procedure TBrush.SetStyle(Value:TBrushStyle);      //
begin                                              //
 NewBrush(Value, rColor);                          //
end;                                               //
                                                   //
procedure TBrush.SaveTo(out Brush:TBrushData);     //
begin                                              //
 Brush.Style:=rStyle;                              //
 Brush.Color:=rColor;                              //
end;                                               //
                                                   //
procedure TBrush.LoadFrom(const Brush:TBrushData); //
begin                                              //
  NewBrush(Brush.Style,Brush.Color);               //
end;                                               //
///////////////TPIXELS///////////////////////////////
procedure TPixels.SetPixel(X,Y:integer;            //
                                   Value:TColor);  //
begin                                              //
 Windows.SetPixel(WDC,x,y,Value);                  //
end;                                               //
/////////////////////////////////////////////////////
function  TPixels.GetPixel(X,Y:integer):TColor;    //
begin                                              //
  result:=Windows.GetPixel(wDC,X,Y);               //
end;                                               //
/////////////////////////////////////////////////////
function DeviceContext:integer; begin Result:=wDC end;

function HandleChar(C:Char):boolean;forward;{To handle the char being read}

/////// The procedure that handles the incoming messages ////////

function WindowProc(hWnd, uMsg,	wParam,	lParam: Integer): Integer; stdcall;
begin
  Result := DefWindowProc(hWnd, uMsg, wParam, lParam);
  case  uMsg of
          //The app is being closed!
    WM_DESTROY    :begin
                     Windows.ShowWindow(Handle,SW_SHOWMINIMIZED); halt
                   end;
          //Left mouse button click
    WM_LBUTTONDOWN: if Assigned(OnClick) then
                      OnClick(LOWORD(lparam),HIWORD(lparam));
    WM_RBUTTONDOWN:  //Right click
       if Assigned(OnRightDown) then
                   OnRightDown(LoWord(lParam),HiWord(lParam));
    WM_LBUTTONUP  :  //Left mouse button depressed
       if Assigned(OnMouseUp)then
                    OnMouseUp(LOWORD(lparam),HIWORD(lparam));

    WM_MOUSEMOVE:    //Mouse moved
       if Assigned(OnMouseMove) then
                    OnMouseMove(LOWORD(lparam),HIWORD(lparam));
    WM_NCHITTEST: if not((LOWORD(lparam)>rwidth-ScreenMY)and (HIWORD(lparam)<ScreenMY))then
                        WindowProc:=HTCLIENT;
    WM_CHAR:  case ReadingHook of
               true: ReadingDone:=handleChar(Chr(wParam));
               false:if Assigned(OnKeyPress) then
                    OnKeyPress(Chr(wParam));
                    end;
    WM_KEYDOWN: ScanCode:=ord(wParam);
    WM_TIMER: Tproc(lparam);
  end;
end;
///////////////////////////////////////////////////////////
function Width:integer;
begin result:=rWidth end;
function Height:integer;
begin result:=rHeight end;

procedure ProcessMessages;
begin
  { ** Message Loop ** }
    while (GetMessage(Msg, Handle, 0, 0)) do
    begin
      TranslateMessage(msg);
      DispatchMessage(msg);
      if ReadingHook and ReadingDone then
               break;
    end;
end;
procedure Loop; begin ProcessMessages end;
procedure RefreshMessages;
begin
 if PeekMessage(Msg,Handle,0,0,PM_REMOVE) then
 begin
 TranslateMessage(msg);
 DispatchMessage(msg);
 end;
end;

///////////////////////////////////////////////////////////

procedure LoopUntil(Event:TBool);
begin
  while (GetMessage(Msg,Handle,0,0))and not Event do
  begin
     TranslateMessage(msg);
     DispatchMessage(msg);
  end;
end;
///////////////////////////////////////////////////////////
procedure SetPenPos(Value:TPoint);
begin
 if Windows.MoveToEx(wDc,Value.x ,Value.y ,nil) then
   ps:=value;
end;
///////////////////////////////////////////////////////////
procedure Line(x1,y1,x2,y2:integer);
var Temp:array[1..2] of TPoint;
begin
 Temp[1].X:=x1; Temp[1].y:=y1;
 Temp[2].x:=x2; Temp[2].y:=y2;
 windows.PolyLine(wDc,temp,2);
end;

procedure Polyline(Points:array of TPoint);
begin
 Windows.Polyline(wdc,Points,High(Points)-Low(Points)+1);
end;

procedure LineTo(x,y:integer);
begin
 windows.LineTo(wDC,x,y);
end;

procedure FloodFill(X,Y:integer;Color:TColor;Surfacefill:boolean=false);
var FillType:byte;
begin
  if SurfaceFill then FillType:=1 else FillType:=0;
  Windows.ExtFloodFill(wdc,X,Y,Color,FillType);
end;

procedure Rectangle(X1,Y1,X2,Y2:integer);
begin
  Windows.Rectangle(wDC,x1,y1,x2,y2);
end;

procedure FrameRect(const Rect:TRect);
begin
  Windows.FrameRect(wDC,Rect,Brush.Pbrush);
end;

procedure FillRect(const Rect:TRect);
begin
  Windows.FillRect(wDC,Rect,Brush.PBrush);
end;

procedure Polygon(Points: array of TPoint);
begin
 windows.Polygon(wDC,Points,High(Points));
end;

procedure PolyBezier(const Points: array of TPoint);
begin
 Windows.PolyBezier(wDc,Points,High(Points));
end;

procedure PolyBezierTo(const Points: array of TPoint);
begin
 Windows.PolyBezierTo(wDC,Points,High(Points));
end;

procedure CopyRect(Source,Dest:TRect;CopyMode:longint=cmSrcCopy);
begin
  Windows.BitBlt(wDC,Dest.Left,Dest.Top,Dest.Right-Dest.Left,
     Dest.Bottom-Dest.Top,wDC,Source.Left,Source.Top,CopyMode);
end;

procedure Ellipse(X1,Y1,X2,Y2:integer);
begin
 Windows.Ellipse(wDc,X1,Y1,X2,Y2);
end;

procedure Circle(X,Y,Radius:integer);
var Dif:integer;
begin
 Dif:=Radius div 2;
 Windows.Ellipse(wDc,X-Dif,Y-Dif,X+dif,Y+dif);
end;

procedure Arc(X1,Y1,X2,Y2,X3,Y3,X4,Y4:integer);
begin
  Windows.Arc(wDC,X1,Y1,X2,Y2,X3,Y3,X4,Y4)
end;

procedure RoundRect(X1,Y1,X2,Y2,X3,Y3:integer);
begin
 Windows.RoundRect(wDC,x1,y1,x2,y2,x3,y3);
end;

procedure Pie(X1,Y1,X2,Y2,X3,Y3,X4,Y4:integer);
begin
 windows.Pie(wDC,x1,y1,x2,y2,x3,y3,x4,y4);
end;
///////////////////////////////////////////////////////////

procedure SetPen(Value:Tpen);
begin
 cPen:=Value;
end;

procedure SetBrush(Value:TBrush);
begin
 cBrush:=value;
end;              

///////////////////////////////////////////////////////////
procedure MoveTo(X,Y:integer);
var t:tpoint;
begin
  t.x:=x;
  t.y:=y;
  SetPenPos(t);
end;
///////////////////////////////////////////////////////////
procedure TextOut(X,Y:integer;const Text:string);
begin
  Windows.TextOut(wdc,X,Y,PChar(Text),Length(Text));
end;

procedure SetTextStyle(TextColor,BackColor:TColor;Transparent:boolean=false);
begin
  Windows.SetTextColor(wDc,TextColor);
  Windows.SetBkColor(wDc,BackColor);
  Windows.SetBkMode(wDc,ord(not Transparent)+1);
end;
///////////////////////////////////////////////////////////
procedure cls;
var a,b:byte;
begin
  for a:=WindowSx to WindowMX do
    for b:=WindowSy to WindowMY do
      Screen[a,b]:=' ';
end;

procedure ClearScreen;
begin
 cls;
 rPosX:=1;
 rPosY:=1;
 ClearDevice;
end;

procedure DirectWrite(X,Y:integer;C:Char);
begin
 Screen[X,Y]:=C;
 Windows.TextOut(wDC,9*(x-1),20*(y-1),@C,1);
end;

procedure WriteAt(X,Y:integer;S:string);
var i:integer;
begin
 for i:=X to X+length(s)-1 do
  if i<screenMX then DirectWrite(i,Y,s[i-x+1]);
end;

procedure UpdateLine(Line:byte);
var i:byte;
    PrevMax,ThisMax:byte;
    Temp:String;
begin
    Temp:='';
    PrevMax:=ScreenMX;
    if line=1 then PrevMax:=ScreenMX else
      for i:=ScreenMX downto 1 do
        if screen[i,Line-1]<>' ' then break else PrevMax:=i;
    ThisMax:=ScreenMX;
    for i:=ScreenMX  downto 1 do if screen[i,line]<>' ' then break else ThisMax:=i;
    If PrevMax>ThisMax then ThisMax:=PrevMax;
    for i:=1 to ThisMax do
       Temp:=Temp+screen[i,line];
    Windows.TextOut(wdc,1,20*(Line-1),PChar(Temp),Length(Temp));
end;

procedure Scroll;
var i,j:byte;
 CaptS:string;
begin

 if TextCapture then
  begin
   CaptS:='';
   for i:=WindowSX to WindowMx do
            CaptS:=CaptS+Screen[i,1];
   system.Writeln(CaptureF,CaptS);
  end;

 for j:=WindowSy to WindowMY do
   for i:=WindowSx to WindowMX do
     Screen[i,j]:=Screen[i,j+1];
 for i:=WindowSx to WindowMX do Screen[i,ScreenMY]:=' ';
end;

procedure GoForward;
begin
 if rPosX=WindowMx then
  begin
   rPosX:=WindowSx;
   if rPosY<WindowMY then inc(rPosY) else begin scroll; update end;
  end              else
 inc(rPosX);
end;

procedure GoBack;
begin
 if rPosX=WindowSx then
  begin
   rposX:=WindowMx;
   if rPosY>WindowMy then dec(rPosY);
  end              else
 dec(rposX);
end;

procedure UpDate;
var Line:integer;
begin
 for Line:=1 to  ScreenMY do UpdateLine(Line);
end;


procedure Write(N:integer;Spaces:byte=0);
var TempS:string;
i:byte;
begin
 str(N,TempS);
 if Spaces=0 then
 Write(TempS)
             else
 begin
  for i:=Length(TempS) to Spaces do
   TempS:=TempS+' ';
  Write(Copy(TempS,1,Spaces));
 end;
end;

procedure Write(N:extended;Spaces:byte=0);
var TempS:string;
begin
 str(N,TempS);
 if Spaces=0 then
 Write(TempS)
             else
 begin
  Temps:=TempS+'                            ';
  Write(Copy(TempS,1,Spaces));
 end;
end;

procedure Write(S:String);
var PLine, i, len:integer;
    Scrolled:boolean;
begin
 i:=0;
 scrolled:=false;
 PLine:=rPosY;
 Len:=Length(S);
 While i<len do
 begin
  inc(I);
   // Scrolling etc
  inc(rPosX);
  if rPosX>=WindowMX+1 then
    begin
      rPosX:=WindowSx;
      if rPosY<WindowMY-1 then inc(rPosY)
                 else begin
                   Scroll;
                   Scrolled:=true;
                      end;
    end;
   if S[i]=#13 then Writeln else
   Screen[rPosX,rPosY]:=S[i];
 end;
  if Scrolled then UpDate else
   for i:=PLine to rPosY do UpDateLine(i);
end;

procedure WriteLst(List:array of const);
var  i:integer;
begin
 for i:=0 to High(List) do
 with List[i] do
 case VType of
  vtInteger:write(VInteger);
  vtString:write(VString^);
  vtAnsiString:write(string(VAnsiString));
  vtExtended:write(VExtended^);
  vtChar:write(VChar);
 end;
end;

procedure Writeln(S:String='');
begin
  Write(S);
  if rPosY+1>=WindowMY then
  begin
     Scroll;
     UpDate;
  end
                       else
     inc(rPosY);
    rPosX:=WindowSx;
end;

procedure Read(var S:string);
begin
 ShowCursor;
 ReadingHook:=true;
 ReadingDone:=false;
 ReadBuf:='';
 repeat
  ProcessMessages
 until ReadingDone;
 ReadingHook:=false;
 S:=ReadBuf;
 GoBack;
end;

function Read(var N:integer):bytebool;
var S:string;
    Code:integer;
begin
  Read(S);
  Val(S,N,Code);
  result:=bytebool(code);
end;

function Read(var N:real):bytebool;
var S:string;
Code:integer;
begin
  Read(S);
  Val(S,N,Code);
  Result:=bytebool(code);
end;

function ReadKey:Char;
begin
 ReadingHook:=true;
 ReadingDone:=false;
 CharHook:=true;
 ReadBuf:='';
 repeat
  ProcessMessages
 until ReadingDone;
 CharHook:=false;
 ReadingHook:=false;
 Result:=ReadBuf[1];

(*repeat
 RefreshMessages
until Length(ReadBuf)>=1;
Result:=ReadBuf[1];
*)
end;

function ReadScan:integer;
begin
 repeat
  RefreshMessages
 until ScanCode<>0;
 ReadScan:=ScanCode;
 ScanCode:=0;
end;

procedure ShowCursor;
begin
 DirectWrite(rPosX+1,rPosY,#95);
end;


procedure GotoXY(X,Y:byte);
begin
 rPosX:=x;rPosY:=y;
end;

function HandleChar(C:char):boolean;
{Reading finished => result = true }
begin
  if CharHook then
  begin
     ReadBuf:=C;
     result:=true;
     exit;
  end;
  result:=false;
  case Ord(C) of
  13:begin
           GoForward;
           DirectWrite(rPosX,rPosY,' ');
           result:=true
     end;
  8:if ReadBuf>'' then begin
       ReadBuf:=Copy(ReadBuf,1,Length(ReadBuf)-1);
       GoForward;
       DirectWrite(rPosX,rPosY,' ');
       GoBack;
       DirectWrite(rPosX,rPosY,'_');
       GoBack;
   end;
  else
     begin
       ReadBuf:=ReadBuf+C;
       GoForward;
       if rPosX>=WindowMx then
       begin
         DirectWrite(rPosX,rPosY,' ');
         write(C+#95);
         GoBack;
       end
                          else
       writeAt(rPosx,rPosY,C+#95);
     end;
  end;
end;

procedure ClearDevice;
var Area:TRect;
begin
 with Area do begin
  Left:=0;Right :=rWidth+1;
  Top :=0;Bottom:=rHeight+3;
              end;
 Windows.FillRect(wDC,Area,CreateSolidBrush(BackColor));
end;

procedure Delay(msec: Word);
var Now,FirstTickCount:longint;
begin
   FirstTickCount := GetTickCount;
  repeat
    RefreshMessages;
    Now := GetTickCount;
  until (Now - FirstTickCount >= mSec) or (Now < FirstTickCount);
end;

procedure Window(X1,Y1,X2,Y2:integer);
begin
 WindowSx:=X1;WindowMx:=X2;WindowSy:=Y1;WindowMy:=Y2;
 rPosX:=X1-1;rposY:=Y1;
end;

procedure SaveTextToFile(const FileName:string);
var F:Text;
i,j:byte;
begin
AssignFile(F,FileName);
ReWrite(F);
for i:=1 to ScreenMY do
 begin
 for j:=1 to screenMX do System.write(F,screen[j,i]);
 System.Writeln(F);
 end;
end;

procedure CaptureText(const FileName:string);
begin
 if  TextCapture then CloseFile(CaptureF);
 CaptureFile:=FileName;
 assignFILE(CaptureF,FileName);
 rewrite(CaptureF);
end;

procedure EndCapture;
var i,j:integer;
    CaptS:string;
begin
 if not TextCapture then Exit;
 for j:=WindowSY to WindowMY do
 begin
   CaptS:='';
   for i:=WindowSX to WindowMX do
    CaptS:=CaptS+screen[i,j];
   system.Writeln(CaptureF,CaptS);
 end;
 CloseFile(CaptureF);
 TextCapture:=false;
 CaptureFile:='';
end;
procedure Beep;
begin Windows.Beep(1,1) end;
//////////////////////////////////////////////////////////
begin
    Inst := hInstance;
    with WinClass do
      begin
        style              := CS_CLASSDC;
        lpfnWndProc        := @WindowProc;
        hInstance          := Inst;
        hbrBackground      := color_WINDOWTEXT + 1;
        lpszClassname      := 'GRAPHWINDOW';
        hCursor            := LoadCursor(0, IDC_ARROW);
      end; { with }
      RegisterClass(WinClass);
      { ** Create Main Window ** }
      rwidth :=GetSystemMetrics(SM_CXSCREEN);
      rheight:=GetSystemMetrics(SM_CYSCREEN);
      Handle := CreateWindow('GRAPHWINDOW', '',
                                WS_VISIBLE or WS_SYSMENU,0, 0,
                               rwidth,rheight, 0, 0, Inst, nil);
    wDC:=getdc(handle);
    Ps.x:=0;Ps.y:=0;
    cFont:=CreateFont(0,0,0,0,0,0,0,0,DEFAULT_CHARSET,
                      0,0,0,FIXED_PITCH,nil);
    SelectObject(wDC,cFont);
    Pen:=TPen.Create;
    Brush:=TBrush.Create;
    Pixels:=TPixels.Create;
    Pen.NewPen(psSolid,1,clWhite);
    Brush.NewBrush(bsSolid,clWhite);
    SettextStyle(clWhite,clBlack);
    cls;
    rPosX:=1; rPosY:=1;
    Windows.ShowWindow(Handle,SW_SHOWMAXIMIZED);
end.
