program WinGraph_Demo;

uses
  Wingraph,
  WingraphMenus,
  SomeUtils,
  MoreUtils in 'MoreUtils.pas';
{$R Wingraph.RES}

procedure TextO;
var i,j:integer;
  done:boolean;
const N=30000;
begin
 SetTextStyle(clWhite,clBlack);
 i:=3;
 while i<N do
 begin
  done:=true;
  for j:=2 to i div 2 do
    if i mod j=0 then begin done:=false; break end;
  if done then begin write(i);write(' ') end;
  Inc(i,2);
 end;
 writeln;
 write('These were all primes before ');write(N);
 SaveTextToFile('Primes.txt');
end;

procedure Dialog;
var Input:string;
const Phrases:array[1..5] of string=('Oh, really?','Maybe..','Never mind.','And what do YOU think','It does not matter');
begin
 Randomize;
 BackColor:=clNavy;
 ClearDevice;
 Writeln('-Hello. Tell me something, type BYE to stop');
 repeat
  read(input);writeln;
  if Random(10)>7 then write(Input+' ');
  writeln(phrases[Random(5)+1]);
 until input='BYE';
end;

procedure Home;
var i:integer;
const R=100;
begin
 ClearScreen;
 Brush.NewBrush(bsBDiagonal,clGray);
 Rectangle(100,300,400,480);
 Brush.NewBrush(bsCross,clBlue);
 Rectangle(250,340,350,470);
 Circle(345,410,10);
 Line(100,300,250,170);
 Line(250,170,400,300);
 Brush.NewBrush(bsSolid,clRed);
 FloodFill(250,200,clBlack,true);
 Brush.Color:=clYellow;
 Pen.NewPen(psDot,1,clYellow);
 for i:=1 to 20 do
  Line(500,100,500+Trunc(R*sin(i*pi/10)),100-Trunc(R*Cos(i*pi/10)));
  Circle(500,100,70);

end;

{ }
var DemoDone:boolean;

procedure Move(X,Y:integer);
begin
 Circle(X,y,3);
end;
procedure Click(X,Y:integer);
begin
 if (Abs(X-45)<15) and(abs(Y-45)<15) then
  begin DemoDone:=true; exit end;
 Circle(X,y,8);
 TextOut(X,Y,'Left button click');
end;
procedure RightClick(X,Y:integer);
begin
 Circle(X,Y,8);
 TextOut(X,Y,'Right button click');
end;
procedure DClick(X,Y:integer);
begin
 TextOut(X,Y,'DDDDDD');
end; 

procedure MouseTest;
begin
 ClearScreen;
 DemoDone:=false;
 TextOut(30,30,'Done');
 OnMouseMove:=Move;
 OnCLick:=Click;
 OnRightDown:=RightClick;
 repeat RefreshMessages until DemoDone;
 ClearScreen;
 OnMouseMove:=nil; OnClick:=nil; OnRightDown:=nil;
end;

procedure MenuHandler(I:Integer);
begin
 Write('  Menu entry :');
 Write(I);
end;

procedure Bizarre;
var i,j:integer;
begin
 for i:=1 to width do
   for j:=1 to height do
    pixels[i,j]:=i*i*j;
 TextOut(20,20,'A nice picture, isn''t it? Press any key to continue!');
end;

procedure Stars;
var i:integer;
begin
 ClearScreen;
 for i:=1 to 10000 do
  pixels[Random(width),random(height)]:=random(clWhite);
 Textout(20,20,'Stars. Welcome to wingraph system!');
end;

var Done:boolean=false;
procedure MenuDone; begin Done:=true end;

VAR Menu:Tmenu;
begin
 Menu:=TMenu.create(10,10,true);
with Menu do begin
 AddItem('Stars          ',Stars);
 AddItem('Bizarre picture',Bizarre);
 AddItem('Home demo      ',Home);
 AddItem('Text Output    ',TextO);
 AddItem('Dialog demo    ',Dialog);
 AddItem('Beep demo      ',Beep);
 AddItem('Mouse demo     ',mousetest);
 AddItem('Exit           ',MenuDone);
end;
 repeat
   ClearScreen;
   Brush.NewBrush(bsBDiagonal,clRed);
   FloodFill(1,1,clBlue);
   SetTextStyle(clYellow,clNavy,true);
   TextOut(30,30,'Use the keyboard');
   Menu.Execute;
   if Not done then ReadScan;
 until done;
end.
