unit Draw3d;

//////////////////////////////////////////
{    A unit for the WinGraph pack        }
{    for doing basic 3D graphics         }
{                                        }
{    Example programs ThreeDDRaw         }
//////////////////////////////////////////

interface
 uses WinGraph;
 type T3Dpoint=record
   X,Y,Z:integer end;

 procedure PutPixel3D(X,Y,Z:integer;Pixel:TColor);
 procedure Line3D(X1,Y1,Z1,X2,Y2,Z2:integer);
 procedure LineTo3D(X,Y,Z:integer);
 procedure MoveTo3D(X,Y,Z:integer);

implementation
const Q=0.8660254;

procedure ThreeD_to_TwoD(X,Y,Z:integer;var X2d,Y2d:integer);
begin
 X2d:=Round((X+Y)*Q);
 Y2d:=height div 2+(X-Y)div 2 -Z;
end;

procedure PutPixel3D(X,Y,Z:integer;Pixel:TColor);
var X2,Y2:integer;
begin
 ThreeD_to_TwoD(X,Y,Z,X2,Y2);
 Pixels[X2,Y2]:=Pixel;
end;

procedure Line3D(X1,Y1,Z1,X2,Y2,Z2:integer);
var x21,y21,x22,y22:integer;
begin
 ThreeD_to_TwoD(X1,Y1,Z1,x21,y21);
 ThreeD_to_TwoD(X2,Y2,Z2,x22,y22);
 Line(x21,y21,x22,y22);
end;

procedure lineTo3d(X,Y,Z:integer);
var X2,Y2:integer;
begin
 threeD_to_TwoD(X,Y,Z,X2,Y2);
 LineTo(X2,Y2);
end;

procedure MoveTo3d(X,Y,Z:integer);
var X2,Y2:integer;
begin
 ThreeD_to_TwoD(X,Y,Z,X2,Y2);
 MoveTo(X2,Y2);
end;

begin
end.