unit Win2kdlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CommDlg, Printers, CommCtrl;

const OFN_EX_PLACESBAR = 0;
      OFN_EX_NOPLACESBAR = 1;
      START_PAGE_GENERAL = 0;

type
  TOpenFileNameEx = packed record
    lStructSize: DWORD;
    hWndOwner: HWND;
    hInstance: HINST;
    lpstrFilter: PAnsiChar;
    lpstrCustomFilter: PAnsiChar;
    nmaxCustFilter: DWORD;
    nFilterIndex: DWORD;
    lpstrFile: PAnsiChar;
    nMaxFile: DWORD;
    lpstrFileTitle: PAnsiChar;
    nMaxFileTitle: DWORD;
    lpstrInitialDir: PAnsiChar;
    lpstrTitle: PAnsiChar;
    Flags: DWORD;
    nFileOffset: WOrd;
    nFileExtension: Word;
    lpstrDefExt: PAnsiChar;
    lCustData: LPARAM;
    lpfnHook: function(Wnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): UINT stdcall;
    lpTemplateName: PAnsiChar;
    pvReserved: Pointer;
    dwReserved: DWORD;
    FlagsEx: DWORD;
  end;

  HPropSheetPage = record
    lppsp: _PropSheetHeader;
  end;

  lpPrintPageRange = record
    nFromPage: DWORD;
    nToPage: DWORD;
  end;

  TPrintDlgEx = packed record
    lStructSize: DWORD;
    hWndOwner: HWND;
    hDevMode: HGLOBAL;
    hDevNames: HGLOBAL;
    hDC: HDC;
    Flags: DWORD;
    Flags2: DWORD;
    ExclusionFlags: DWORD;
    nPageRanges: DWORD;
    nMaxPageRanges: DWORD;
    lpPageRanges: lpPrintPageRange;
    nMinPage: Word;
    nMaxPage: Word;
    nCopies: Word;
    hInstance: HINST;
    lpPrintTemplateName: PWideChar;
    lpCallBack: Pointer;
    nPropertyPages: DWORD;
    lphPropertyPages: HPropSheetPage;
    nStartPage: DWORD;
    dwResultAction: DWORD;
  end;


type
  TOpenDialogEx = class(TOpenDialog)
  private
    FShowPlacesbar: boolean;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function Execute: boolean; override;
  published
    property ShowPlacesBar: boolean read FShowPlacesBar write FShowPlacesBar;
  end;

type
  TSaveDialogEx = class(TSaveDialog)
  private
    FShowPlacesbar: boolean;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function Execute: boolean; override;
  published
    property ShowPlacesBar: boolean read FShowPlacesBar write FShowPlacesBar;
  end;

type
  TPrintDialogEx = class(TPrintDialog)
  private
    FShowPrinterBar: boolean;
    function PrintInterceptor: Boolean;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function Execute: boolean; override;
  published
    property ShowPrintersbar: boolean read FShowPrinterBar write FShowPrinterBar;
  end;

procedure Register;

function GetOpenFileNameEx(var OpenFile: TopenFileNameEx): bool; stdcall;
function GetSaveFileNameEx(var SaveFile: TOpenFileNameEx): bool; stdcall;
//function PrintDlgEx(var PrintDlgRec: TPrintDlgEx): Bool; stdcall;

implementation

var CurInstShowPlaceBar: boolean;
    HookCtl3D: Boolean;

function GetOpenFileNameEx;     external 'comdlg32.dll' name 'GetOpenFileNameA';
function GetSaveFileNameEx;     external 'comdlg32.dll' name 'GetSaveFileNameA';
//function PrintDlgEx;            external 'comdlg32.dll' name 'PrintDlgExA';

{Printer functions ********************************************************}

procedure GetPrinter(var DeviceMode, DeviceNames: THandle);
var
  Device, Driver, Port: array[0..79] of char;
  DevNames: PDevNames;
  Offset: PChar;
begin
  Printer.GetPrinter(Device, Driver, Port, DeviceMode);
  if DeviceMode <> 0 then
  begin
    DeviceNames := GlobalAlloc(GHND, SizeOf(TDevNames) +
     StrLen(Device) + StrLen(Driver) + StrLen(Port) + 3);
    DevNames := PDevNames(GlobalLock(DeviceNames));
    try
      Offset := PChar(DevNames) + SizeOf(TDevnames);
      with DevNames^ do
      begin
        wDriverOffset := Longint(Offset) - Longint(DevNames);
        Offset := StrECopy(Offset, Driver) + 1;
        wDeviceOffset := Longint(Offset) - Longint(DevNames);
        Offset := StrECopy(Offset, Device) + 1;
        wOutputOffset := Longint(Offset) - Longint(DevNames);;
        StrCopy(Offset, Port);
      end;
    finally
      GlobalUnlock(DeviceNames);
    end;
  end;
end;

procedure SetPrinter(DeviceMode, DeviceNames: THandle);
var
  DevNames: PDevNames;
begin
  DevNames := PDevNames(GlobalLock(DeviceNames));
  try
    with DevNames^ do
      Printer.SetPrinter(PChar(DevNames) + wDeviceOffset,
        PChar(DevNames) + wDriverOffset,
        PChar(DevNames) + wOutputOffset, DeviceMode);
  finally
    GlobalUnlock(DeviceNames);
    GlobalFree(DeviceNames);
  end;
end;

function CopyData(Handle: THandle): THandle;
var
  Src, Dest: PChar;
  Size: Integer;
begin
  if Handle <> 0 then
  begin
    Size := GlobalSize(Handle);
    Result := GlobalAlloc(GHND, Size);
    if Result <> 0 then
      try
        Src := GlobalLock(Handle);
        Dest := GlobalLock(Result);
        if (Src <> nil) and (Dest <> nil) then Move(Src^, Dest^, Size);
      finally
        GlobalUnlock(Handle);
        GlobalUnlock(Result);
      end
  end
  else Result := 0;
end;

{******************************************************}

function IsWindows2000: boolean;
var ver: TOSVersionInfo;
begin
  Result := false;
  ver.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if not GetVersionEx(ver) then
    Exit;
  if (ver.dwPlatformID = VER_PLATFORM_WIN32_NT) then
    if (ver.dwMajorVersion >= 5) then
      Result := true;
end;


procedure Register;
begin
  RegisterComponents('Win2000', [TOpenDialogEx]);
  RegisterComponents('Win2000', [TSaveDialogEx]);
//  RegisterComponents('Win2000', [TPrintDialogEx]);
end;

{Print Dialog Functions}

(*procedure CenterWindow(Wnd: HWnd);
var
  Rect: TRect;
  Monitor: TMonitor;
begin
  GetWindowRect(Wnd, Rect);
  if Application.MainForm <> nil then
    Monitor := Application.MainForm.Monitor
  else
    Monitor := Screen.Monitors[0];
  SetWindowPos(Wnd, 0,
    Monitor.Left + ((Monitor.Width - Rect.Right + Rect.Left) div 2),
    Monitor.Top + ((Monitor.Height - Rect.Bottom + Rect.Top) div 3),
    0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
end;

{ Generic dialog hook. Centers the dialog on the screen in response to
  the WM_INITDIALOG message }

function DialogHook(Wnd: HWnd; Msg: UINT; WParam: WPARAM; LParam: LPARAM): UINT; stdcall;
begin
  Result := 0;
  case Msg of
    WM_INITDIALOG:
      begin
        if HookCtl3D then
        begin
          Subclass3DDlg(Wnd, CTL3D_ALL);
          SetAutoSubClass(True);
        end;
        CenterWindow(Wnd);
        CreationControl.FHandle := Wnd;
        CreationControl.FDefWndProc := Pointer(SetWindowLong(Wnd, GWL_WNDPROC,
          Longint(CreationControl.FObjectInstance)));
        CallWindowProc(CreationControl.FObjectInstance, Wnd, Msg, WParam, LParam);
        CreationControl := nil;
      end;
    WM_DESTROY:
      if HookCtl3D then SetAutoSubClass(False);
  end;
end;         *)


{done with these}


function OpenInterceptor(var DialogData: TOpenFileName): bool; stdcall;
var DialogDataEx: TOpenFileNameEx;
begin
  Move(DialogData, DialogDataEx, SizeOf(DialogData));
  if CurInstShowPlaceBar then
    DialogDataEx.FlagsEx := OFN_EX_PLACESBAR
  else
    DialogDataEx.FlagsEx := OFN_EX_NOPLACESBAR;
  DialogDataEx.lStructSize := SizeOf(TOpenFileNameEx);
  Result := GetOpenFileNameEx(DialogDataEx);
end;

function SaveInterceptor(var DialogData: TOpenFileName): bool; stdcall;
var DialogDataEx: TOpenFileNameEx;
begin
  Move(DialogData, DialogDataEx, SizeOf(DialogData));
  if CurInstShowPlaceBar then
    DialogDataEx.FlagsEx := OFN_EX_PLACESBAR
  else
    DialogDataEx.FlagsEx := OFN_EX_NOPLACESBAR;
  DialogDataEx.lStructSize := SizeOf(TOpenFileNameEx);
  Result := GetSaveFileNameEx(DialogDataEx);
end;

function TPrintDialogEx.PrintInterceptor: Boolean;
const
  PrintRanges: array[TPrintRange] of Integer =
    (PD_ALLPAGES, PD_SELECTION, PD_PAGENUMS);
var
  PrintDlgRec: TPrintDlgEx;
  DevHandle: THandle;
begin
//  PrintDlgEx(PrintDlgRec);
  FillChar(PrintDlgRec, SizeOf(PrintDlgRec), 0);
  with PrintDlgRec do
  begin


    lStructSize := sizeof(PrintDlgRec);
    hwndOwner := Application.Handle;
    hDevMode := 0;
    hDevNames := 0;
    hDC := 0;
    Flags := PD_ReturnDC or PD_Collate;
    Flags2 := 0;
    ExclusionFlags := 0;
    nMaxPageRanges := 10;
    lpPageRanges.nFromPage := 0;
    lpPageRanges.nToPage := 10;
    nMinPage := 1;
    nMaxPage := 1000;
    nCopies := 1;
    hInstance := 0;
    lpPrintTemplateName := nil;
    lpCallback := nil;
    nPropertyPages := 0;
//    lphPropertyPages.lppsp := null;
    nStartPage := Start_Page_General;
    dwResultAction := 0;

{

    lStructSize := SizeOf(PrintDlgRec);
    hInstance := SysInit.HInstance;
    GetPrinter(DevHandle, hDevNames);
    hDevMode := CopyData(DevHandle);
    hDevNames := 0;
    Flags := PD_ALLPAGES;
{    if Collate then Inc(Flags, PD_COLLATE);
    if not (poPrintToFile in Options) then Inc(Flags, PD_HIDEPRINTTOFILE);
    if not (poPageNums in Options) then Inc(Flags, PD_NOPAGENUMS);
    if not (poSelection in Options) then Inc(Flags, PD_NOSELECTION);
    if poDisablePrintToFile in Options then Inc(Flags, PD_DISABLEPRINTTOFILE);
    if PrintToFile then Inc(Flags, PD_PRINTTOFILE);
    if poHelp in Options then Inc(Flags, PD_SHOWHELP);
    if not (poWarning in Options) then Inc(Flags, PD_NOWARNING);}
 {   lpPageRanges.nFromPage := FromPage;
    lpPageRanges.nToPage := ToPage;
    nMinPage := MinPage;
    nMaxPage := MaxPage;
    nPropertyPages := 1;
    nStartPage := START_PAGE_GENERAL;
//    HookCtl3D := Ctl3D;
    hWndOwner := Application.Handle;
    Flags2 := 0;
//    Result := TaskModalDialog(@PrintDlgEx, PrintDlgRec);}
//    Result := PrintDlgEx(PrintDlgRec);
    if Result then
    begin
//      SetPrinter(hDevMode, hDevNames);
//      FCollate := Flags and PD_COLLATE <> 0;
//      FPrintToFile := Flags and PD_PRINTTOFILE <> 0;
//      if Flags and PD_SELECTION <> 0 then FPrintRange := prSelection else
//        if Flags and PD_PAGENUMS <> 0 then FPrintRange := prPageNums else
//          FPrintRange := prAllPages;
//      FFromPage := nFromPage;
//      FToPage := nToPage;
      if nCopies = 1 then
        Copies := Printer.Copies else
        Copies := nCopies;
    end
    else begin
      if hDevMode <> 0 then GlobalFree(hDevMode);
      if hDevNames <> 0 then GlobalFree(hDevNames);
    end;
  end;
end;


constructor TOpenDialogEx.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TOpenDialogEx.Execute: boolean;
begin
  if IsWindows2000 then
    begin
      CurInstShowPlaceBar := FShowPlacesBar;
      Result := DoExecute(@OpenInterceptor);
    end
  else
    Result := inherited Execute;
end;

{ TSaveDialogEx }

constructor TSaveDialogEx.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TSaveDialogEx.Execute: boolean;
begin
  if IsWindows2000 then
    begin
      CurInstShowPlaceBar := FShowPlacesBar;
      Result := DoExecute(@SaveInterceptor);
    end
  else
    Result := inherited Execute;
end;

{ TPrintDialogEx }

constructor TPrintDialogEx.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TPrintDialogEx.Execute: boolean;
begin
  if IsWindows2000 then
    begin
      CurInstShowPlacebar := FShowPrinterBar;
      Result := PrintInterceptor;
    end
  else
    Result := inherited Execute;
end;

end.
