unit WerPopupMenu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, RxMenus, vclutils;

type
  TWerPopupMenu = class(TRxPopupMenu)
  private
    { Private declarations }
    FTexto:string;
    FMarginColor:TColor;
  protected
    { Protected declarations }
     procedure DrawMargin(ARect: TRect); override;
  public
    constructor create(AOwner:TComponent); override;
  published
    { Published declarations }
    property MarginCaption : string read FTexto write FTexto;
    property MarginColor: TColor read FMarginColor write FMarginColor;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Werlon', [TWerPopupMenu]);
end;

constructor TWerPopupMenu.create(AOwner:TComponent);
begin
  inherited create(AOwner);
  FMarginColor:=clLime;
end;

Procedure TWerPopupMenu.DrawMargin;
begin
  if Assigned(OnDrawMargin) then OnDrawMargin(Self, ARect)
  else begin
    with Canvas.Font do begin
      Name := 'Courier New';
      Style := [fsBold];
      Size := 20;
      Color := clWhite;
      Handle := CreateRotatedFont(Canvas.Font, 90);
    end;
    DefaultDrawMargin(ARect, FMarginColor, RGB(
      GetRValue(FMarginColor) div 4,
      GetGValue(FMarginColor) div 4,
      GetBValue(FMarginColor) div 4));
    SetBkMode(Canvas.Handle, TRANSPARENT);
    ExtTextOut(Canvas.Handle, ARect.Left, ARect.Bottom - 5, ETO_CLIPPED,
      @ARect, PChar(FTexto), Length(FTexto), nil);
  end;
end;

end.
