unit weblike;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TWebButton = class(TBitBtn)
  private
    FMouseIn : boolean;
    FFont    : TFont;
    FSaveFont : TFont;
    procedure SetFFont(Value:TFont);
  protected
    procedure CMMouseEnter(var msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var msg: TMessage); message CM_MOUSELEAVE;
  public
    { Public declarations }
    constructor Create(Aowner : TComponent); override;
    destructor Destroy; override;
    procedure Repaint; override;
  published
    { Published declarations }
    property FocusFont : TFont read FFont write SetFFont;
  end;


type
  TWebLabel = class(TLabel)
  private
    FMouseIn : boolean;
    FFont    : TFont;
    FSaveFont : TFont;
    procedure SetFFont(Value:TFont);
  protected
    procedure CMMouseEnter(var msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var msg: TMessage); message CM_MOUSELEAVE;
  public
    { Public declarations }
    constructor Create(Aowner : TComponent); override;
    destructor Destroy; override;
    procedure Repaint; override;
  published
    { Published declarations }
    property FocusFont : TFont read FFont write SetFFont;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Freeware', [TWebButton,TWebLabel]);
end;

constructor TWebButton.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FFont := TFont.Create;
  FSaveFont := TFont.Create;
end;

destructor TWebButton.Destroy;
begin;
  FSaveFont.Free;
  FFont.Free;
  inherited;
end;

procedure TWebButton.SetFFont(Value:TFont);
begin
     if Value<>FFont then FFont.Assign(Value);
end;

procedure TWebButton.CMMouseEnter(var msg: TMessage);
begin
     FMouseIn := True;
     Repaint;
end;

procedure TWebButton.CMMouseLeave(var msg: TMessage);
begin
     FMouseIn := False;
     Repaint;
end;

procedure TWebButton.Repaint;
begin
   if not (csDesigning in ComponentState) then
     if FMouseIn and Assigned(FFont) then begin
        FSaveFont.Assign(Font);
        Font.Assign(FocusFont);
     end else if Assigned(FSaveFont) then
        Font.Assign(FSaveFont);
     inherited;
end;

constructor TWebLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FFont := TFont.Create;
  FSaveFont := TFont.Create;
end;

destructor TWebLabel.Destroy;
begin;
  FSaveFont.Free;
  FFont.Free;
  inherited;
end;

procedure TWebLabel.SetFFont(Value:TFont);
begin
     if Value<>FFont then FFont.Assign(Value);
end;

procedure TWebLabel.CMMouseEnter(var msg: TMessage);
begin
     FMouseIn := True;
     Repaint;
end;

procedure TWebLabel.CMMouseLeave(var msg: TMessage);
begin
     FMouseIn := False;
     Repaint;
end;

procedure TWebLabel.Repaint;
begin
   if not (csDesigning in ComponentState) then
     if FMouseIn and Assigned(FFont) then begin
        FSaveFont.Assign(Font);
        Font.Assign(FocusFont);
     end else if Assigned(FSaveFont) then
        Font.Assign(FSaveFont);
     inherited;
end;

end.
