{
This component is web address label.
Web adres label!
izzet uslu
istanbul-TURKEY
http://members.xoom.com/izus
izus6@hotmail.com

If mouse on label and click mouse button when open web browser with web address.
Eger fare labelin uzerindeyken tiklarsaniz, web adresini acmis olursunuz.

Adding on TLabel component / Ilave edilenler:
   * property GotoWebAddress
   * property WebAddress
   * property WindowShowStyle
}
unit WebLabel;
{$R WebLabel.res}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,dsgnintf,ShellAPI;

type

  TAboutizusWebLabelInfo = class(TPropertyEditor)
  private
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TWindowShowStyle = (swMaximize,swMinimize,swNormal);

  TizusWebLabel = class(TLabel)
  private
    { Private declarations }
    FAbout           : TAboutizusWebLabelInfo;
    fGotoWebAddress  : boolean;
    fWebAddress      : string;
    fWindowShowStyle : TWindowShowStyle;
  protected
    { Protected declarations }
    OldColor: TColor;
    OldStyle: TFontStyles;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    { Published declarations }
    property About : TAboutizusWebLabelInfo read FAbout write FAbout;
    property GotoWebAddress : boolean read fGotoWebAddress write fGotoWebAddress;
    property WebAddress : string read fWebAddress write fWebAddress;
    property WindowShowStyle : TWindowShowStyle read fWindowShowStyle write fWindowShowStyle;
  end;

procedure Register;

implementation

{ TAboutizusWebLabelInfo }

procedure TAboutizusWebLabelInfo.Edit;
begin
  Application.MessageBox('By izzet uslu - 2000'#13#13'E-Mail : izus6@hotmail.com'#13'WEB : http://members.xoom.com/izus','Web Label component version 1.0', MB_OK+ MB_ICONINFORMATION);
end;

function TAboutizusWebLabelInfo.GetAttributes: TPropertyAttributes;
begin
  GetAttributes:=[paDialog, paReadOnly];
end;

function TAboutizusWebLabelInfo.GetValue: string;
begin
  GetValue:='(About)';
end;

{ TizusWebLabel }
constructor TizusWebLabel.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  OldColor := Font.Color;
  OldStyle := Font.Style;
  fGotoWebAddress := true;
  fWebAddress := 'http://members.xoom.com/izus';
  fWindowShowStyle := swMaximize;
  Width := 79;
end;

destructor TizusWebLabel.Destroy;
begin
  inherited Destroy;
end;

procedure TizusWebLabel.CMMouseEnter(var Message: TMessage);
begin
  Font.Color := clBlue;
  Font.Style := [fsUnderline];
end;

procedure TizusWebLabel.CMMouseLeave(var Message: TMessage);
begin
  Font.Color := OldColor;
  Font.Style := OldStyle;
end;

procedure TizusWebLabel.Click;
var ShowStyle : integer;
begin
  ShowStyle := SW_MAXIMIZE;
  if fWindowShowStyle = swMinimize then ShowStyle := SW_MINIMIZE;
  if fWindowShowStyle = swNormal then ShowStyle := SW_NORMAL;
  if fGotoWebAddress then
     ShellExecute(0, nil, pchar(fWebAddress), nil, nil, showStyle);
end;

procedure Register;
begin
  RegisterComponents('izus', [TizusWebLabel]);
  RegisterPropertyEditor(TypeInfo(TAboutizusWebLabelInfo), TizusWebLabel, 'ABOUT', TAboutizusWebLabelInfo);
end;


end.
