unit DDemoFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, WebFileInfo;

type
  TfrmMain = class(TForm)
    edtCustom: TEdit;
    Memo1: TMemo;
    lblDFSName: TLabel;
    lblDFSAuthor: TLabel;
    lblDFSDate: TLabel;
    lblDFSVersion: TLabel;
    lblDFSReadMe: TLabel;
    lblDFSURL: TLabel;
    gbxFiles: TGroupBox;
    gbxProxy: TGroupBox;
    gbxInfo: TGroupBox;
    radCustom: TRadioButton;
    btnGet: TButton;
    btnCheckUpdate: TButton;
    Label6: TLabel;
    Label7: TLabel;
    edtProxyHost: TEdit;
    edtProxyPort: TEdit;
    WebFileInfo: TWebFileInfo;
    radISE: TRadioButton;
    radSM: TRadioButton;
    procedure radioButtonClick(Sender: TObject);
    procedure btnGetClick(Sender: TObject);
    procedure btnCheckUpdateClick(Sender: TObject);
    procedure edtCustomChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.radioButtonClick(Sender: TObject);
var
  tabOrder: Integer;

begin

  tabOrder := TRadioButton(Sender).TabOrder;

  if (tabOrder < 19) then begin
    edtCustom.Text := Memo1.Lines.Strings[tabOrder];
    edtCustom.SelectAll;
  end;

end;

procedure TfrmMain.btnGetClick(Sender: TObject);
begin

  if (Length(edtCustom.Text) = 0) then begin
    MessageDlg('Select a file first!', mtInformation, [mbOK], 0);
    Exit;
  end;

  Screen.Cursor := crHourGlass;

  if (Length(edtProxyHost.Text) > 0) then
    WebFileInfo.ProxyHost := edtProxyHost.Text;

  if (Length(edtProxyPort.Text) > 0) then
    WebFileInfo.ProxyPort := StrToInt(edtProxyPort.Text);

  WebFileInfo.HomeURL := edtCustom.Text;

  if WebFileInfo.GetFileInfo = false then begin
    Screen.Cursor := crDefault;
    ShowMessage('Get Info failed due to:' + #13 + WebFileInfo.LastError);
    Exit;
  end;

  Screen.Cursor := crDefault;

  lblDFSName.Caption    := WebFileInfo.ProductName;
  lblDFSAuthor.Caption  := WebFileInfo.ProductAuthor;
  lblDFSDate.Caption    := WebFileInfo.ProductDateStr;
  lblDFSVersion.Caption := WebFileInfo.ProductVersion;
  lblDFSReadMe.Caption  := WebFileInfo.ProductReadMe;
  lblDFSURL.Caption     := WebFileInfo.DownloadURL;

end;

procedure TfrmMain.btnCheckUpdateClick(Sender: TObject);
begin

  btnGetClick(Sender);

  if WebFileInfo.Active = true then
    WebFileInfo.CheckForUpdate();

end;

procedure TfrmMain.edtCustomChange(Sender: TObject);
begin
  if ActiveControl <> edtCustom then Exit;
  radCustom.Checked := True;
end;

end.
