//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "CDemoFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "WebFileInfo"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::radioButtonClick(TObject *Sender)
{

  int tabOrder = dynamic_cast<TRadioButton*>(Sender)->TabOrder;

  if (tabOrder < 19)  {
    edtCustom->Text = Memo1->Lines->Strings[tabOrder];
    edtCustom->SelectAll();
  }

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnGetClick(TObject *Sender)
{

  if (edtCustom->Text.Length() == 0)  {
    MessageDlg("Select a file first!", mtInformation, TMsgDlgButtons() << mbOK, 0);
    return;
  }

  Screen->Cursor = crHourGlass;

  if (edtProxyHost->Text.Length() > 0)  {
    WebFileInfo->ProxyHost = edtProxyHost->Text;
  }

  if (edtProxyPort->Text.Length() > 0)  {
    WebFileInfo->ProxyPort = StrToInt(edtProxyPort->Text);
  }

  WebFileInfo->HomeURL = edtCustom->Text;

  if (WebFileInfo->GetFileInfo() == false)  {
    Screen->Cursor = crDefault;
    ShowMessage("Get Info failed due to:\n" + WebFileInfo->LastError);
    return;
  }

  Screen->Cursor = crDefault;

  lblDFSName->Caption      = WebFileInfo->ProductName;
  lblDFSAuthor->Caption    = WebFileInfo->ProductAuthor;
  lblDFSDate->Caption      = WebFileInfo->ProductDateStr;
  lblDFSVersion->Caption   = WebFileInfo->ProductVersion;
  lblDFSReadMe->Caption    = WebFileInfo->ProductReadMe;
  lblDFSURL->Caption       = WebFileInfo->DownloadURL;

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::edtCustomChange(TObject *Sender)
{
  if (ActiveControl != edtCustom)  { return; }

  radCustom->Checked = true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnCheckUpdateClick(TObject *Sender)
{

  btnGetClick(Sender);

  if (WebFileInfo->Active == false) { return; }

  WebFileInfo->CheckForUpdate();

}
//---------------------------------------------------------------------------

