unit UWatchTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,Watch, ExtCtrls;

type
  TForm1 = class(TForm)
    lb: TListBox;
    Panel1: TPanel;
    Watch1: TWatch;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    bExit: TButton;
    bClear: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Watch1ActivateShellWindow(Sender: TObject; Handle: Integer; AppName:String);
    procedure Watch1WindowActivated(Sender: TObject; Handle: Integer; AppName:String);
    procedure Watch1WindowCreated(Sender: TObject; Handle: Integer; AppName:String);
    procedure Watch1WindowDestroyed(Sender: TObject; Handle: Integer; AppName:String);
    procedure Watch1KeyNative(Sender: TObject; wParam, lParam: Integer);
    procedure bExitClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure lbDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
                                          
implementation

{$R *.DFM}


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if Watch1<>nil then
  Watch1.Destroy;
end;

procedure TForm1.Watch1ActivateShellWindow(Sender: TObject;
  Handle: Integer; AppName:String);
begin
 lb.Items.Add('Shell Activated "'+AppName+'"');
 LB.TopIndex:=LB.Items.count-1;
end;

procedure TForm1.Watch1WindowActivated(Sender: TObject;
  Handle: Integer; AppName:String);
begin
 lb.Items.Add('Activated "'+AppName+'"');
 LB.TopIndex:=LB.Items.count-1;
end;

procedure TForm1.Watch1WindowCreated(Sender: TObject;
  Handle: Integer; AppName:String);
begin
 lb.Items.Add('Created "'+AppName+'"');
 LB.TopIndex:=LB.Items.count-1;
end;

procedure TForm1.Watch1WindowDestroyed(Sender: TObject;
  Handle: Integer; AppName:String);
begin
 lb.Items.Add('Destroyed "'+AppName+'"');
 LB.TopIndex:=LB.Items.count-1;
end;

procedure TForm1.Watch1KeyNative(Sender: TObject; wParam,
  lParam: Integer);
var ki:TKeyInfo;

 function b(bo:Boolean):String;
 begin
  if bo then result:='True ' else result:='False';
 end;
begin
 Watch1.getKeyInfo(lParam,ki);
 lb.Items.Add('Key '+Watch1.getVKString(wParam)+' ,'+IntToHex(lParam,8));
 lb.Items.Add('    Repeat:'+IntToStr(ki.RepeatCount)
              +' Scan Code:'+IntToStr(ki.ScanCode)
              +' Extended:'+b(ki.Extended)
              +' Alt:'+b(ki.AltDown)
              +' PrevDown:'+b(ki.PreviousDown)
              +' Down:'+b(ki.Down)
              +' Name:'+ki.KeyNameText);
 LB.TopIndex:=LB.Items.count-1;
end;


procedure TForm1.bExitClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 if (Sender as TCheckBox).checked then
 begin
  Watch1.OnWindowActivated:=Watch1WindowActivated;
  Watch1.OnWindowCreated:=Watch1WindowCreated;
  Watch1.OnWindowDestroyed:=Watch1WindowDestroyed;
  Watch1.OnActivateShellWindow:=Watch1ActivateShellWindow;
  Watch1.OnKeyNative:=Watch1KeyNative;
 end
 else
 begin    
  Watch1.OnWindowActivated:=nil;
  Watch1.OnWindowCreated:=nil;
  Watch1.OnWindowDestroyed:=nil;
  Watch1.OnActivateShellWindow:=nil;
  Watch1.OnKeyNative:=nil;
 end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 if (Sender as TCheckBox).checked then
 begin
  Watch1.OnKeyNative:=Watch1KeyNative;
 end
 else
 begin
  Watch1.OnKeyNative:=nil;
 end;
end;

procedure TForm1.lbDblClick(Sender: TObject);
begin
 lb.items.clear;
end;

end.
