unit DOS;

//  DOS Unit for DELPHI
//  Copyright (C) 1998 - Pasquale Morvillo
//  Interface to PASW32.DLL

interface
{$H-}
uses System32, SysUtils, Windows;

const
  DLLname='PASW32.DLL';
{ Flags bit masks }

  FCarry     = $0001;
  FParity    = $0004;
  FAuxiliary = $0010;
  FZero      = $0040;
  FSign      = $0080;
  FOverflow  = $0800;

{ File mode magic numbers }

  fmClosed = $D7B0;
  fmInput  = $D7B1;
  fmOutput = $D7B2;
  fmInOut  = $D7B3;

{ File attribute constants }

  ReadOnly  = $01;
  Hidden    = $02;
  SysFile   = $04;
  VolumeID  = $08;
  Directory = $10;
  Archive   = $20;
  AnyFile   = $3F;

type

{ String types }

  ComStr  = string;          { Command line string }
  PathStr = string;          { Full file path string }
  DirStr  = string;          { Drive and directory string }
  NameStr = string;          { File name string }
  ExtStr  = string;          { File extension string }

{ Registers record used by Intr and MsDos }

  Registers = record
               case Integer of
                    0: (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: Word);
                    1: (AL,AH,BL,BH,CL,CH,DL,DH: Byte);
               end;
{ Typed-file and untyped-file record }

  FileRec = record
              Handle: Word;
              Mode: Word;
              RecSize: Word;
              Private: array[1..26] of Byte;
              UserData: array[1..16] of Byte;
              Name: array[0..79] of Char;
            end;

{ Textfile record }

  TextBuf = array[0..127] of Char;
  TextRec = record
              Handle: Word;
              Mode: Word;
              BufSize: Word;
              Private: Word;
              BufPos: Word;
              BufEnd: Word;
              BufPtr: ^TextBuf;
              OpenFunc: Pointer;
              InOutFunc: Pointer;
              FlushFunc: Pointer;
              CloseFunc: Pointer;
              UserData: array[1..16] of Byte;
              Name: array[0..79] of Char;
              Buffer: TextBuf;
            end;

{ Search record used by FindFirst and FindNext }

     SearchRec = record
		Time: Integer;
		Size: Integer;
		Attr: Integer;
		Name: AnsiString;
		ExcludeAttr: Integer;
		FindHandle: THandle;
		FindData: TWin32FindData;
     end;


{ Date and time record used by PackTime and UnpackTime }

  DateTime = record
               Year,Month,Day,Hour,Min,Sec: Word;
             end;

var
     DosError: Integer;

function  DosVersion: Integer;    //return OS version
          stdcall; external DLLname name 'DosVersion';
procedure Intr(IntNo: Byte; var Regs: Registers); //dummy; not supported
          stdcall; external DLLname name 'Intr';
procedure MsDos(var Regs: Registers);             //dummy; not supported
          stdcall; external DLLname name 'MsDos';
procedure GetDate(var Year,Month,Day,DayOfWeek: Word);
          stdcall; external DLLname name 'GetDate';
procedure SetDate(Year,Month,Day: Word);
          stdcall; external DLLname name 'SetDate';
procedure GetTime(var Hour,Minute,Second,Sec100: Word);
          stdcall; external DLLname name 'GetTime';
procedure SetTime(Hour,Minute,Second,Sec100: Word);
          stdcall; external DLLname name 'SetTime';
procedure GetCBreak(var Break: Boolean);
          stdcall; external DLLname name 'GetCBreak';
procedure SetCBreak(Break: Boolean);
          stdcall; external DLLname name 'SetCBreak';
procedure GetVerify(var Verify: Boolean);
          stdcall; external DLLname name 'GetVerify';
procedure SetVerify(Verify: Boolean);
          stdcall; external DLLname name 'SetVerify';
// in diskfree and disksize the return value is comp
// and not longint for compatibility with partitions
// grater than 2Gb
function  DiskFree(Drive: Byte): Comp;
          stdcall; external DLLname name 'DiskFree';
function  DiskSize(Drive: Byte): Comp;
          stdcall; external DLLname name 'DiskSize';
procedure GetFAttr(var F; var Attr: Word);
          stdcall; external DLLname name 'GetFAttr';
procedure SetFAttr(var F; Attr: Word);
          stdcall; external DLLname name 'SetFAttr';
procedure GetFTime(var F; var Time: Longint);
          stdcall; external DLLname name 'GetFTime';
procedure SetFTime(var F; Time: Longint);
          stdcall; external DLLname name 'SetFTime';
procedure FindFirst(Path: PathStr; Attr: Word; var F: SearchRec);
          stdcall; external DLLname name 'FindFirst';
procedure FindNext(var F: SearchRec);
          stdcall; external DLLname name 'FindNext';
procedure UnpackTime(P: Longint; var T: DateTime);
          stdcall; external DLLname name 'UnpackTime';
procedure PackTime(var T: DateTime; var P: Longint);
          stdcall; external DLLname name 'PackTime';
procedure GetIntVec(IntNo: Byte; var Vector: Pointer); //dummy; not supported
          stdcall; external DLLname name 'GetIntVec';
procedure SetIntVec(IntNo: Byte; Vector: Pointer);     //dummy; not supported
          stdcall; external DLLname name 'SetIntVec';
procedure SwapVectors;
          stdcall; external DLLname name 'SwapVectors';
procedure Keep(ExitCode: Word);
          stdcall; external DLLname name 'Keep';
procedure Exec(Path: PathStr; ComLine: ComStr);
          stdcall; external DLLname name 'Exec';
function  DosExitCode: Word;
          stdcall; external DLLname name 'DosExitCode';
function  FSearch(Path: PathStr; DirList: String): PathStr;
          stdcall; external DLLname name 'FSearch';
function  FExpand(Path: PathStr): PathStr;
          stdcall; external DLLname name 'FExpand';
procedure FSplit(Path: PathStr; var Dir: DirStr; var Name: NameStr; var Ext: ExtStr);
          stdcall; external DLLname name 'FSplit';
function  EnvCount: Integer;
          stdcall; external DLLname name 'EnvCount';
function  EnvStr(Index: Integer): String;
          stdcall; external DLLname name 'EnvStr';
function  GetEnv(EnvVar: String): String;
          stdcall; external DLLname name 'GetEnv';
procedure InitDosW32(pDE: pointer);
          stdcall; external DLLname name 'InitDosW32';

implementation

begin
     InitDosW32(@DosError);
end.
