unit CRT;
//  CRT Unit for DELPHI
//  Copyright (C) 1998 - Pasquale Morvillo
//  Interface to PASW32.DLL
interface

uses System32;

CONST
     { screen modes }
     BW40 = 0;
     CO40 = 1;
     C40  = CO40;
     BW80 = 2;
     CO80 = 3;
     C80  = CO80;
     MONO = 7;
     FONT8x8 = 256;
{Dark Colors: Foreground and Background}
     BLACK          = 0;
     BLUE           = 1;
     GREEN          = 2;
     CYAN           = 3;
     RED            = 4;
     MAGENTA        = 5;
     BROWN          = 6;
     LIGHTGRAY      = 7;
{Light Colors : Foreground only}
     DARKGRAY       = 8;
     LIGHTBLUE      = 9;
     LIGHTGREEN     = 10;
     LIGHTCYAN      = 11;
     LIGHTRED       = 12;
     LIGHTMAGENTA   = 13;
     YELLOW         = 14;
     WHITE          = 15;


     BLINK          = 128;


const
     CheckBreak : Boolean = True;     // Ctrl-C / Ctrl-break checking
     CheckEOF   : Boolean = False;    // Ctrl-Z checking
     DirectVideo: Boolean = True;     // dummy
     CheckSnow  : Boolean = True;     // dummy

var
     LastMode      : Word;            // Last screen text mode
     TextAttr      : Byte;            // Current text attributes
     WindMin,                         // Left-top corner
     WindMax       : Word;            // Right-bottom corner

const
     DLLname='PASW32.DLL';

procedure AssignCrt(var f: Text);
          stdcall; external DLLname name 'AssignCrt';
procedure ClrScr;
          stdcall; external DLLname name 'ClrScr';
procedure ClrEol;
          stdcall; external DLLname name 'ClrEol';
procedure Delay(MS: Cardinal);
          stdcall; external DLLname name 'Delay';
procedure DelLine;
          stdcall; external DLLname name 'DelLine';
procedure GotoXY(X,Y : byte);
          stdcall; external DLLname name 'GotoXY';
procedure HighVideo;
          stdcall; external DLLname name 'HighVideo';
procedure InsLine;
          stdcall; external DLLname name 'InsLine';
function  KeyPressed: boolean;
          stdcall; external DLLname name 'KeyPressed';
procedure LowVideo;
          stdcall; external DLLname name 'LowVideo';
procedure NormVideo;
          stdcall; external DLLname name 'NormVideo';
procedure NoSound;
          stdcall; external DLLname name 'NoSound';
function  ReadKey: char;
          stdcall; external DLLname name 'ReadKey';
procedure Sound(Hz: integer);
          stdcall; external DLLname name 'Sound';
procedure TextBackground(Color: byte);
          stdcall; external DLLname name 'TextBackground';
procedure TextColor(Color: byte);
          stdcall; external DLLname name 'TextColor';
procedure TextMode(Mode: smallint);
          stdcall; external DLLname name 'TextMode';
function  WhereX: byte;
          stdcall; external DLLname name 'WhereX';
function  WhereY: byte;
          stdcall; external DLLname name 'WhereY';
procedure Window(x1,y1,x2,y2: byte);
          stdcall; external DLLname name 'Window';

procedure SetCursorSize(Size: byte);
          stdcall; external DLLname name 'SetCursorSize';
function  GetCursorSize: byte;
          stdcall; external DLLname name 'GetCursorSize';
procedure ShowCursor;
          stdcall; external DLLname name 'ShowCursor';
procedure HideCursor;
          stdcall; external DLLname name 'HideCursor';

implementation

procedure InitCrtW32(pCB,pCE,pLM,pTA,pWM1,pWM2: pointer);
          stdcall; external DLLname name 'InitCrtW32';

initialization
     AssignCrt(Input);  Reset(Input);
     AssignCrt(Output); ReWrite(Output);
     InitCrtW32(@CheckBreak,@CheckEOF,@LastMode,@TextAttr,@WindMin,@WindMax);
finalization
     NormVideo;
end.
