unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, video32;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Video1: TVideo;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button6: TButton;
    Button7: TButton;
    Button1: TButton;
    Button5: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Video1VideoFrame(TimeStamp: TDateTime;
      biHdr: PBitmapInfoHeader; biHdrSize: Integer; biBits: PChar;
      biBitsSize: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Video1VideoFrameBmp(TimeStamp: TDateTime; Bitmap: TBitmap);
    procedure Video1VideoStamp(var AValue: string);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private declarations }
    Bitmap : TBitmap;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 Bitmap := TBitmap.Create;
 Bitmap.width := 200;
 Bitmap.Height := 200;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Video1.CloseVideo;
 Bitmap.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
 i : integer;
begin
  // WARNING for parameter 1 must be changed
  // to Your PC's Video Device Id
  // I have 2 video capture devices so 1 is the correct for me
  
  Video1.OpenVideo(i8bits, 1);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Video1.CloseVideo;

end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 Video1.DlgVideoFormat(Handle);
end;

procedure TForm1.Video1VideoFrame(TimeStamp: TDateTime;
  biHdr: PBitmapInfoHeader; biHdrSize: Integer; biBits: PChar;
  biBitsSize: Integer);
begin

  Video1.DefaultDraw;
{
  Video1.DrawFrame(Canvas.Handle,
                  0, 0, 160, 120,
                  0, 0, biHdr^.biWidth, biHdr^.biHeight);
}
end;

procedure TForm1.Video1VideoFrameBmp(TimeStamp: TDateTime;
  Bitmap: TBitmap);
begin
  Image1.Picture.Bitmap.Canvas.Brush.Style := bsClear;
  Image1.Picture.Bitmap.Assign(Bitmap);
end;

procedure TForm1.Video1VideoStamp(var AValue: string);
begin
  AValue := FormatDateTime('dd-mmmm-yy hh:mi:ss', now);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  Video1.Overlay := True;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Video1.Preview := True;

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Video1.DlgDisplayFormat( Handle );
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Video1.DlgCompressorChoose( Handle );

end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  Video1.AviFile := 'c:\test.avi';
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  Video1.AviFile := '';

end;

end.
