unit EdParam;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fDlgStd, StdCtrls, ExtCtrls, DB, DBTables;

type
  TEditParamForm = class(TDialogForm)
    lbParam: TLabel;
    edParam: TEdit;
    chNull: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    FParam: TParam;
  public
    { Public declarations }
  end;

procedure EditParam(AParam: TParam);

implementation

{$R *.DFM}

procedure EditParam(AParam: TParam);
begin
  with TEditParamForm.Create(nil) do
  try
    FParam := AParam;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TEditParamForm.FormCreate(Sender: TObject);
begin
  inherited;
  lbParam.Caption := Format('%s: ', [FParam.Name]);
  edParam.Text := FParam.Text;
end;

procedure TEditParamForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  if ModalResult = mrOK then
  begin
    if chNull.Checked then
    begin
      FParam.Clear;
      FParam.Bound := True;
    end else
      FParam.AsString := edParam.Text;
  end;
end;

end.


