unit Script_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Script Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Script: TGUID = '{00EA46A4-2712-11D3-B5BF-4854E828D2EB}';

const

{ Component class GUIDs }
  Class_ScriptObject: TGUID = '{00EA46A6-2712-11D3-B5BF-4854E828D2EB}';

type

{ Forward declarations: Interfaces }
  IScriptObject = interface;
  IScriptObjectDisp = dispinterface;

{ Forward declarations: CoClasses }
  ScriptObject = IScriptObject;

{ Dispatch interface for ScriptObject Object }

  IScriptObject = interface(IDispatch)
    ['{00EA46A5-2712-11D3-B5BF-4854E828D2EB}']
    procedure ShowMessage(Msg: OleVariant); safecall;
  end;

{ DispInterface declaration for Dual Interface IScriptObject }

  IScriptObjectDisp = dispinterface
    ['{00EA46A5-2712-11D3-B5BF-4854E828D2EB}']
    procedure ShowMessage(Msg: OleVariant); dispid 1;
  end;

{ ScriptObjectObject }

  CoScriptObject = class
    class function Create: IScriptObject;
    class function CreateRemote(const MachineName: string): IScriptObject;
  end;



implementation

uses ComObj;

class function CoScriptObject.Create: IScriptObject;
begin
  Result := CreateComObject(Class_ScriptObject) as IScriptObject;
end;

class function CoScriptObject.CreateRemote(const MachineName: string): IScriptObject;
begin
  Result := CreateRemoteComObject(MachineName, Class_ScriptObject) as IScriptObject;
end;


end.
