(* ----------------------------------------------------------------------------

 This component can be freely used and distributed in commercial and private
 environments, provided this notice is not modified in any way.
 Feel free to contact us if you have any questions, comments or suggestions at
 TRSOFT@Menden.net

    Copyright  1998 by TRSOFT  All Rights Reserved.
    Thomas Radtke Software Entwicklung.
    http://www.abcnet.de/TRSOFT/

  THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
  EITHER EXPRESSED OR IMPLIED.

 FULL SOURCE $10 ,please Mail TRSOFT@Menden.net

-----------------------------------------------------------------------------*)

unit VGA;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TVGA = class(TComponent)

  public
        constructor Create(AOwner:TComponent);override;
        destructor Destroy;override;
        function HFREQ   : Word;
        function VFREQ   : Word;
        function REFRESH : Word;
        function INTLV   : Boolean;
   end;

procedure Register;

implementation

var
   hInst16: THandle;
   GFSR: Pointer;

function LoadLibrary16(LibraryName: PChar): THandle;
                  stdcall; external kernel32 index 35;
procedure FreeLibrary16(HInstance: THandle);
                   stdcall; external kernel32 index 36;
function GetProcAddress16(Hinstance: THandle; ProcName: PChar): Pointer;
                  stdcall; external kernel32 index 37;
procedure QT_Thunk;cdecl; external kernel32 name 'QT_Thunk';

procedure Register;
begin
  RegisterComponents('TRSOFT_6', [TVGA]);
end;

constructor TVGA.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
end;

Destructor TVGA.Destroy;
begin
   inherited Destroy;
end;

function TVGA.HFREQ   : Word;
var
  ThunkTrash: array[0..$20] of Word;
begin
  ThunkTrash[0] := hInst16;

hInst16 := LoadLibrary16('TRSOFT.DLL');
  if hInst16 < 32 then
    raise Exception.Create('Cannot load TRSOFT.DLL ');

GFSR := GetProcAddress16(hInst16,'HKHZ');
  if not Assigned(GFSR) then
    raise Exception.Create('Cannot get address of HKHZ');

  asm
    mov edx, GFSR
    call QT_Thunk
    mov result,ax
  end;
FreeLibrary16(hInst16);

end;

function TVGA.VFREQ   : Word;
var
  ThunkTrash: array[0..$20] of Word;
begin
  ThunkTrash[0] := hInst16;

hInst16 := LoadLibrary16('TRSOFT.DLL');
  if hInst16 < 32 then
    raise Exception.Create('Cannot load TRSOFT.DLL ');

GFSR := GetProcAddress16(hInst16,'VKHZ');
  if not Assigned(GFSR) then
    raise Exception.Create('Cannot get address of VKHZ');

  asm
    mov edx, GFSR
    call QT_Thunk
    mov result,ax
  end;
FreeLibrary16(hInst16);

end;

function TVGA.REFRESH : Word;
var
  ThunkTrash: array[0..$20] of Word;
begin
  ThunkTrash[0] := hInst16;

hInst16 := LoadLibrary16('TRSOFT.DLL');
  if hInst16 < 32 then
    raise Exception.Create('Cannot load TRSOFT.DLL ');

GFSR := GetProcAddress16(hInst16,'FLIMMER');
  if not Assigned(GFSR) then
    raise Exception.Create('Cannot get address of FLIMMER');

  asm
    mov edx, GFSR
    call QT_Thunk
    mov result,ax
  end;
FreeLibrary16(hInst16);

end;

function TVGA.INTLV   : Boolean;
var
  ThunkTrash: array[0..$20] of Word;
  Erg :Word;
begin
  ThunkTrash[0] := hInst16;

hInst16 := LoadLibrary16('TRSOFT.DLL');
  if hInst16 < 32 then
    raise Exception.Create('Cannot load TRSOFT.DLL ');

GFSR := GetProcAddress16(hInst16,'INTERL');
  if not Assigned(GFSR) then
    raise Exception.Create('Cannot get address of INTERL');

  asm
    mov edx, GFSR
    call QT_Thunk
    mov Erg,ax
  end;
FreeLibrary16(hInst16);
if Erg=1
  then result:=True
  else result:=False;
end;

end.
