unit VertStatBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DsgnIntf, VertStatBarEditorForm;

type

  TTextAlign = (talTop, talBottom, talCenter);

  TVertStatBar = class(TCustomControl)
  private
    { Private declarations }
    FCap : String;
    FTA : TTextAlign;
    procedure SetCap(Cap : String);
    procedure SetTal(al : TTextAlign);
  protected
    { Protected declarations }
    constructor Create(AOwner: TComponent); Override;
    procedure Paint; Override;
  public
    { Public declarations }
  published
    { Published declarations }
   Property Align;
   Property Caption : String read FCap Write SetCap;
   Property TextAlign : TTextAlign read FTA write SetTal;
   Property Color;
   Property OnClick;
   Property OnDragDrop;
   Property OnEndDrag;
   Property OnMouseMove;
   Property OnDblClick;
   Property OnDragOver;
   Property OnMouseDown;
end;

  TVertStatBarEditor = Class(TComponentEditor)
  private
    { Private declarations }
  protected
    { Protected declarations }
    procedure Edit; Override;
    Function GetVerbCount : Integer; Override;
    function GetVerb(Index : Integer) : String; Override;
    procedure ExecuteVerb(Index: Integer); override;
  public
    { Public declarations }
  published
    { Published declarations }
end;

procedure Register;

implementation

Function TVertStatBarEditor.GetVerbCount : Integer;
begin
 GetVerbCount := 1;
end;

function TVertStatBarEditor.GetVerb(Index : Integer) : String;
begin
 If Index = 0 then GetVerb := 'VertStatBar E&ditor...';
end;

procedure TVertStatBarEditor.ExecuteVerb(Index: Integer);
begin
 If Index = 0 then Edit;
end;

procedure TVertStatBarEditor.Edit;
Var
 EditForm : TVertStatBarEditorForm;
begin
 EditForm := TVertStatBarEditorForm.Create(Screen);
 EditForm.Edit2.Text := IntToStr(TVertStatBar(Component).Width);
 EditForm.Edit1.Text := TVertStatBar(Component).Caption;
 If TVertStatBar(Component).Align = alLeft then EditForm.RadioGroup1.ItemIndex := 0
  else EditForm.RadioGroup1.ItemIndex := 1;
 If TVertStatBar(Component).TextAlign = talTop then EditForm.RadioGroup2.ItemIndex := 0;
 If TVertStatBar(Component).TextAlign = talCenter then EditForm.RadioGroup2.ItemIndex := 1;
 If TVertStatBar(Component).TextAlign = talBottom then EditForm.RadioGroup2.ItemIndex := 2;
 EditForm.ShowModal;
 TVertStatBar(Component).Width := StrToInt(EditForm.Edit2.Text);
 TVertStatBar(Component).Caption := EditForm.Edit1.Text;
 If EditForm.RadioGroup1.ItemIndex = 0 then TVertStatBar(Component).Align := alLeft
  else TVertStatBar(Component).Align := alRight;
 If EditForm.RadioGroup2.ItemIndex = 0 then TVertStatBar(Component).TextAlign := talTop;
 If EditForm.RadioGroup2.ItemIndex = 1 then TVertStatBar(Component).TextAlign := talCenter;
 If EditForm.RadioGroup2.ItemIndex = 2 then TVertStatBar(Component).TextAlign := talBottom;
end;

procedure TVertStatBar.SetCap(Cap : String);
begin
 FCap := Cap;
// FCap := InputBox('Question?', 'Enter Caption', FCap);
 repaint;
end;

procedure TVertStatBar.SetTal(al : TTextAlign);
begin
 FTA := al;
 repaint;
end;

constructor TVertStatBar.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 Align := alLeft;
 Width := 21;
 Caption := 'Status';
end;

procedure TVertStatBar.Paint;
Var
 X, Y, I : Integer;
begin
 Canvas.Brush.Color := Color;
 Canvas.FillRect(Rect(0,0,width-1,height-1));
 If Caption <> '' then begin
 X :=(Width div 2) - (Canvas.TextWidth(Caption[1]) div 2);
 Case TextAlign of
  talCenter: Y :=(Height div 2) - ((Canvas.TextHeight(Caption[1]) * Length(Caption)) div 2);
  talTop: Y := 3;
  tAlBottom: Y := Height - (Canvas.TextHeight(Caption) * Length(Caption)) - 3;
 end;
 end;
 Canvas.Brush.Style := bsClear;
 If Caption <> '' then
 For I := 1 to Length(Caption) do begin
  X :=(Width div 2) - (Canvas.TextWidth(Caption[I]) div 2);
  If (Y < Height) and (Y > 0 - Canvas.TextHeight(Caption)) then Canvas.TextOut(X,Y,Caption[I]);
  Y := Y + Canvas.TextHeight(Caption);
 end;
 Canvas.Brush.Style := bsSolid;
 Canvas.MoveTo(0,0);
 Canvas.Pen.Color := clBtnShadow;
 Canvas.Lineto(width-1,0);
 Canvas.Pen.Color := clBtnHighlight;
 Canvas.Lineto(width-1,Height-1);
 Canvas.Lineto(0,Height-1);
 Canvas.Pen.Color := clBtnShadow;
 Canvas.Lineto(0,0);
 Canvas.Pen.Color := cl3DdkShadow;
 Canvas.MoveTo(1,1);
 Canvas.LineTo(1, Height - 2);
 Canvas.MoveTo(1,1);
 Canvas.LineTo(Width - 2, 1);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TVertStatBar]);
  RegisterComponentEditor(TVertStatBar, TVertStatBarEditor);
end;

end.
