{*******************************************************************}
{                                                                   }
{  Delphi 2.0                                                       }
{  VarGrid SQL Component                                            }
{                                                                   }
{  Copyright (c) 1998 Thomas Bednarek                               }
{                                                                   }
{*******************************************************************}

unit vgSql;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, VarGrid, DBTables;

type
  TvgSQL = class(TQuery)
  private
    FVarGrid: TVarGrid;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Execute;
  published
    property VarGrid: TVarGrid read FVarGrid write FVarGrid;
  end;

implementation

Constructor TvgSQL.Create (AOwner: TComponent);
Begin;
  inherited Create(AOwner);
End;

destructor TvgSQL.Destroy;
begin
  inherited Destroy;
end;

procedure TvgSQL.Execute;
Var
  i: Integer;
  r: Longint;
begin
  Open;
  FVarGrid.Clear;
  FVarGrid.UpdateLock := true;

  Try
    While not Eof do
      begin
        r := FVarGrid.Add;
        for i := 0 to FieldCount - 1 do
          If not Fields[i].IsNull then FVarGrid.CellValue[r, i] := Fields[i].Value;
        Next;
      end;
  Finally
    Close;
    FVarGrid.UpdateLock := false;
  End;
end;

end.
