{*******************************************************************}
{                                                                   }
{  Delphi 2.0                                                       }
{  String Units                                                     }
{                                                                   }
{  Copyright (c) 1996 Thomas Bednarek                               }
{                                                                   }
{*******************************************************************}

unit UStrings;

{===================================================================}
                         Interface
{===================================================================}

Uses
  SysUtils, Windows;

procedure SplitStrChr (var s1, s2: string; c: Char);
procedure SplitStr (var s1, s2: string; Split: string);

function Transform (S: String; Pic: String): String;
function Match (Code, s: string): Boolean;
function Replicate (c: Char; Count: Integer): string;
function Substitute (c1, c2: Char; s : string): string;
function CountChr (c: Char; s: string): Integer;
function StripStr (c: Char; s: string): string;
function SearchReplace (SearchStr, ReplaceStr, Data: String): String;
function ChrPos(c: Char; S: string; Count: LongInt): LongInt;
function ScanChrPos(c: Char; s: string; start: LongInt): LongInt;
function CodeStr(s: string; pw: string; decode: boolean): string;

{===================================================================}
                       Implementation
{===================================================================}

procedure SplitStrChr (var s1, s2: string; c: Char);
Var
  i: Integer;
  l: Integer;
begin
  i := 0;
  l := Length(s1);
  s2 := '';
  while i < l do
    begin
      Inc(i);
      If s1[i] = c then
        Begin;
          s2 := Copy(s1,i+1,l-i);
          s1 := Copy(s1,1,i-1);
          Exit;
        End;
    end;
end;

procedure SplitStr (var s1, s2: string; Split: string);
Var
  i: Integer;
Begin;
  i := Pos(Split,s1);
  If i > 0 then
    Begin;
      s2 := Copy(s1,i+Length(Split),Length(s1)-Length(Split));
      s1 := Copy(s1,1,i-1);
    End
  else
    s2 := '';
end;

function CodeStr(s: string; pw: string; decode: boolean): string;
var
  i, j: Integer;
  c, k: byte;
  rs: string;
begin
  j := 1;
  rs := s;
  k := byte(Length(pw) div 2);

  If decode then
    for i := 1 to Length(s) do
      begin
        j := (j+1) mod (Length(pw)+1);
        inc(c,Byte(pw[j])+k);
        c := Byte(rs[i]) xor Byte(pw[j]);
        rs[i] := Char(c);
      end
  else
    for i := 1 to Length(s) do
      begin
        j := (j+1) mod (Length(pw)+1);
        dec(c,Byte(pw[j])-k);
        c := Byte(rs[i]) xor Byte(pw[j]);
        rs[i] := Char(c);
      end;

  CodeStr := rs;
end;

function Match (Code, s: string): Boolean;
Var
  i: Integer;
  s1, s2: String;
begin
   If Code = '*' then
      Match := true
   else
      Begin;
         i := Pos('*',Code);
         If i = 0 then
            If Code <> s then
               Match := false
            else
               Match := true
         else
            Begin;
               s1 := Copy(Code,1,i-1);
               s2 := Copy(s,1,i-1);
               If s1 <> s2 then
                  Match := false
               else
                  If Code[Length(Code)] = '*' then
                     Match := true
                  else
                     Begin;
                        s1 := Copy(Code,i+1,Length(Code));
                        s2 := Copy(s,Length(s)-Length(s1)+1,Length(s));
                        If s1 <> s2 then
                           Match := false
                        else
                           Match := true;
                     End;
            End;
      End;
end;

function Replicate (c: Char; Count: Integer): string;
var
  s: String;
begin
   SetLength(s,Count);
   FillChar(s[1],Count,c);
   Replicate := S;
end;

function Substitute (c1, c2: Char; s : string): string;
var
  i   : Byte;
  NewS: String;
begin
  NewS := s;
  For i := 1 to Length(NewS) do If NewS[i] = c1 then NewS[i] := c2;
  Substitute := NewS;
end;

function CountChr (c: Char; s: string): Integer;
var
  i, j: Integer;
begin
  j := 0;
  For i := 1 to Length(s) do If s[i] = c then Inc(j);
  CountChr := j;
end;

function StripStr (c: Char; s: string): string;
var
  i: Integer;
  NewS: String;
begin
  For i := 1 to Length(s) do If s[i] <> c then NewS := NewS + s[i];
  StripStr := NewS;
end;

Function Transform (S : String; Pic: String): String;
Var
  Si,Pi : Byte;
  sP,sS : String;
begin;
  If Length(Pic) = 0 then
    Begin
      Transform := S;
      Exit;
    End;
  sP := Replicate(' ',Length(Pic));
  sS := TrimLeft(S);
  Si := Length(sS);
  For Pi := Length(Pic) downto 1 do
    Case Pic[Pi] of
      ',' :
        Begin;
          If Si > 0 then
            Begin;
              If sS[Si] = '.' then
                sP[Pi] := ','
              else
                sP[Pi] := sS[Si];
              Dec(Si);
            End;
        End;
      '#' :
        Begin;
          If Si > 0 then
            Begin;
              sP[Pi] := sS[Si];
              Dec(Si);
            End;
        End;
      '9' :
        Begin;
          If Si > 0 then
            Begin;
              sP[Pi] := sS[Si];
              Dec(Si);
            End
          else
            sP[Pi] := '0';
        End;
      else
        sP[Pi] := Pic[Pi];
    End;
  If Si <> 0 then
    begin
      sP[1] := 'e';
      raise EAbort.Create('Feldberlauf');
    end;
  TransForm := sP;
end;

function SearchReplace (SearchStr, ReplaceStr, Data: String): String;
Var
  sPos : Integer;
  lenSearchStr: Integer;
  CopyOfData: String;
  ReturnStr: String;
begin
  ReturnStr := '';
  CopyOfData := Data;
  lenSearchStr := Length(SearchStr);

  Repeat
    sPos := Pos(SearchStr,CopyOfData);

    If sPos > 0 then
      begin
        ReturnStr := Concat(ReturnStr,Copy(CopyOfData,1,sPos-1),ReplaceStr);
        Delete(CopyOfData,1,sPos-1+lenSearchStr);
      end
    else
      ReturnStr := ReturnStr + CopyOfData;

  Until sPos = 0;

  SearchReplace := ReturnStr;
end;

function ChrPos(c: Char; S: string; Count: LongInt): LongInt;
Var
  i, l, j : Integer;
begin
  i := 1;
  j := 1;
  l := Length(S);

  While (i <= l) do
    if s[i] = c then
      if j = Count then
        begin
          ChrPos := i;
          exit;
        end
      else
        begin
          inc(j);
          inc(i);
        end
    else
      inc(i);

  ChrPos := 0;
end;

function ScanChrPos(c: Char; s: string; start: LongInt): LongInt;
Var
  i, l: LongInt;
begin
  l := Length(s);
  i := start;

  while i <= l do
    begin
      If s[i] = c then
        begin
          ScanChrPos := i;
          Exit;
        end
      else
        inc(i);
    end;

  ScanChrPos := 0;
end;

End. { UStrings }
