unit vgcedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, Numctrls, Buttons, VarGrid, ComCtrls;

type
  TVGCEditor = class(TForm)
    GroupBox1: TGroupBox;
    lbColumns: TListBox;
    bnNew: TButton;
    bnDelete: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ColorDialog: TColorDialog;
    FontDialog: TFontDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    edTitle: TEdit;
    Label2: TLabel;
    cbTitleAlignment: TComboBox;
    bnTitleColor: TButton;
    bnTitlefont: TButton;
    Label3: TLabel;
    Label4: TLabel;
    cbAlignment: TComboBox;
    cbType: TComboBox;
    Label5: TLabel;
    edEditMask: TEdit;
    Label6: TLabel;
    edDisplayformat: TEdit;
    Label7: TLabel;
    iedWidth: TIntegerEdit;
    chkReadOnly: TCheckBox;
    bnFont: TButton;
    bnColor: TButton;
    Label8: TLabel;
    cbStyle: TComboBox;
    procedure bnNewClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bnDeleteClick(Sender: TObject);
    procedure lbColumnsClick(Sender: TObject);
    procedure edTitleExit(Sender: TObject);
    procedure cbTitleAlignmentExit(Sender: TObject);
    procedure cbTypeExit(Sender: TObject);
    procedure cbAlignmentExit(Sender: TObject);
    procedure edEditMaskExit(Sender: TObject);
    procedure edDisplayformatExit(Sender: TObject);
    procedure iedWidthExit(Sender: TObject);
    procedure chkReadOnlyClick(Sender: TObject);
    procedure bnTitleColorClick(Sender: TObject);
    procedure bnTitlefontClick(Sender: TObject);
    procedure bnFontClick(Sender: TObject);
    procedure bnColorClick(Sender: TObject);
    procedure cbStyleExit(Sender: TObject);
  private
    FVarGrid: TVarGrid;
    Columns: TColumns;
    procedure UpdateScreen(value: TColumn);
    procedure ShowSelectMsg;
    procedure SelectCol(value: Integer);
  public
    procedure SetValues(VarGrid: TVarGrid);
    function GetValues(VarGrid: TVarGrid): Boolean;
  end;

  function EditColumns(VarGrid: TVarGrid): Boolean;

implementation

{$R *.DFM}

function EditColumns(VarGrid: TVarGrid): Boolean;
var
  VGCEditor: TVGCEditor;
begin
  VGCEditor := TVGCEditor.Create(Application);

  Try
    VgcEditor.SetValues(VarGrid);

    If VgcEditor.ShowModal = mrOK then
      begin
        VgcEditor.GetValues(VarGrid);
        VarGrid.UpdateCols;
        EditColumns := True;
      end
    else
      EditColumns := False;

  Finally
    VgcEditor.Destroy;
  End;
end;

procedure TVGCEditor.SelectCol(value: Integer);
Var
  i: Integer;
begin
  for i := 0 to lbColumns.Items.Count -1 do lbColumns.Selected[i] := false;
  Try
    lbColumns.ItemIndex := value;
    lbcolumns.Selected[value]:= true;
  Except
    If lbColumns.Items.Count > 0 then lbColumns.ItemIndex := 0;
  End;
end;

procedure TVgcEditor.ShowSelectMsg;
begin
  MessageDlg('You have to select a column',mtError, [mbOK],0);
  lbColumns.SetFocus;
end;

procedure TVgcEditor.SetValues(VarGrid: TVarGrid);
Var
  i: Integer;
begin
  FVarGrid := VarGrid;
  Columns := TColumns.Create(FVarGrid);
  Columns.Assign(FVarGrid.Columns);

  If Columns.Count > 0 then With Columns do
    begin
      For i := 0 to Count - 1 do lbColumns.Items.Add('Col_' + IntToStr(i) + ':' + Items[i].Title);
    end;
end;

function TVgcEditor.GetValues(VarGrid: TVarGrid): Boolean;
begin
  VarGrid.Columns.Clear;
  VarGrid.Columns.Assign(Columns);
  GetValues := True;
end;

procedure TVgcEditor.UpdateScreen(value: TColumn);
begin
  edTitle.Text := value.Title;
  cbTitleAlignment.ItemIndex := Ord(value.TitleAlignment);
  cbType.ItemIndex := Ord(value.ValueType);
  cbAlignment.ItemIndex := Ord(value.Alignment);
  cbStyle.ItemIndex := Ord(value.Style);
  edEditMask.Text := value.EditMask;
  edDisplayformat.Text := value.Displayformat;
  iedWidth.Value := value.Width;
  chkReadOnly.Checked := value.ReadOnly;
end;

procedure TVGCEditor.FormDestroy(Sender: TObject);
begin
  Columns.Free;
end;

procedure TVGCEditor.bnNewClick(Sender: TObject);
Var
  i: Integer;
  VC: TColumn;
begin
  i := lbColumns.Items.Count;
  lbColumns.Items.Add('Col_' + IntToStr(i) + ':');
  SelectCol(i);
  VC := Columns.Add;
  VC.Title := '';
  VC.TitleFont.Assign(FVarGrid.Font);
  VC.TitleFont.Style := [fsBold];
  VC.TitleColor := FVarGrid.FixedColor;
  VC.TitleAlignment := taLeftJustify;
  VC.ValueType := vtString;
  VC.Font.Assign(FVarGrid.Font);
  VC.Color := FVarGrid.Color;
  VC.Alignment := taLeftJustify;
  VC.Style := Vargrid.stNone;
  VC.EditMask := '';
  VC.DisplayFormat := '';
  VC.ReadOnly := False;
  VC.Width := FVarGrid.DefaultColWidth;
  UpdateScreen(VC);
end;

procedure TVGCEditor.bnDeleteClick(Sender: TObject);
Var
  OldColumns: TColumns;
  i: Integer;
begin
  If lbColumns.ItemIndex = -1 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  OldColumns := TColumns.Create(FVarGrid);

  Try
    OldColumns.Assign(Columns);
    Columns.Clear;

    For i := 0 to lbColumns.ItemIndex - 1 do
      begin
        Columns.Add;
        Columns.Items[i].Assign(OldColumns.Items[i]);
      end;

    For i := lbColumns.ItemIndex + 1 to lbColumns.Items.Count - 1 do
      begin
        Columns.Add;
        Columns.Items[i-1].Assign(OldColumns.Items[i]);
      end;

    i := lbColumns.ItemIndex;
    lbColumns.Items.Delete(i);

    If i > 0 then
      begin
        Dec(i);
        SelectCol(i);
        UpdateScreen(Columns.Items[i]);
      end
    else
      If lbColumns.Items.Count > 0 then SelectCol(0);

  Finally
    OldColumns.Free;
  End;
end;

procedure TVGCEditor.lbColumnsClick(Sender: TObject);
Var
  i: Integer;
begin
  i := lbColumns.ItemIndex;
  UpdateScreen(Columns.Items[i]);
end;

procedure TVGCEditor.edTitleExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].Title := edTitle.Text;
    end;
end;

procedure TVGCEditor.cbTitleAlignmentExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].TitleAlignment := TAlignment(cbTitleAlignment.ItemIndex);
    end;
end;

procedure TVGCEditor.cbTypeExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    If lbColumns.Selected[i] then
    With Columns.Items[i] do
      begin
        ValueType := TValueType(cbType.ItemIndex);

        Case Columns.Items[i].ValueType of
          vtInteger:
            begin
              DisplayFormat := '###,###,##0';
              TitleAlignment := taRightJustify;
              Alignment := taRightJustify;
            end;
          vtFloat:
            begin
              DisplayFormat := '###,###,##0.00';
              TitleAlignment := taRightJustify;
              Alignment := taRightJustify;
            end;
          vtString:
            begin
              TitleAlignment := taLeftJustify;
              Alignment := taLeftJustify;
            end;
          vtDate:
            begin
              EditMask  := '!90/90/0000;1;_';
              TitleAlignment := taLeftJustify;
              Alignment := taLeftJustify;
            end;
          vtTime:
            begin
              EditMask  := '!90:00;1;_';
              TitleAlignment := taLeftJustify;
              Alignment := taLeftJustify;
            end;
        End;

        UpdateScreen(Columns.Items[i]);
      end;
end;

procedure TVGCEditor.cbAlignmentExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].Alignment := TAlignment(cbAlignment.ItemIndex);
    end;
end;

procedure TVGCEditor.cbStyleExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].Style := TStyle(cbStyle.ItemIndex);
    end;
end;

procedure TVGCEditor.edEditMaskExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].EditMask := edEditMask.Text;
    end;
end;

procedure TVGCEditor.edDisplayformatExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].Displayformat := edDisplayformat.Text;
    end;
end;

procedure TVGCEditor.iedWidthExit(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    If lbColumns.Selected[i] then
      begin
        If iedWidth.Value < 1 then iedWidth.Value := 1;
        Columns.Items[i].Width := iedWidth.Value;
      end;
end;

procedure TVGCEditor.chkReadOnlyClick(Sender: TObject);
Var
  i: Integer;
begin
  If lbColumns.SelCount = 0 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  For i := 0 to lbColumns.Items.Count - 1 do
    begin
      If lbColumns.Selected[i] then Columns.Items[i].ReadOnly := chkReadOnly.Checked;
    end;
end;

procedure TVGCEditor.bnTitleColorClick(Sender: TObject);
Var
  i: Integer;
begin
  i := lbColumns.ItemIndex;

  If lbColumns.ItemIndex = -1 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  ColorDialog.Color := Columns.Items[i].TitleColor;

  If ColorDialog.Execute then
    For i := 0 to lbColumns.Items.Count - 1 do
      If lbColumns.Selected[i] then Columns.Items[i].TitleColor := ColorDialog.Color;
end;

procedure TVGCEditor.bnTitlefontClick(Sender: TObject);
Var
  i: Integer;
begin
  i := lbColumns.ItemIndex;

  If lbColumns.ItemIndex = -1 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  FontDialog.Font.Assign(Columns.Items[i].TitleFont);

  If FontDialog.Execute then
    For i := 0 to lbColumns.Items.Count - 1 do
      If lbColumns.Selected[i] then Columns.Items[i].TitleFont.Assign(FontDialog.Font);
end;

procedure TVGCEditor.bnFontClick(Sender: TObject);
Var
  i: Integer;
begin
  i := lbColumns.ItemIndex;

  If lbColumns.ItemIndex = -1 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  FontDialog.Font.Assign(Columns.Items[i].Font);

  If FontDialog.Execute then
    For i := 0 to lbColumns.Items.Count - 1 do
      If lbColumns.Selected[i] then  Columns.Items[i].Font.Assign(FontDialog.Font);
end;

procedure TVGCEditor.bnColorClick(Sender: TObject);
Var
  i: Integer;
begin
  i := lbColumns.ItemIndex;

  If lbColumns.ItemIndex = -1 then
    begin
      ShowSelectMsg;
      Exit;
    end;

  Colordialog.Color := Columns.Items[i].Color;

  If ColorDialog.Execute then
    For i := 0 to lbColumns.Items.Count - 1 do
      If lbColumns.Selected[i] then Columns.Items[i].Color := ColorDialog.Color;
end;

end.
