unit urllabel;
{
URLLabel Ver. 1.4.0.1
for Delphi 2 and 3:
Developed by Filippo Passeggieri inspirated by some advices in
the UDDF site.
Initially, I thought to sell URLLabel at 250USD, but on second thought
I decided, being my first component, it had to be FREEWARE. :-)
If you have suggestions, bug reports please E-Mail me at:
   passeggieri@geocities.com

---------------------------------------------------------------------------
  ATTENTION!!!!!
  Use URLLabel component at your own risk!!! I decline any responsibility.
----------------------------------------------------------------------------

History:
03/05/98 - You can now set LabelType property using the right click when URLLabel
           is selected;
           Added an About Dialog in the Object Inspector. - Ver 1.4.0.1
17/03/98 - Corrected minor bugs. - Ver 1.4.0.0
14/03/98 - Sincronized property URLColStd with Font property
           Replaced the ugly cursor crHandPoint with browser like one.

13/03/98 - Received an improved version by CT Koo (Thanks a lot!!!); This versiona can now:
           + Create a custom label type and on click event which allow user to define custom
              onclick event.
           + Add AllowDown property, it act like button down.
           + In mouse up event, font change to standard when effect98 is false.

26/12/97 - Corrected several bugs. - Ver 1.3.0.1
21/12/97 - Added effect like Win98/IE4 (property Effect98). - Ver 1.3.0.0
16/11/97 - Added support for FTP (property HTTPorMail is now called LabelType);
           Now cursor is browser-like. - Ver 1.2.0.0
06/11/97 - Corrected minor bugs. - Ver 1.1.0.0
04/11/97 - Added support to choose different colors if TURLLabel is pressed
           or not(properties SetColStd, SetColPre).
02/11/97 - Added support for Mail (property HTTPorMail).
31/10/97 - First release.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ShellApi, DsgnIntf, ExtCtrls;

type
  TLabelType = (hmHTTP, hmMAIL, hmFTP, hmCUSTOM);

  TAbout = class(TPropertyEditor)
  public
  	procedure Edit; override;
  	function GetAttributes: TPropertyAttributes; override;
  	function GetValue: string; override;
  end;

  TUrlLabelEditor = class ( TComponentEditor )
     function GetVerbCount: Integer; override;
     function GetVerb(Index: Integer): string; override;
     procedure ExecuteVerb(Index: Integer); override;
  end;

  TURLLabel=class(TCustomLabel)
  private
    { Private declarations }
    FAbout: TAbout;
    FLabelType: TLabelType;
    FColStd : TColor;
    FColPre : TColor;
    FAllowDown : Boolean;
    FEffect98: Boolean;
    function GetFont: TFont;
    procedure SetFont(Value: TFont);
    procedure URLMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure URLMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure SetLabelType(Value: TLabelType);
    procedure SetColStd(Value: TColor);
    procedure SetColPre(Value: TColor);
    procedure SetAllowDown(Value: Boolean);
    procedure SetEffect98(Value: Boolean);
  protected
    { Protected declarations }
    procedure Click; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer); override;
  public
    { Public declarations }
    constructor Create( AOwner : TComponent); override;
    procedure OpenObject(sObjectPath : PChar);
  published
    { Published declarations }
    property About: TAbout
       read FAbout
       write FAbout;

    property LabelType : TLabelType
       read FLabelType
       write SetLabelType
       default hmHTTP;

    property URLColStd: TColor
       read FColStd
       write SetColStd
       default clBlue;

    property URLColPre: TColor
       read FColPre
       write SetColPre
       default clRed;

    property AllowDown : Boolean
       read FAllowDown
       write SetAllowDown
       default False;

    property Effect98 : Boolean
       read FEffect98
       write SetEffect98
       default False;

    property Caption;
    property WordWrap;
    property Align;

    property Font:TFont
       read GetFont
       write SetFont;

    property AutoSize;
    property Alignment;
    property ParentFont;
    property Transparent;
    property Hint;
    property ShowHint;
    property OnClick;
  end;

procedure Register;

implementation

{$R URLLabel.res}

const
   URLLabelVersion = '1.4.0.1';
   crCoolHand = -21;
   HTTP = 'http:\\';
   MAIL = 'mailto:';
   FTP = 'ftp:\\';


constructor TURLLabel.Create( AOwner : TComponent);
begin
   inherited Create(AOwner);

   Screen.Cursors[crCoolHand] := LoadCursor(HInstance, 'URLHAND');
   Cursor := crCoolHand;

   FAllowDown := false;
   FEffect98 := false;
   FColStd := clBlue;
   FColPre := clRed;
   font.color := URLColStd;
   font.Style := [fsUnderline];
end;


procedure TURLLabel.URLMouseEnter(var Message: TMessage);
begin
   if Effect98 then
   begin
      font.color := URLColPre;
      if FLabelType <> hmCUSTOM then font.Style := [fsUnderline];
      Invalidate
   end;
end;


procedure TURLLabel.URLMouseLeave(var Message: TMessage);
begin
   if Effect98 then
   begin
      font.color := URLColStd;
      if FLabelType <> hmCUSTOM then
        font.Style := [];
      Invalidate
   end;
end;

procedure TURLLabel.SetAllowDown(Value:Boolean);
begin
   if FAllowDown <> Value then
   begin
     FAllowDown := Value;
     Invalidate;
   end;
end;

procedure TURLLabel.SetEffect98(Value:Boolean);
begin
   if FEffect98 <> Value then
   begin
     FEffect98 := Value;
     if FEffect98 then font.Style := []
    //
        else if LabelType <> hmCustom then Font.Style := [fsUnderline];
    //
     Invalidate;
   end;
end;

procedure TURLLabel.SetLabelType;
begin
   if FLabelType <> Value then
   begin
      FLabelType := Value;

      if (FLabelType = hmCustom) or Effect98 then font.Style := []
      else
         font.Style := [fsUnderline];

      Invalidate;
   end;
end;

function TURLLabel.GetFont: TFont;
begin
     Result := inherited Font;
end;

procedure TURLLabel.SetFont;
begin
   inherited Font := Value;
   FColStd := Font.Color;
end;


procedure TURLLabel.SetColStd;
begin
   if (FColStd <> Value) then
   begin
     FColStd := Value;
     Font.Color := FColStd;
     Invalidate;
   end
end;

procedure TURLLabel.SetColPre;
begin
   if FColPre <> Value then
   begin
     FColPre := Value;
     Invalidate;
   end;
end;

procedure TURLLabel.OpenObject(sObjectPath : PChar);
begin
   ShellExecute(0, Nil, sObjectPath, Nil, Nil, SW_NORMAL);
end;

procedure TURLLabel.Click;
var
  TempString : array[0..79] of char;
  szApp : string;
begin
   Inherited Click;
   if FLabelType <> hmCUSTOM then
   begin
    if FLabelType = hmHTTP then szApp := HTTP
      else
        if FLabelType = hmFTP then  szApp := FTP
        else szApp := MAIL;
    StrPCopy(TempString,szApp+Caption);
    OpenObject(TempString);
   end;
end;

procedure TURLLabel.MouseDown(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer);
begin
   inherited MouseDown(Button,Shift,X,Y);
   if Button = mbLeft then
   begin
      if AllowDown then Top:=Top+1;
      font.color := URLColPre;
   end;
end;

procedure TURLLabel.MouseUp(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer);
begin
   inherited MouseUp(Button,Shift,X,Y);
   if not Effect98 then font.color := URLColStd;
   if AllowDown then
      if Button = mbLeft then Top:=Top-1;
end;

procedure TAbout.Edit;
begin
    Application.MessageBox
      ('TURLLabel ' + URLLabelVersion +#13+#10+'A.D. 1997/98 by Filippo Passeggieri',
       'About', MB_OK or MB_ICONINFORMATION);
end;

function TAbout.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
    Result := '(about)';
end;


function TUrlLabelEditor.GetVerbCount: Integer;
begin
   Result := 4;
end;

function TUrlLabelEditor.GetVerb(Index: Integer): String;
begin
  case Index of
  0: Result := 'C&ustom';
  1: Result := 'F&tp';
  2: Result := '&Mail';
  3: Result := '&Http';
  end;
end;

procedure TUrlLabelEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
  0: begin
       TURLLabel(Component).LabelType := hmCUSTOM;
       Designer.Modified;
     end;
  1: begin
       TURLLabel(Component).LabelType := hmFtp;
       Designer.Modified;
     end;
  2: begin
       TURLLabel(Component).LabelType := hmMail;
       Designer.Modified;
     end;
  3: begin
       TURLLabel(Component).LabelType := hmHttp;
       Designer.Modified;
     end;
  end;
end;


procedure Register;
begin
   RegisterComponents('Freeware', [TURLLabel]);
   RegisterPropertyEditor(TypeInfo(TAbout), TURLLabel, 'ABOUT', TAbout);
   RegisterComponentEditor(TURLLabel, TUrlLabelEditor);
end;

end.
