
{*******************************************************}
{                                                       }
{       Toolbar Manager for Toolbar97                   }
{       Version 1.0                                     }
{                                                       }
{       Copyright (c) 2000 AnimatedMenus.com            }
{       All rights reserved.                            }
{                                                       }
{*******************************************************}

unit ToolbarManager_Toolbar97;

{$I am2000.inc}

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  ToolbarManager {$IFDEF Delphi4OrHigher}, ActnList {$ENDIF};

type
  // This class represents a toolbar
  TToolbar_Toolbar97 = class(TCustomToolbar)
  protected
    function GetVisible: Boolean; override;
    procedure SetVisible(const Value: Boolean); override;

    function GetCaption: String; override;
    procedure SetCaption(const Value: String); override;

    function GetHint: String; override;

    function GetPopupMenu: TPopupMenu; override;
    procedure SetPopupMenu(const Value: TPopupMenu); override;

    // buttons
    function GetButtonBitmap(Index: Integer; Bitmap: TBitmap): TBitmap; override;
    function GetButtonCaption(Index: Integer): String; override;
    function GetButtonCount: Integer; override;
    function GetButtonHeight(Index: Integer): Integer; override;
    function GetButtonLeft(Index: Integer): Integer; override;
    function GetButtonSeparator(Index: Integer): Boolean; override;
    function GetButtonShortCut(Index: Integer): String; override;
    function GetButtonTop(Index: Integer): Integer; override;
    function GetButtonVisible(Index: Integer): Boolean; override;
    function GetButtonWidth(Index: Integer): Integer; override;
    procedure SetButtonBitmap(Index: Integer; Bitmap: TBitmap); override;
    procedure SetButtonCaption(Index: Integer; const Value: String); override;
    procedure SetButtonShortCut(Index: Integer; const Value: String); override;
    procedure SetButtonVisible(Index: Integer; const Value: Boolean); override;
  end;

  // This class represent a toolbar manager
  TToolbarManager_Toolbar97 = class(TCustomToolbarManager)
    function CreateToolbar(AToolbar: TComponent): TCustomToolbar; override;

  public
    function IsToolbar(AComponent: TComponent): Boolean; override;

  end;

procedure Register;

implementation

uses
  CommCtrl, Tb97tlbr, Tb97ctls;

procedure Register;
begin
  RegisterComponents('Toolbar Manager', [TToolbarManager_Toolbar97]);
end;

{ TToolbar_Toolbar97 }

function TToolbar_Toolbar97.GetButtonBitmap(Index: Integer;
  Bitmap: TBitmap): TBitmap;
var
  C: TComponent;
begin
  Bitmap.Width:= 0;
  Result:= Bitmap;

  C:= TToolbar97(FToolbar).Controls[Index];
  if C is TToolbarButton97
  then
    with TToolbarButton97(C) do
      if not Glyph.Empty
      then
        Bitmap.Assign(Glyph)

      else
      if (ImageIndex <> -1)
      and (Images <> nil)
      then begin
        Bitmap.Width:= TImageList(Images).Width;
        Bitmap.Height:= TImageList(Images).Height;
        Bitmap.Canvas.Brush.Style:= bsSolid;
        Bitmap.Canvas.Brush.Color:= TImageList(Images).BlendColor;
        Bitmap.Canvas.FillRect(Rect(0, 0, TImageList(Images).Width, TImageList(Images).Height));
        Images.Draw(Bitmap.Canvas, 0, 0, ImageIndex);
      end

{$IFDEF Delphi4OrHigher}
      else
      if (Action is TAction)
      and (TAction(Action).ImageIndex <> -1)
      and (TAction(Action).ActionList.Images <> nil)
      then
        with TAction(Action), ActionList
        do begin
          Bitmap.Width:= Images.Width;
          Bitmap.Height:= Images.Height;
          Images.Draw(Bitmap.Canvas, 0, 0, ImageIndex);
        end;
{$ENDIF}
end;

function TToolbar_Toolbar97.GetButtonCaption(Index: Integer): String;
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  if C is TControl
  then
    Result:= TForm(C).Caption // TControl doesn't publis Caption property
  else
    Result:= C.Name;
end;

function TToolbar_Toolbar97.GetButtonCount: Integer;
begin
  Result:= TToolbar97(FToolbar).ControlCount;
end;

function TToolbar_Toolbar97.GetButtonHeight(Index: Integer): Integer;
begin
  Result:= TToolbar97(FToolbar).Controls[Index].Height;
end;

function TToolbar_Toolbar97.GetButtonLeft(Index: Integer): Integer;
begin
  Result:= TToolbar97(FToolbar).Controls[Index].Left;
end;

function TToolbar_Toolbar97.GetButtonSeparator(Index: Integer): Boolean;
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  Result:= (C is TToolbarSep97);
end;

function TToolbar_Toolbar97.GetButtonShortCut(Index: Integer): String;
begin
  Result:= '';
end;

function TToolbar_Toolbar97.GetButtonTop(Index: Integer): Integer;
begin
  Result:= TToolbar97(FToolbar).Controls[Index].Top;
end;

function TToolbar_Toolbar97.GetButtonVisible(Index: Integer): Boolean;
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  Result:= (C is TControl) and (TControl(C).Visible);
end;

function TToolbar_Toolbar97.GetButtonWidth(Index: Integer): Integer;
begin
  Result:= TToolbar97(FToolbar).Controls[Index].Width;
end;

function TToolbar_Toolbar97.GetCaption: String;
begin
  Result:= TToolbar97(FToolbar).Caption;
end;

function TToolbar_Toolbar97.GetHint: String;
begin
  Result:= TToolbar97(FToolbar).Hint;
  if Result = '' then Result:= SNoDescriptionAvailable;
end;

function TToolbar_Toolbar97.GetPopupMenu: TPopupMenu;
begin
  Result:= TToolbar97(FToolbar).PopupMenu;
end;

function TToolbar_Toolbar97.GetVisible: Boolean;
begin
  Result:= TToolbar97(FToolbar).Visible;
end;

procedure TToolbar_Toolbar97.SetButtonBitmap(Index: Integer;
  Bitmap: TBitmap);
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  if C is TToolbarButton97
  then
    with TToolbarButton97(C)
    do begin
      ImageIndex:= -1;
      Glyph.Assign(Bitmap);
    end;
end;

procedure TToolbar_Toolbar97.SetButtonCaption(Index: Integer;
  const Value: String);
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  if C is TControl
  then
    TToolbarButton97(C).Caption:= Value
  else
    C.Name:= Value;
end;

procedure TToolbar_Toolbar97.SetButtonShortCut(Index: Integer;
  const Value: String);
begin
end;

procedure TToolbar_Toolbar97.SetButtonVisible(Index: Integer;
  const Value: Boolean);
var
  C: TComponent;
begin
  C:= TToolbar97(FToolbar).Controls[Index];
  if C is TControl
  then TToolbarButton97(C).Visible:= Value;
end;

procedure TToolbar_Toolbar97.SetCaption(const Value: String);
begin
  TToolbar97(FToolbar).Caption:= Value;
end;

procedure TToolbar_Toolbar97.SetPopupMenu(const Value: TPopupMenu);
begin
  TToolbar97(FToolbar).PopupMenu:= Value;
end;

procedure TToolbar_Toolbar97.SetVisible(const Value: Boolean);
begin
  TToolbar97(FToolbar).Visible:= Value;
end;


{ TToolbarManager_Toolbar97 }

function TToolbarManager_Toolbar97.IsToolbar(AComponent: TComponent): Boolean;
begin
  Result:= AComponent is TCustomToolbar97;
end;

function TToolbarManager_Toolbar97.CreateToolbar(AToolbar: TComponent): TCustomToolbar;
var
  C: TComponent;
begin
  if AToolbar = nil
  then begin
    C:= TToolbar97.Create(Owner);
    TToolbar97(C).Parent:= TWinControl(Owner);
  end
  else
    C:= AToolbar;
    
  Result:= TToolbar_Toolbar97.Create(C);
end;

end.

