unit Toolbar97withMenuBar2000;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, TB97, TB97Tlbr, am2000;

type
  TToolbar97withMenuBar2000 = class(TCustomToolbar97)
  private
    MenuBar: TMenuBar2000;
    MySizesList: TList;

    function GetMenu: TMenu;
    procedure SetMenu(Value: TMenu);

  protected
    procedure BuildPotentialSizesList(SizesList: TList); override;
    procedure DoDockChangingHidden(DockingTo: TDock97); override;
    procedure DoMove; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure ResizeTrack(var Rect: TRect; const OrigRect: TRect); override;

    procedure Loaded; override;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;

  published
    property ActivateParent;
    property BorderStyle;
    property Color;
    property DefaultDock;
    property DockableTo;
    property DockedTo;
    property DockMode;
    property DockPos;
    property DockRow;
    property DragHandleStyle;
    property FloatingMode;
    property HideWhenInactive;
    property LastDock;
    property ParentShowHint;
    property PopupMenu;
    property ShowCaption;
    property ShowHint;
    property TabOrder;
    property UseLastDock;
    property Visible;

    property OnClose;
    property OnDragDrop;
    property OnDragOver;
    property OnMove;
    property OnRecreated;
    property OnRecreating;
    property OnDockChanged;
    property OnDockChanging;
    property OnDockChangingEx;
    property OnDockChangingHidden;
    property OnResize;
    property OnVisibleChanged;

    property Menu: TMenu read GetMenu write SetMenu;

  end;

procedure Register;

implementation
uses
  am2000menubar;


procedure Register;
begin
  RegisterComponents('AnimatedMenus/2000', [TToolbar97withMenuBar2000]);
end;


{ TToolbar97withMenuBar2000 }

constructor TToolbar97withMenuBar2000.Create(AOwner: TComponent);
begin
  inherited;

  MenuBar:= nil;
  Caption:= 'Menu Bar';
  FullSize:= True;
  CloseButton:= False;
  CloseButtonWhenDocked:= False;

  MenuBar:= TMenuBar2000.Create(Self);
  MenuBar.Parent:= Self;
  MenuBar.Align:= alClient;
end;

destructor TToolbar97withMenuBar2000.Destroy;
begin
  MenuBar.PopupMenu:= nil;
  MenuBar.Free;
  MenuBar:= nil;
  inherited;
end;

procedure TToolbar97withMenuBar2000.BuildPotentialSizesList(
  SizesList: TList);
  // build potential sizes list
var
  I, J, iLOX: Integer;
  P, P1: TSmallPoint;
  iW, iH, bX, bY, rSize, bWidth, bHeight: Integer;
begin
  MySizesList:= SizesList;
  SizesList.Clear;

  if MenuBar = nil then Exit;
  
  iLOX:= MenuBar.GetLastOffsetX;
  bWidth:= 0;
  bHeight:= 0;
  P:= SmallPoint(0, 0);

  // build potential sizes for (I-1) items in top
  for I:= 0 to MenuBar.miRects.Count -1 do begin
    // build rSize
    rSize:= MenuBar.GetOffsetX;
    for J:= 0 to I do
      with PMenuItemRect(MenuBar.miRects.Items[J])^ do
        Inc(rSize, iR.Right - iR.Left);


    bX:= MenuBar.GetOffsetX;
    bY:= 0;
    iH:= 0;
    bWidth:= 0;
    bHeight:= 0;

    // build height
    for J:= 0 to MenuBar.miRects.Count -1 do
       with PMenuItemRect(MenuBar.miRects.Items[J])^ do begin
         iW:= iR.Right - iR.Left;
         iH:= iR.Bottom - iR.Top;

         if J = 0 then bY:= iH +1;

         if (bX + iW) > rSize then begin
           Inc(bY, iH +1);
           bX:= 0;
         end;

         Inc(bX, iW);

         if bX > bWidth then bWidth:= bX;
         if bY > bHeight then bHeight:= bY;
       end;

    // sys buttons
    if iLOX <> 0 then begin
      iW:= iLOX;
      if (bX + iW) > rSize then begin
        Inc(bHeight, iH +1);
        bX:= 0;
      end;

      Inc(bX, iW);
      if bX > bWidth then bWidth:= bX;
    end;

    // add
    P1:= SmallPoint(bWidth +8, bHeight +3);
    if (P1.X <> P.X) and (P1.Y <> p.Y) then begin
      P:= P1;
      SizesList.Add(Pointer(P));
    end;
  end;

  // add one more - full length
  if iLOX <> 0 then begin
    P:= SmallPoint(bWidth + iLOX +8, bHeight div 2 +3);
    SizesList.Add(Pointer(P));
  end;
end;

procedure TToolbar97withMenuBar2000.SetParent(AParent: TWinControl);
  // update menu parent on docking
var
  ParentIsChanging: Boolean;
begin
  ParentIsChanging:= Parent <> AParent;
  inherited;

  if ParentIsChanging
  and (MenuBar <> nil)
  and (not (csDestroying in ComponentState)) 
  then MenuBar.UpdateMenuBar(True);
end;

procedure TToolbar97withMenuBar2000.DoDockChangingHidden(DockingTo: TDock97);
  // change menu orientation
begin
  if MenuBar <> nil
  then
    if DockingTo <> nil
    then begin
      if GetDockTypeOf(DockingTo) = dtLeftRight
      then
        MenuBar.mbType:= mbVertical
      else
        MenuBar.mbType:= mbHorizontal;

      MenuBar.Transparent:= not DockingTo.Background.Empty;
    end

    else begin
      MenuBar.mbType:= mbFloating;
      MenuBar.ParentClientWidth:= ClientWidth;
      MenuBar.Transparent:= False;
    end;

  inherited;
end;

procedure TToolbar97withMenuBar2000.DoMove;
begin
  if MenuBar <> nil then begin
    if Assigned(DockedTo)
    then MenuBar.Transparent:= not DockedTo.Background.Empty
    else MenuBar.Transparent:= False;

    MenuBar.UpdateMenuBar(False);
  end;
  
  inherited;
end;

procedure TToolbar97withMenuBar2000.ResizeTrack(var Rect: TRect; const OrigRect: TRect);
var
  I, NearestW, NearestH, RW, RH, DW, DH, PCW1: Integer;
  P: TSmallPoint;
begin
  // is there any difference?
  DW:= Rect.Right - OrigRect.Right;
  DH:= Rect.Bottom - OrigRect.Bottom;

  if (DW = 0) and (DH = 0) then
    Exit;

  // get suggested coords
  RW:= Rect.Right - Rect.Left;
  RH:= Rect.Bottom - Rect.Top;
  Rect:= OrigRect;

  // select an appropriate coords
  NearestW:= MaxInt;
  NearestH:= MaxInt;
  for I:= 0 to MySizesList.Count -1 do begin
    P:= TSmallPoint(MySizesList[I]);

    if ((DW = 0) or (Abs(P.X - RW) <= NearestW))
    and ((DH = 0) or (Abs(P.Y - RH) <= NearestH))
    then begin
      NearestW:= Abs(P.X - RW);
      NearestH:= Abs(P.Y - RH);
      Rect.Right:= Rect.Left + P.X;
      Rect.Bottom:= Rect.Top + P.Y;
    end;
  end;

  // correct Rect to smooth mouse movement
  PCW1:= (Rect.Right - Rect.Left) - (Width - ClientWidth) -8;
  with MenuBar do begin
    if ParentClientWidth <> PCW1 then begin
      ParentClientWidth:= PCW1;
      SetBounds(Left, Top, 0, 0);
    end;
  end;
end;

function TToolbar97withMenuBar2000.GetMenu: TMenu;
  // get menu bar's Menu property value
begin
  if MenuBar <> nil
  then Result:= Menubar.Menu
  else Result:= nil
end;

procedure TToolbar97withMenuBar2000.SetMenu(Value: TMenu);
  // set menu bar's Menu property value
begin
  if MenuBar <> nil
  then MenuBar.Menu:= Value;
end;

procedure TToolbar97withMenuBar2000.Loaded;
  // fire Loaded method
begin
  inherited;

  if MenuBar = nil then Exit;

  MenuBar.DoLoaded;

  if Assigned(DockedTo)
  then MenuBar.Transparent:= not DockedTo.Background.Empty
  else MenuBar.Transparent:= False;
end;

procedure TToolbar97withMenuBar2000.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  if Docked
  then
    case GetDockTypeOf(DockedTo) of
      dtTopBottom:
        if (AWidth < DockedTo.ClientWidth)
        then AWidth:= DockedTo.ClientWidth;

      dtLeftRight:
        if (AWidth < DockedTo.ClientHeight)
        then AWidth:= DockedTo.ClientHeight;
    end;

  inherited;
end;

end.



