
{*******************************************************}
{                                                       }
{       Animated Menus                                  }
{       Add-On Menu Components                          }
{       TSubMenu2000 Component                          }
{                                                       }
{       Copyright  1997-2000 by Andrew Cher            }
{                                                       }
{*******************************************************}

//
//  For technical information and latest versions please visit
//  http://www.animatedmenus.com/support/tsubmenu2000/
//

unit SubMenu2000reg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  am2000, am2000menuitem, DsgnIntf, TypInfo, SubMenu2000;

type
  TPhantomMenuItemProperty = class(TComponentProperty)
  public
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

procedure Register;

implementation

uses
  Consts,
  am2000cache, am2000options, am2000utils;

procedure Register;
begin
  RegisterComponents('Animated Menus', [TSubMenu2000]);
  RegisterPropertyEditor(TypeInfo(TPhantomMenuItem), nil, '', TPhantomMenuItemProperty);
end;


{ TPhantomMenuItemProperty }

procedure TPhantomMenuItemProperty.GetValues(Proc: TGetStrProc);
begin
  Designer.GetComponentNames(GetTypeData(TypeInfo(TMenuItem2000)), Proc);
end;

procedure TPhantomMenuItemProperty.SetValue(const Value: string);
var
  Component: TComponent;
begin
  if Value = '' then Component := nil else
  begin
    Component := Designer.GetComponent(Value);
    if not (Component is TMenuItem2000) then
      raise EPropertyError.CreateRes(@SInvalidPropertyValue);
  end;
  SetOrdValue(Longint(Component));
end;


end.

