unit TPSplitter;

{ written by Ralph Jaeger; published May 2 1996
  email: ralph.jaeger@neckar-alb.de}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
 TSizedEvent = procedure(APos : Integer) of object;

 TOrientation = (Horizontal, Vertical);

 TSplitControl = class
  private
    FForm: TForm;
    FSplitControl, FSizeTarget: TControl;
    FVertical: Boolean;
    FSplit: TPoint;
    function GetSizing: Boolean;
    procedure DrawSizingLine;
  public
    constructor Create(AForm: TForm);
    procedure BeginSizing(ASplitControl, ATargetControl: TControl);
    procedure ChangeSizing(X, Y: Integer);
    procedure EndSizing;
    property Sizing: Boolean read GetSizing;
  end;

  TSplitter = class(TCustomPanel)
  private
    { Private-Deklarationen }
    FTargetControl : TControl;
    Sized : TSizedEvent;
    FOrientation : TOrientation;
    Constructor Create(AOwner : TComponent); override;
    Destructor Destroy; override;
    procedure MouseDown(Button: TMouseButton;Shift: TShiftState;
               X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;
                            X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton;Shift: TShiftState;
                               X, Y: Integer); override;
    procedure SetOrientation(Value : TOrientation);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    SplitControl : TSplitControl;
  published
    { Published-Deklarationen }
    property Caption;
    property TargetControl : TControl read FTargetControl write FTargetControl;
    property OnSized : TSizedEvent read Sized write Sized;
    property Orientation : TOrientation read FOrientation
                          write SetOrientation;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Beispiele', [TSplitter]);
end;

function CToC(C1, C2: TControl; P: TPoint): TPoint;
begin
  Result := C1.ScreenToClient(C2.ClientToScreen(P));
end;

{ TSplitControl }

constructor TSplitControl.Create(AForm: TForm);
begin
  FForm := AForm;
end;

function TSplitControl.GetSizing: Boolean;
begin
  Result := FSplitControl <> nil;
end;

procedure TSplitControl.DrawSizingLine;
var
  P: TPoint;
begin
  P := CToC(FForm, FSplitControl, FSplit);
  with FForm.Canvas do
  begin
    MoveTo(P.X, P.Y);
    if FVertical then
      LineTo(CToC(FForm, FSplitControl, Point(FSplitControl.Width, 0)).X, P.Y) else
      LineTo(P.X, CToC(FForm, FSplitControl, Point(0, FSplitControl.Height)).Y)
  end;
end;

procedure TSplitControl.BeginSizing(ASplitControl, ATargetControl: TControl);
begin
  FSplitControl := ASplitControl;
  FSizeTarget := ATargetControl;
  SetCaptureControl(FSplitControl);
  FVertical := ASplitControl.Width > ASplitControl.Height;
  if FVertical then
    FSplit := Point(0, ASplitControl.Top) else
    FSplit := Point(ASplitControl.Left, 0);
  FForm.Canvas.Handle := GetDCEx(FForm.Handle, 0, DCX_CACHE or DCX_CLIPSIBLINGS
    or DCX_LOCKWINDOWUPDATE);
  with FForm.Canvas do
  begin
    Pen.Color := clWhite;
    if FVertical then
      Pen.Width := 1 else
      Pen.Width := 1;
    Pen.Mode := pmXOR;
  end;
  DrawSizingLine;
end;

procedure TSplitControl.ChangeSizing(X, Y: Integer);
begin
  DrawSizingLine;
  if FVertical then FSplit.Y := Y else FSplit.X := X;
  DrawSizingLine;
end;

procedure TSplitControl.EndSizing;
var
  DC: HDC;
  P: TPoint;
begin
  DrawSizingLine;
  P := CToC(FSizeTarget, FSplitControl, FSplit);
  SetCaptureControl(nil);
  FSplitControl := nil;
  with FForm do
  begin
    DC := Canvas.Handle;
    Canvas.Handle := 0;
    ReleaseDC(Handle, DC);
  end;
  if FVertical then
    FSizeTarget.Height := P.Y else
    FSizeTarget.Width  := P.X;
end;


Constructor TSplitter.Create(AOwner : TComponent);
begin
 inherited Create(AOwner);
SplitControl:=TSplitControl.Create(TForm(Owner));
Case FOrientation of
 Vertical :
  begin
   Align:=alLeft;
   Width:=6;
   SplitControl.FVertical:=True;
   Cursor:=crHSplit;
  end;
 Horizontal:
  begin
   Align:=alTop;
   Height:=6;
   SplitControl.FVertical:=False;
   Cursor:=crVSplit;
  end;
 end;
{ OnMouseDown:=MouseDown;
 OnMouseMove:=MouseMove;
 OnMouseUp:=MouseUp;}
end;

Destructor TSplitter.Destroy;
begin
 SplitControl.Free;
 inherited;
end;

procedure TSplitter.MouseDown(Button: TMouseButton;
                    Shift: TShiftState; X, Y: Integer);
begin
inherited;
if FTargetControl=nil then
begin
 ShowMessage('You need to specify a targetcontrol');
 exit;
end;
 if (Button = mbLeft) and (Shift = [ssLeft]) then
     SplitControl.BeginSizing(Self, FTargetControl);
end;

procedure TSplitter.MouseMove(Shift: TShiftState;
                                X, Y: Integer);
begin
inherited;
  with SplitControl do if Sizing then ChangeSizing(X, Y);
end;

procedure TSplitter.MouseUp(Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);
begin
inherited;
 with  SplitControl do if Sizing then
 begin
  EndSizing;
  if Assigned(Sized) then
  begin
   if FVertical then Self.Sized(Left)
   else Self.Sized(Top);
  end;
 end;
end;

procedure TSplitter.SetOrientation(Value : TOrientation);
begin
Case Value of
 Vertical :
  begin
   Align:=alLeft;
   Width:=6;
   SplitControl.FVertical:=True;
   Cursor:=crHSplit;
  end;
 Horizontal:
  begin
   Align:=alTop;
   Height:=6;
   SplitControl.FVertical:=False;
   Cursor:=crVSplit;
  end;
end;
FOrientation:=Value;
end;

end.
