(*****************************************
 *** TSoniquePack-Test 1.0 by Baerware ***
 *** (c) 2002 Sebastian Brhausen ********
 *** e-mail: baerware@web.de *************
 *****************************************)


(*
This is a very simple test for the TSoniqueRemote and TSoniqueVis components.
A real MP3 player would of course provide much better playlist functions,
a nice GUI and many other things...
*)


unit FSoniquePackTest;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	SoniqueVis, StdCtrls, SoniqueRemote, ExtCtrls, ComCtrls, Buttons;

type
	TSoniquePackTestForm = class(TForm)
		SoniqueVis: TSoniqueVis;
		bOpenPlugin: TButton;
		OpenPluginDialog: TOpenDialog;
		bFullscreen: TButton;
		bPlay: TButton;
		Timer: TTimer;
		pbProgress: TProgressBar;
		bHideSonique: TButton;
		bShowSonique: TButton;
		bPause: TButton;
		bStop: TButton;
		bPrevious: TButton;
		bNext: TButton;
		bDelete: TButton;
    bPlayFile: TButton;
		SoniqueRemote: TSoniqueRemote;
		lPluginName: TLabel;
		Bevel1: TBevel;
		OpenFileDialog: TOpenDialog;
		bAddFile: TButton;
		lProgress: TLabel;
		lFileName: TLabel;
		bEqualizer: TSpeedButton;
		lPlayState: TLabel;
		tbFramesPerSecond: TTrackBar;
		lFramesPerSecond: TLabel;
    lCopyright: TLabel;
		procedure bOpenPluginClick(Sender: TObject);
		procedure bFullscreenClick(Sender: TObject);
		procedure tbFramesPerSecondChange(Sender: TObject);
		procedure bHideSoniqueClick(Sender: TObject);
		procedure bShowSoniqueClick(Sender: TObject);
		procedure bPlayFileClick(Sender: TObject);
		procedure bAddFileClick(Sender: TObject);
		procedure bPlayClick(Sender: TObject);
		procedure bPauseClick(Sender: TObject);
		procedure bStopClick(Sender: TObject);
		procedure bDeleteClick(Sender: TObject);
		procedure bPreviousClick(Sender: TObject);
		procedure bNextClick(Sender: TObject);
		procedure bEqualizerClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure SoniqueVisDblClick(Sender: TObject);
		procedure SoniqueRemoteInfoChanged(Sender: TObject);
		procedure TimerTimer(Sender: TObject);
	private
	public
	end;

var
	SoniquePackTestForm: TSoniquePackTestForm;

implementation

{$R *.DFM}

procedure TSoniquePackTestForm.bOpenPluginClick(Sender: TObject);
begin
	if OpenPluginDialog.Execute then
	begin
		SoniqueVis.VisFileName := OpenPluginDialog.FileName;
		lPluginName.Caption := 'Plugin name: ' + SoniqueVis.VisName;
	end;
end;

procedure TSoniquePackTestForm.bFullscreenClick(Sender: TObject);
begin
	SoniqueVis.Fullscreen := True;
end;

procedure TSoniquePackTestForm.tbFramesPerSecondChange(Sender: TObject);
begin
	SoniqueVis.FramesPerSecond := tbFramesPerSecond.Position;
	lFramesPerSecond.Caption := IntToStr(tbFramesPerSecond.Position) + ' FPS';
end;

procedure TSoniquePackTestForm.bHideSoniqueClick(Sender: TObject);
begin
	SoniqueRemote.HideSonique;
end;

procedure TSoniquePackTestForm.bShowSoniqueClick(Sender: TObject);
begin
	SoniqueRemote.ShowSonique;
end;

procedure TSoniquePackTestForm.bPlayFileClick(Sender: TObject);
begin
	OpenFileDialog.Title := 'Play MP3 file or playlist';
	if OpenFileDialog.Execute then SoniqueRemote.PlayFile(OpenFileDialog.FileName);
end;

procedure TSoniquePackTestForm.bAddFileClick(Sender: TObject);
begin
	OpenFileDialog.Title := 'Add MP3 file or playlist';
	if OpenFileDialog.Execute then SoniqueRemote.PlayFile(OpenFileDialog.FileName);
end;

procedure TSoniquePackTestForm.bPlayClick(Sender: TObject);
begin
	SoniqueRemote.Play;
end;

procedure TSoniquePackTestForm.bPauseClick(Sender: TObject);
begin
	SoniqueRemote.Pause;
end;

procedure TSoniquePackTestForm.bStopClick(Sender: TObject);
begin
	SoniqueRemote.Stop;
end;

procedure TSoniquePackTestForm.bDeleteClick(Sender: TObject);
begin
	SoniqueRemote.DeleteSong;
end;

procedure TSoniquePackTestForm.bPreviousClick(Sender: TObject);
begin
	SoniqueRemote.PreviousSong;
end;

procedure TSoniquePackTestForm.bNextClick(Sender: TObject);
begin
	SoniqueRemote.NextSong;
end;

procedure TSoniquePackTestForm.bEqualizerClick(Sender: TObject);
begin
	SoniqueRemote.EqualizerEnabled := not SoniqueRemote.EqualizerEnabled;
end;

procedure TSoniquePackTestForm.FormCreate(Sender: TObject);
begin
	OpenPluginDialog.InitialDir := ExtractFileDir(SoniqueRemote.SoniqueEXE) + '\vis';
	OpenFileDialog.InitialDir := ExtractFileDir(SoniqueRemote.SoniqueEXE);
	tbFramesPerSecond.Position := SoniqueVis.FramesPerSecond;
	bEqualizer.Down := SoniqueRemote.EqualizerEnabled;
	bOpenPluginClick(Self);
end;

procedure TSoniquePackTestForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	SoniqueVis.VisFileName := '';
end;

procedure TSoniquePackTestForm.SoniqueVisDblClick(Sender: TObject);
begin
	SoniqueVis.Fullscreen := not SoniqueVis.Fullscreen;
end;

procedure TSoniquePackTestForm.SoniqueRemoteInfoChanged(Sender: TObject);
begin
	pbProgress.Max := SoniqueRemote.SongLength;
end;

procedure TSoniquePackTestForm.TimerTimer(Sender: TObject);
begin
	SoniqueVis.Enabled := GetFocus <> 0;
	lFileName.Caption := 'File name: ' + ExtractFileName(SoniqueRemote.FileName);
	case SoniqueRemote.PlayState of
		psStopped:
		begin
			bPlay.Enabled := True;
			bPause.Enabled := False;
			bStop.Enabled := False;
			lPlayState.Caption := 'Stopped';
		end;
		psPlaying:
		begin
			bPlay.Enabled := False;
			bPause.Enabled := True;
			bStop.Enabled := True;
			lPlayState.Caption := 'Playing';
		end;
		psPaused:
		begin
			bPlay.Enabled := True;
			bPause.Enabled := False;
			bStop.Enabled := True;
			lPlayState.Caption := 'Paused';
		end;
	end;
	pbProgress.Position := SoniqueRemote.SongPosition;
end;

end.
