(**************************************
 *** Plugin constants and types 1.1 ***
 *** by Baerware **********************
 *** (c) 2003 Sebastian Brhausen *****
 *** e-mail: baerware@web.de **********
 **************************************)


(*
All documentation is just copied from the original C++ header vis.h from the Sonique
homepage http://sonique.lycos.com/customize/developer.php.
*)


const
	VIS_WAVEFORM = 1; // set if you need the waveform
	VIS_SPECTRUM = 2; // set if you need the FFT values
	VIS_SONIQUE_VIS_PROC = 4; // set if you want to allow Soniques user pref vis to affect your vis
													// for example - blur, smoke and zoom

type
	PVisData = ^TVisData;
	TVisData = record
		MillSec: Cardinal; // Sonique sets this to the time stamp of end this block of data
		Waveform: array[0..1, 0..511] of Byte; // Sonique sets this to the PCM data being outputted at this time
		Spectrum: array[0..1, 0..255] of Byte; // Sonique sets this to a lowfidely version of the spectrum data
																					 // being outputted at this time
	end;

	PVisInfo = ^TVisInfo;
	TVisInfo = record
		Reserved: Cardinal; // Reserved

		PluginName: PChar; // Set to the name of the plugin
		Required: Longint; // Which vis data this plugin requires (set to a combination of
											 // the VIS_WAVEFORM, VIS_SPECTRUM and VIS_SONIQUE_VIS_PROC flags)

		InitializeProc: procedure; cdecl;
			// Called some time before your plugin is asked to StartRendering for
			// the first time
		RenderProc: function(VideoP: Pointer; Width, Height, Pitch: Integer; VisDataP: PVisData): Boolean; cdecl;
			// Called for each frame. Pitch is in pixels and can be negative.
			// StartRendering like this:
			// for (y = 0; y < height; y++)
			// {
			//    for (x = 0; x < width; x++)
			//       Video[x] = <pixel value>;
			//	  Video += pitch;
			// }
			//				OR
			// void PutPixel(int x, int y, unsigned long Pixel)
			// {
			//    _ASSERT( x >= 0 && x < width && y >= 0 && y < height );
			//	  Video[y*pitch+x] = Pixel;
			// }
		SaveSettingsProc: function(FileName: PChar): Boolean; cdecl;
			// Use WritePrivateProfileString to save settings when this is called
			// Example:
			// WritePrivateProfileString("my plugin", "brightness", "3", FileName);
		OpenSettingsProc: function(FileName: PChar): Boolean; cdecl;
			// Use GetPrivateProfileString similarly:
			// char BrightnessBuffer[256];
			// GetPrivateProfileString("my plugin", "brightness", "3", BrightnessBuffer, sizeof(BrightnessBuffer), FileName);
	end;
