(*************************************
 *** Simple_Plugin 1.0 by Baerware ***
 *** (c) 2003 Sebastian Brhausen ****
 *** e-mail: baerware@web.de *********
 *************************************)


(*
All documentation is just copied from the original C++ header vis.h and example plugin vis.c
from the Sonique homepage http://sonique.lycos.com/customize/developer.php.

Feel free to write your own plugins by modifying this code.
*)


library Simple_Plugin;

uses
  SysUtils,
  Classes,
  Windows,
  Graphics;

{$E svp}
{$R *.RES}

{$I SoniquePlugin.inc}

const
	PLUGIN_NAME = 'Simple Plugin';

var
	VisInfo: TVisInfo;
	SaveExit: Pointer;
	RenderBitmap: TBitmap;

(*====================================================================================
	Definition of the Initialize function

		fill in with whatever you need to initialize, this gets called before the
		plug-in starts.

		you can leave it empty (as is).
====================================================================================*)
procedure Initialize; cdecl;
begin
end;

(*====================================================================================
	Definition of the Render function

		this is where you place your visual code,

			Render should draw a whole frame into the 32 bit ABGR buffer (for blur, smoke
			and zoom to work it should, rather than replacing the video data, add to it
			using bitwise or, saturated add, or	alpha blend). Make sure not to exceed the
			boundaries given. 'Pitch' specifies	the distance, in pixels, between the start
			of each line. If you have a pointer	at the start of a line, Pointer+Pitch is
			the start of the next line and Pointer-Pitch is the start of the previous.

		this is the only function that you have to have something in.

			Called for each frame. Pitch is in pixels and can be negative.
			Render like this:
			for (y = 0; y < height; y++)
			{
				 for (x = 0; x < width; x++)
						Video[x] = <pixel value>;
				Video += pitch;
			}
						OR
			void PutPixel(int x, int y, unsigned long Pixel)
			{
				 _ASSERT( x >= 0 && x < width && y >= 0 && y < height );
				Video[y*pitch+x] = Pixel;
			}

		return TRUE when you've finished draw to the buffer.

====================================================================================*)
function Render(VideoP: Pointer; Width, Height, Pitch: Integer; VisDataP: PVisData): Boolean; cdecl;
var Y: Integer;
begin
	// set the size of RenderBitmap
	RenderBitmap.Width := Width;
	RenderBitmap.Height := Height;

	// render a black background
	RenderBitmap.Canvas.Brush.Color := clBlack;
	RenderBitmap.Canvas.Brush.Style := bsSolid;
	RenderBitmap.Canvas.Pen.Color := clBlack;
	RenderBitmap.Canvas.Pen.Style := psSolid;
	RenderBitmap.Canvas.Rectangle(0, 0, Width, Height);

	// render a red unfilled rectangle from (10, 10) to (100, 100)
	RenderBitmap.Canvas.Brush.Style := bsClear;
	RenderBitmap.Canvas.Pen.Color := clRed;
	RenderBitmap.Canvas.Rectangle(10, 10, 100, 100);
	// any other rendering operation...

	(* VideoP points (like described above) to an array of 32 bit ABGR-values (Alpha, Blue, Green, Red). TBitmap also provides such
	an array by the function ScanLine[Y]. It is therefore possible to copy memory directly without reading and writing each pixel.
	But since Pitch can be both positive and negative you can not copy the whole array at once by CopyMemory because in one case the
	bitmap would be mirrored at the x-axis. By copying line by line (with Pitch * 4 bytes distance) you can take care of this problem.
	Each line has Width * 4 bytes. *)
	for Y := 0 to Height - 1 do CopyMemory(Pointer(Cardinal(VideoP) + Cardinal(Y * Pitch * 4)), RenderBitmap.ScanLine[Y], Width * 4);

	Render := True;
end;

(*====================================================================================
	Definition of the SaveSettings function

		to save the settings of anything you want regarding your plugin.

		use WritePrivateProfileString to save the settings.
			ie. WritePrivateProfileString("my plugin", "brightness", "3", FileName);

		return TRUE if the saving worked or FALSE if it failed.

		you can leave it empty (as is).
====================================================================================*)
function SaveSettings(FileName: PChar): Boolean; cdecl;
begin
	SaveSettings := True;
end;

(*====================================================================================
	Definition of the OpenSettings function

		to open the settings of anything you want regarding your plugin.

		use GetPrivateProfileString to save the settings.
			ie. char BrightnessBuffer[256];
				GetPrivateProfileString("my plugin", "brightness", "3", BrightnessBuffer, sizeof(BrightnessBuffer), FileName);

		return TRUE if the opening worked or FALSE if it failed.

		you can leave it empty (as is).
====================================================================================*)
function OpenSettings(FileName: PChar): Boolean; cdecl;
begin
	OpenSettings := True;
end;

(*====================================================================================
	Definition of the DLL export (don't change)
====================================================================================*)
function QueryModule: PVisInfo; cdecl;
begin
	QueryModule := @VisInfo;
end;

exports QueryModule;

procedure LibExit;
begin
	// free RenderBitmap
	RenderBitmap.Free;

	ExitProc := SaveExit;
end;


begin
	(*====================================================================================
		The actual details for your plugin

		1. Reserved (leave as NULL)
		2. Plug-In Name (char*, the name you want displayed when your plug-in is playing)
		3. Options (VI_WAVEFORM - if you need the waveform PCM data
								VI_SPECTRUM - if you need the spectrum FFT data
					SONIQUEVISPROC - if you want user defined blurs to effect your plugin)
		4. Name of the Initialize function (leave as is)
		5. Name of the Render function (leave as is)
		6. Name of the SaveSettings function (leave as is)
		7. Name of the OpenSettings function (leave as is)
	====================================================================================*)
	with VisInfo do
	begin
		Reserved := 0;
		GetMem(PluginName, Length(PLUGIN_NAME) + 1);
		StrPCopy(PluginName, PLUGIN_NAME);
		Required := VIS_WAVEFORM or VIS_SPECTRUM;
		InitializeProc := @Initialize;
		RenderProc := @Render;
		SaveSettingsProc := @SaveSettings;
		OpenSettingsProc := @OpenSettings;
	end;
	SaveExit := ExitProc;
	ExitProc := @LibExit;

	// initalize RenderBitmap
	RenderBitmap := TBitmap.Create;
	RenderBitmap.PixelFormat := pf32bit; // 32 bit for ABGR-values (Alpha, Blue, Green, Red)
end.
