(************************************
 *** Dummy Plugin 1.0 by Baerware ***
 *** needed for TSoniqueVis *********
 *** (c) 2002 Sebastian Brhausen ***
 *** e-mail: baerware@web.de ********
 ************************************)


(*
All documentation is just copied from the original C++ header vis.h and example plugin vis.c
from the Sonique homepage http://sonique.lycos.com/customize/developer.php.

Feel free to write your own plugins by modifying this code.
*)


library Baerware_Dummy_Plugin;

uses
	SysUtils,
	Classes,
	Windows;

{$E svp}
{$R *.RES}

{$I SoniquePlugin.inc}

const
	DUMMY_PLUGIN_NAME = 'Baerware Dummy Plugin';
	SHARED_VISDATA_NAME = 'BaerwareDummyPluginVisData';

var
	VisInfo: TVisInfo;
	VisDataHandle: THandle;
	VisData: PVisData;
	SaveExit: Pointer;

(*====================================================================================
	Definition of the Initialize function

		fill in with whatever you need to initialize, this gets called before the
		plug-in starts.

		you can leave it empty (as is).
====================================================================================*)
procedure Initialize; cdecl;
begin
end;

(*====================================================================================
	Definition of the Render function

		this is where you place your visual code,

			Render should draw a whole frame into the 32 bit ABGR buffer (for blur, smoke
			and zoom to work it should, rather than replacing the video data, add to it
			using bitwise or, saturated add, or	alpha blend). Make sure not to exceed the
			boundaries given. 'Pitch' specifies	the distance, in pixels, between the start
			of each line. If you have a pointer	at the start of a line, Pointer+Pitch is
			the start of the next line and Pointer-Pitch is the start of the previous.

		this is the only function that you have to have something in.

			Called for each frame. Pitch is in pixels and can be negative.
			Render like this:
			for (y = 0; y < height; y++)
			{
				 for (x = 0; x < width; x++)
						Video[x] = <pixel value>;
				Video += pitch;
			}
						OR
			void PutPixel(int x, int y, unsigned long Pixel)
			{
				 _ASSERT( x >= 0 && x < width && y >= 0 && y < height );
				Video[y*pitch+x] = Pixel;
			}

		return TRUE when you've finished draw to the buffer.

====================================================================================*)
function Render(VideoP: Pointer; Width, Height, Pitch: Integer; VisDataP: PVisData): Boolean; cdecl;
begin
	if Assigned(VisData) and Assigned(VisDataP) then VisData^ := VisDataP^;
	Render := True;
end;

(*====================================================================================
	Definition of the SaveSettings function

		to save the settings of anything you want regarding your plugin.

		use WritePrivateProfileString to save the settings.
			ie. WritePrivateProfileString("my plugin", "brightness", "3", FileName);

		return TRUE if the saving worked or FALSE if it failed.

		you can leave it empty (as is).
====================================================================================*)
function SaveSettings(FileName: PChar): Boolean; cdecl;
begin
	SaveSettings := True;
end;

(*====================================================================================
	Definition of the OpenSettings function

		to open the settings of anything you want regarding your plugin.

		use GetPrivateProfileString to save the settings.
			ie. char BrightnessBuffer[256];
				GetPrivateProfileString("my plugin", "brightness", "3", BrightnessBuffer, sizeof(BrightnessBuffer), FileName);

		return TRUE if the opening worked or FALSE if it failed.

		you can leave it empty (as is).
====================================================================================*)
function OpenSettings(FileName: PChar): Boolean; cdecl;
begin
	OpenSettings := True;
end;

(*====================================================================================
	Definition of the DLL export (don't change)
====================================================================================*)
function QueryModule: PVisInfo; cdecl;
begin
	QueryModule := @VisInfo;
end;

exports QueryModule;

procedure LibExit;
begin
	if VisDataHandle <> 0 then
	begin
		if Assigned(VisData) then UnmapViewOfFile(VisData);
		CloseHandle(VisDataHandle);
	end;
	ExitProc := SaveExit;
end;

begin
	(*====================================================================================
		The actual details for your plugin

		1. Reserved (leave as NULL)
		2. Plug-In Name (char*, the name you want displayed when your plug-in is playing)
		3. Options (VI_WAVEFORM - if you need the waveform PCM data
								VI_SPECTRUM - if you need the spectrum FFT data
					SONIQUEVISPROC - if you want user defined blurs to effect your plugin)
		4. Name of the Initialize function (leave as is)
		5. Name of the Render function (leave as is)
		6. Name of the SaveSettings function (leave as is)
		7. Name of the OpenSettings function (leave as is)
	====================================================================================*)
	with VisInfo do
	begin
		Reserved := 0;
		GetMem(PluginName, Length(DUMMY_PLUGIN_NAME) + 1);
		StrPCopy(PluginName, DUMMY_PLUGIN_NAME);
		Required := VIS_WAVEFORM or VIS_SPECTRUM;
		InitializeProc := @Initialize;
		RenderProc := @Render;
		SaveSettingsProc := @SaveSettings;
		OpenSettingsProc := @OpenSettings;
	end;
	VisDataHandle := CreateFileMapping(THandle($FFFFFFFF), nil,
		PAGE_READWRITE or SEC_COMMIT, 0, SizeOf(TVisData) + 1, SHARED_VISDATA_NAME);
	if VisDataHandle <> 0 then
	begin
		VisData := MapViewOfFile(VisDataHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
		if not Assigned(VisData) then
		begin
			CloseHandle(VisDataHandle);
			VisDataHandle := 0;
		end;
	end;
	SaveExit := ExitProc;
	ExitProc := @LibExit;
end.
