{
tscap32 - Delphi Video Capture Component
Copyright (C) 1996-2003 Thomas Stuefe

contact: tstuefe@users.sourceforge.net
web:     tscap32.sourceforge.net


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
}


{////////////////////////////////////////////////////////////
 // Unit tstlg.pas
 //
 //
 // Fixed WMF Definition - created with tsTech WMF2Src}


 // Date: 30.03.97 Time: 20:28:21
unit tstlg;


interface


uses Classes, Windows, Graphics, Dialogs, SysUtils;


type

TtsMetaFile = class(TMetaFile)
public
  procedure WriteData(Stream: TStream); override;
  procedure ReadData(Stream: TStream); override;
  procedure Draw(ACanvas: TCanvas; const Rect: TRect); override;
end;

TFixedMeta_Data1 = array[0..9223] of Byte;
TFixedMeta_Data2 = array[0..9337] of Byte;

TFixedMeta_ChkPnts = array[0..99] of LongInt;

TFixedMeta_ChkPntVal = array[0..99] of Byte;

procedure FIXWMF_DrawToCanvas(Canvas: TCanvas; x, y, w, h: Integer); pascal;

const
AUTHOR_STRING: string = 'Thomas Stfe';


FixedMeta_Data1: TFixedMeta_Data1 =
($08, $24, $00, $00, $D7, $CD, $C6, $9A, $00, $00, $00, $00, $00, $00, $A8, $AA, $C8, $74, $E8, $03, $00, $00, $00, $00, $99, $8A, $01, $00, $09, $00, $00, $03,
$F7, $11, $00, $00, $05, $00, $5D, $00, $00, $00, $00, $00, $05, $00, $00, $00, $0B, $02, $28, $0E, $1A, $F0, $05, $00, $00, $00, $0C, $02, $67, $FB, $B8, $06,
$04, $00, $00, $00, $06, $01, $01, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $24, $56, $45, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $09, $00,
$00, $00, $FA, $02, $05, $00, $00, $00, $00, $00, $FF, $FF, $FF, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, 
$0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $B0, $0A, $D3, $F6, $8F, $09, $1B, $F0, $8F, $09, $1B, $F0, $B0, $0A, $D3, $F6, $B0, $0A, $09, $00, $00, $00, 
$FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $02, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $FF, $FF, 
$FF, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $24, $56, $45, $00, 
$00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03,
$05, $00, $D3, $F6, $B0, $0A, $D3, $F6, $CD, $0A, $1B, $F0, $CD, $0A, $1B, $F0, $B0, $0A, $D3, $F6, $B0, $0A, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, 
$00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $24, $54, $44, $00, $00, $00, $04, $00, $00, $00,
$2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $BE, $0A,
$D3, $F6, $DC, $0A, $1B, $F0, $DC, $0A, $1B, $F0, $BE, $0A, $D3, $F6, $BE, $0A, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, 
$04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $23, $52, $42, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00,
$00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $CD, $0A, $D3, $F6, $EB, $0A, $1B, $F0, 
$EB, $0A, $1B, $F0, $CD, $0A, $D3, $F6, $CD, $0A, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $22, $50, $40, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $DC, $0A, $D3, $F6, $FA, $0A, $1B, $F0, $FA, $0A, $1B, $F0, $DC, $0A,
$D3, $F6, $DC, $0A, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00,
$FC, $02, $00, $00, $21, $4E, $3E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, 
$01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $EB, $0A, $D3, $F6, $09, $0B, $1B, $F0, $09, $0B, $1B, $F0, $EB, $0A, $D3, $F6, $EB, $0A, $04, $00, 
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $20, $4B, 
$3D, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00,
$24, $03, $05, $00, $D3, $F6, $FA, $0A, $D3, $F6, $18, $0B, $1B, $F0, $18, $0B, $1B, $F0, $FA, $0A, $D3, $F6, $FA, $0A, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1F, $49, $3B, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, 
$09, $0B, $D3, $F6, $27, $0B, $1B, $F0, $27, $0B, $1B, $F0, $09, $0B, $D3, $F6, $09, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01,
$03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1E, $47, $39, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $18, $0B, $D3, $F6, $36, $0B,
$1B, $F0, $36, $0B, $1B, $F0, $18, $0B, $D3, $F6, $18, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00,
$F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1D, $45, $37, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01,
$01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $27, $0B, $D3, $F6, $45, $0B, $1B, $F0, $45, $0B, $1B, $F0, 
$27, $0B, $D3, $F6, $27, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, 
$00, $00, $FC, $02, $00, $00, $1C, $43, $36, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00,
$06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $36, $0B, $D3, $F6, $54, $0B, $1B, $F0, $54, $0B, $1B, $F0, $36, $0B, $D3, $F6, $36, $0B,
$04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, 
$1B, $40, $34, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, 
$00, $00, $24, $03, $05, $00, $D3, $F6, $45, $0B, $D3, $F6, $63, $0B, $1B, $F0, $63, $0B, $1B, $F0, $45, $0B, $D3, $F6, $45, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1A, $3E, $32, $00, $00, $00,
$04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00,
$D3, $F6, $54, $0B, $D3, $F6, $72, $0B, $1B, $F0, $72, $0B, $1B, $F0, $54, $0B, $D3, $F6, $54, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, 
$2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $19, $3C, $30, $00, $00, $00, $04, $00, $00, $00, $2D, $01,
$00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $63, $0B, $D3, $F6,
$81, $0B, $1B, $F0, $81, $0B, $1B, $F0, $63, $0B, $D3, $F6, $63, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00,
$00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $18, $3A, $2E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, 
$2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $72, $0B, $D3, $F6, $90, $0B, $1B, $F0, $90, $0B, 
$1B, $F0, $72, $0B, $D3, $F6, $72, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, 
$07, $00, $00, $00, $FC, $02, $00, $00, $18, $38, $2D, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, 
$00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $81, $0B, $D3, $F6, $9F, $0B, $1B, $F0, $9F, $0B, $1B, $F0, $81, $0B, $D3, $F6, 
$81, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, 
$00, $00, $17, $35, $2B, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, 
$0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $90, $0B, $D3, $F6, $AE, $0B, $1B, $F0, $AE, $0B, $1B, $F0, $90, $0B, $D3, $F6, $90, $0B, $04, $00, $00, $00,
$2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $16, $33, $29, $00, 
$00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, 
$05, $00, $D3, $F6, $9F, $0B, $D3, $F6, $BD, $0B, $1B, $F0, $BD, $0B, $1B, $F0, $9F, $0B, $D3, $F6, $9F, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, 
$00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $15, $31, $27, $00, $00, $00, $04, $00, $00, $00,
$2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $AE, $0B, 
$D3, $F6, $CC, $0B, $1B, $F0, $CC, $0B, $1B, $F0, $AE, $0B, $D3, $F6, $AE, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00,
$04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $14, $2F, $26, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00,
$00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $BD, $0B, $D3, $F6, $DB, $0B, $1B, $F0,
$DB, $0B, $1B, $F0, $BD, $0B, $D3, $F6, $BD, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01,
$00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $13, $2D, $24, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00,
$04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $CC, $0B, $D3, $F6, $EA, $0B, $1B, $F0, $EA, $0B, $1B, $F0, $CC, $0B, 
$D3, $F6, $CC, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, 
$FC, $02, $00, $00, $12, $2A, $22, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01,
$01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $DB, $0B, $D3, $F6, $F9, $0B, $1B, $F0, $F9, $0B, $1B, $F0, $DB, $0B, $D3, $F6, $DB, $0B, $04, $00, 
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $11, $28, 
$20, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, 
$24, $03, $05, $00, $D3, $F6, $EA, $0B, $D3, $F6, $08, $0C, $1B, $F0, $08, $0C, $1B, $F0, $EA, $0B, $D3, $F6, $EA, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $10, $26, $1F, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6,
$F9, $0B, $D3, $F6, $17, $0C, $1B, $F0, $17, $0C, $1B, $F0, $F9, $0B, $D3, $F6, $F9, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $0F, $24, $1D, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $08, $0C, $D3, $F6, $26, $0C,
$1B, $F0, $26, $0C, $1B, $F0, $08, $0C, $D3, $F6, $08, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, 
$F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $0E, $22, $1B, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, 
$01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $17, $0C, $D3, $F6, $35, $0C, $1B, $F0, $35, $0C, $1B, $F0,
$17, $0C, $D3, $F6, $17, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, 
$00, $00, $FC, $02, $00, $00, $0D, $1F, $19, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, 
$06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $26, $0C, $D3, $F6, $44, $0C, $1B, $F0, $44, $0C, $1B, $F0, $26, $0C, $D3, $F6, $26, $0C, 
$04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00,
$0C, $1D, $17, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, 
$00, $00, $24, $03, $05, $00, $D3, $F6, $35, $0C, $D3, $F6, $53, $0C, $1B, $F0, $53, $0C, $1B, $F0, $35, $0C, $D3, $F6, $35, $0C, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $0C, $1B, $16, $00, $00, $00, 
$04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00,
$D3, $F6, $44, $0C, $D3, $F6, $62, $0C, $1B, $F0, $62, $0C, $1B, $F0, $44, $0C, $D3, $F6, $44, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00,
$2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $0B, $19, $14, $00, $00, $00, $04, $00, $00, $00, $2D, $01, 
$00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $53, $0C, $D3, $F6, 
$71, $0C, $1B, $F0, $71, $0C, $1B, $F0, $53, $0C, $D3, $F6, $53, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00,
$00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $0A, $17, $12, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00,
$2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $62, $0C, $D3, $F6, $80, $0C, $1B, $F0, $80, $0C,
$1B, $F0, $62, $0C, $D3, $F6, $62, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00,
$07, $00, $00, $00, $FC, $02, $00, $00, $09, $14, $10, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00,
$00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $71, $0C, $D3, $F6, $8F, $0C, $1B, $F0, $8F, $0C, $1B, $F0, $71, $0C, $D3, $F6, 
$71, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02,
$00, $00, $08, $12, $0F, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00,
$0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $80, $0C, $D3, $F6, $9E, $0C, $1B, $F0, $9E, $0C, $1B, $F0, $80, $0C, $D3, $F6, $80, $0C, $04, $00, $00, $00, 
$2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $07, $10, $0D, $00,
$00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, 
$05, $00, $D3, $F6, $8F, $0C, $D3, $F6, $AD, $0C, $1B, $F0, $AD, $0C, $1B, $F0, $8F, $0C, $D3, $F6, $8F, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, 
$00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $06, $0E, $0B, $00, $00, $00, $04, $00, $00, $00, 
$2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $9E, $0C,
$D3, $F6, $BC, $0C, $1B, $F0, $BC, $0C, $1B, $F0, $9E, $0C, $D3, $F6, $9E, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, 
$04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $05, $0C, $09, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00,
$00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $AD, $0C, $D3, $F6, $CB, $0C, $1B, $F0,
$CB, $0C, $1B, $F0, $AD, $0C, $D3, $F6, $AD, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $04, $09, $08, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00,
$04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $BC, $0C, $D3, $F6, $DA, $0C, $1B, $F0, $DA, $0C, $1B, $F0, $BC, $0C, 
$D3, $F6, $BC, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, 
$FC, $02, $00, $00, $03, $07, $06, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, 
$01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $CB, $0C, $D3, $F6, $E9, $0C, $1B, $F0, $E9, $0C, $1B, $F0, $CB, $0C, $D3, $F6, $CB, $0C, $04, $00, 
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $02, $05, 
$04, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, 
$24, $03, $05, $00, $D3, $F6, $DA, $0C, $D3, $F6, $F8, $0C, $1B, $F0, $F8, $0C, $1B, $F0, $DA, $0C, $D3, $F6, $DA, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $01, $03, $02, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, 
$E9, $0C, $D3, $F6, $07, $0D, $1B, $F0, $07, $0D, $1B, $F0, $E9, $0C, $D3, $F6, $E9, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $00, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $00, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $D3, $F6, $F8, $0C, $D3, $F6, $15, $0D,
$1B, $F0, $15, $0D, $1B, $F0, $F8, $0C, $D3, $F6, $F8, $0C, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00,
$2D, $01, $00, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0E, $00, $00, $00, $24, $03, $05, $00, $1B, $F0, $29, $0E,
$D3, $F6, $29, $0E, $D3, $F6, $07, $0D, $1B, $F0, $07, $0D, $1B, $F0, $29, $0E, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00,
$07, $00, $00, $00, $FC, $02, $00, $00, $11, $26, $1E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00,
$00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, $7D, $0B,
$9D, $F2, $75, $0B, $F3, $F1, $75, $0B, $F3, $F1, $7D, $0B, $9D, $F2, $7D, $0B, $D1, $F1, $7D, $0B, $6B, $F1, $7D, $0B, $6B, $F1, $75, $0B, $D1, $F1, $75, $0B, 
$D1, $F1, $7D, $0B, $49, $F3, $7D, $0B, $E3, $F2, $7D, $0B, $E3, $F2, $75, $0B, $49, $F3, $75, $0B, $49, $F3, $7D, $0B, $15, $F4, $7D, $0B, $6B, $F3, $7D, $0B, 
$6B, $F3, $75, $0B, $15, $F4, $75, $0B, $15, $F4, $7D, $0B, $E3, $F4, $7D, $0B, $37, $F4, $7D, $0B, $37, $F4, $75, $0B, $E3, $F4, $75, $0B, $E3, $F4, $7D, $0B,
$6B, $F5, $7D, $0B, $05, $F5, $7D, $0B, $05, $F5, $75, $0B, $6B, $F5, $75, $0B, $6B, $F5, $7D, $0B, $AF, $F5, $7D, $0B, $8D, $F5, $7D, $0B, $8D, $F5, $75, $0B,
$AF, $F5, $75, $0B, $AF, $F5, $7D, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, 
$07, $00, $00, $00, $FC, $02, $00, $00, $11, $26, $1E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, 
$00, $00, $06, $01, $01, $00, $5D, $00, $00, $00, $38, $05, $07, $00, $07, $00, $05, $00, $05, $00, $07, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $7D, $0B, 
$9D, $F2, $85, $0B, $37, $F2, $85, $0B, $37, $F2, $81, $0B, $F3, $F1, $81, $0B, $F3, $F1, $7D, $0B, $9D, $F2, $7D, $0B, $8D, $F5, $7D, $0B, $AF, $F5, $7D, $0B, 
$AF, $F5, $85, $0B, $8D, $F5, $85, $0B, $8D, $F5, $7D, $0B, $05, $F5, $7D, $0B, $6B, $F5, $7D, $0B, $6B, $F5, $85, $0B, $05, $F5, $85, $0B, $05, $F5, $7D, $0B,
$37, $F4, $7D, $0B, $E3, $F4, $7D, $0B, $E3, $F4, $81, $0B, $9D, $F4, $81, $0B, $9D, $F4, $85, $0B, $37, $F4, $85, $0B, $37, $F4, $7D, $0B, $6B, $F3, $7D, $0B, 
$15, $F4, $7D, $0B, $15, $F4, $81, $0B, $D1, $F3, $81, $0B, $D1, $F3, $85, $0B, $6B, $F3, $85, $0B, $6B, $F3, $7D, $0B, $E3, $F2, $7D, $0B, $49, $F3, $7D, $0B,
$49, $F3, $85, $0B, $E3, $F2, $85, $0B, $E3, $F2, $7D, $0B, $6B, $F1, $7D, $0B, $D1, $F1, $7D, $0B, $D1, $F1, $85, $0B, $6B, $F1, $85, $0B, $6B, $F1, $7D, $0B,
$04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, 
$11, $27, $1F, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5D, $00, 
$00, $00, $38, $05, $07, $00, $07, $00, $05, $00, $05, $00, $07, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $81, $0B, $9D, $F2, $89, $0B, $37, $F2, $89, $0B, 
$37, $F2, $81, $0B, $F3, $F1, $81, $0B, $F3, $F1, $81, $0B, $9D, $F2, $81, $0B, $8D, $F5, $81, $0B, $AF, $F5, $81, $0B, $AF, $F5, $89, $0B, $8D, $F5, $89, $0B,
$8D, $F5, $81, $0B, $05, $F5, $81, $0B, $6B, $F5, $81, $0B, $6B, $F5, $89, $0B, $05, $F5, $89, $0B, $05, $F5, $81, $0B, $37, $F4, $81, $0B, $E3, $F4, $81, $0B, 
$E3, $F4, $81, $0B, $9D, $F4, $81, $0B, $9D, $F4, $89, $0B, $37, $F4, $89, $0B, $37, $F4, $81, $0B, $6B, $F3, $81, $0B, $15, $F4, $81, $0B, $15, $F4, $81, $0B, 
$D1, $F3, $81, $0B, $D1, $F3, $89, $0B, $6B, $F3, $89, $0B, $6B, $F3, $81, $0B, $E3, $F2, $81, $0B, $49, $F3, $81, $0B, $49, $F3, $89, $0B, $E3, $F2, $89, $0B, 
$E3, $F2, $81, $0B, $6B, $F1, $81, $0B, $D1, $F1, $81, $0B, $D1, $F1, $89, $0B, $6B, $F1, $89, $0B, $6B, $F1, $81, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $12, $29, $20, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, 
$05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, $85, $0B, $9D, $F2, $8D, $0B, $37, $F2, $8D, $0B, $37, $F2, $85, $0B, $9D, $F2, $85, $0B, 
$8D, $F5, $85, $0B, $AF, $F5, $85, $0B, $AF, $F5, $8D, $0B, $8D, $F5, $8D, $0B, $8D, $F5, $85, $0B, $05, $F5, $85, $0B, $6B, $F5, $85, $0B, $6B, $F5, $8D, $0B, 
$05, $F5, $8D, $0B, $05, $F5, $85, $0B, $37, $F4, $85, $0B, $9D, $F4, $85, $0B, $9D, $F4, $8D, $0B, $37, $F4, $8D, $0B, $37, $F4, $85, $0B, $6B, $F3, $85, $0B,
$D1, $F3, $85, $0B, $D1, $F3, $8D, $0B, $6B, $F3, $8D, $0B, $6B, $F3, $85, $0B, $E3, $F2, $85, $0B, $49, $F3, $85, $0B, $49, $F3, $8D, $0B, $E3, $F2, $8D, $0B, 
$E3, $F2, $85, $0B, $6B, $F1, $85, $0B, $D1, $F1, $85, $0B, $D1, $F1, $8D, $0B, $6B, $F1, $8D, $0B, $6B, $F1, $85, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $12, $2B, $22, $00, $00, $00, $04, $00,
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $56, $00, $00, $00, $38, $05, $06, $00, $07, $00,
$09, $00, $05, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $89, $0B, $9D, $F2, $92, $0B, $F3, $F1, $92, $0B, $F3, $F1, $8F, $0B, $37, $F2, $8F, $0B, $37, $F2,
$89, $0B, $9D, $F2, $89, $0B, $8D, $F5, $89, $0B, $AF, $F5, $89, $0B, $AF, $F5, $92, $0B, $05, $F5, $92, $0B, $05, $F5, $89, $0B, $6B, $F5, $89, $0B, $6B, $F5,
$8F, $0B, $8D, $F5, $8F, $0B, $8D, $F5, $89, $0B, $37, $F4, $89, $0B, $9D, $F4, $89, $0B, $9D, $F4, $92, $0B, $37, $F4, $92, $0B, $37, $F4, $89, $0B, $6B, $F3, 
$89, $0B, $D1, $F3, $89, $0B, $D1, $F3, $8F, $0B, $15, $F4, $8F, $0B, $15, $F4, $92, $0B, $6B, $F3, $92, $0B, $6B, $F3, $89, $0B, $E3, $F2, $89, $0B, $49, $F3, 
$89, $0B, $49, $F3, $92, $0B, $E3, $F2, $92, $0B, $E3, $F2, $89, $0B, $6B, $F1, $89, $0B, $D1, $F1, $89, $0B, $D1, $F1, $92, $0B, $6B, $F1, $92, $0B, $6B, $F1,
$89, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, 
$00, $00, $13, $2C, $23, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, 
$56, $00, $00, $00, $38, $05, $06, $00, $07, $00, $09, $00, $05, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $8D, $0B, $9D, $F2, $96, $0B, $F3, $F1, $96, $0B,
$F3, $F1, $8F, $0B, $37, $F2, $8F, $0B, $37, $F2, $8D, $0B, $9D, $F2, $8D, $0B, $8D, $F5, $8D, $0B, $AF, $F5, $8D, $0B, $AF, $F5, $96, $0B, $05, $F5, $96, $0B, 
$05, $F5, $8D, $0B, $6B, $F5, $8D, $0B, $6B, $F5, $8F, $0B, $8D, $F5, $8F, $0B, $8D, $F5, $8D, $0B, $37, $F4, $8D, $0B, $9D, $F4, $8D, $0B, $9D, $F4, $96, $0B, 
$37, $F4, $96, $0B, $37, $F4, $8D, $0B, $6B, $F3, $8D, $0B, $D1, $F3, $8D, $0B, $D1, $F3, $8F, $0B, $15, $F4, $8F, $0B, $15, $F4, $96, $0B, $6B, $F3, $96, $0B,
$6B, $F3, $8D, $0B, $E3, $F2, $8D, $0B, $49, $F3, $8D, $0B, $49, $F3, $96, $0B, $E3, $F2, $96, $0B, $E3, $F2, $8D, $0B, $6B, $F1, $8D, $0B, $D1, $F1, $8D, $0B,
$D1, $F1, $96, $0B, $6B, $F1, $96, $0B, $6B, $F1, $8D, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00,
$F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $13, $2E, $24, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01,
$01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $46, $00, $00, $00, $38, $05, $06, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, 
$92, $0B, $9D, $F2, $9A, $0B, $F3, $F1, $9A, $0B, $F3, $F1, $92, $0B, $9D, $F2, $92, $0B, $05, $F5, $92, $0B, $AF, $F5, $92, $0B, $AF, $F5, $9A, $0B, $05, $F5, 
$9A, $0B, $05, $F5, $92, $0B, $37, $F4, $92, $0B, $9D, $F4, $92, $0B, $9D, $F4, $9A, $0B, $37, $F4, $9A, $0B, $37, $F4, $92, $0B, $6B, $F3, $92, $0B, $15, $F4,
$92, $0B, $15, $F4, $9A, $0B, $6B, $F3, $9A, $0B, $6B, $F3, $92, $0B, $E3, $F2, $92, $0B, $49, $F3, $92, $0B, $49, $F3, $9A, $0B, $E3, $F2, $9A, $0B, $E3, $F2, 
$92, $0B, $6B, $F1, $92, $0B, $D1, $F1, $92, $0B, $D1, $F1, $9A, $0B, $6B, $F1, $9A, $0B, $6B, $F1, $92, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, 
$00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $14, $30, $26, $00, $00, $00, $04, $00, $00, $00, 
$2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5A, $00, $00, $00, $38, $05, $06, $00, $07, $00, $09, $00, 
$07, $00, $07, $00, $05, $00, $05, $00, $37, $F2, $9E, $0B, $37, $F2, $9B, $0B, $9D, $F2, $9B, $0B, $9D, $F2, $96, $0B, $F3, $F1, $96, $0B, $F3, $F1, $9E, $0B, 
$37, $F2, $9E, $0B, $05, $F5, $96, $0B, $AF, $F5, $96, $0B, $AF, $F5, $9E, $0B, $8D, $F5, $9E, $0B, $8D, $F5, $9B, $0B, $6B, $F5, $9B, $0B, $6B, $F5, $9E, $0B, 
$05, $F5, $9E, $0B, $05, $F5, $96, $0B, $37, $F4, $96, $0B, $9D, $F4, $96, $0B, $9D, $F4, $9B, $0B, $7B, $F4, $9B, $0B, $7B, $F4, $9E, $0B, $37, $F4, $9E, $0B, 
$37, $F4, $96, $0B, $6B, $F3, $96, $0B, $15, $F4, $96, $0B, $15, $F4, $9B, $0B, $AF, $F3, $9B, $0B, $AF, $F3, $9E, $0B, $6B, $F3, $9E, $0B, $6B, $F3, $96, $0B, 
$E3, $F2, $96, $0B, $49, $F3, $96, $0B, $49, $F3, $9E, $0B, $E3, $F2, $9E, $0B, $E3, $F2, $96, $0B, $6B, $F1, $96, $0B, $D1, $F1, $96, $0B, $D1, $F1, $9E, $0B, 
$6B, $F1, $9E, $0B, $6B, $F1, $96, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, 
$07, $00, $00, $00, $FC, $02, $00, $00, $14, $32, $27, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, 
$00, $00, $06, $01, $01, $00, $5A, $00, $00, $00, $38, $05, $06, $00, $07, $00, $09, $00, $07, $00, $07, $00, $05, $00, $05, $00, $37, $F2, $A2, $0B, $37, $F2,
$9B, $0B, $9D, $F2, $9B, $0B, $9D, $F2, $9A, $0B, $F3, $F1, $9A, $0B, $F3, $F1, $A2, $0B, $37, $F2, $A2, $0B, $05, $F5, $9A, $0B, $AF, $F5, $9A, $0B, $AF, $F5,
$A2, $0B, $8D, $F5, $A2, $0B, $8D, $F5, $9B, $0B, $6B, $F5, $9B, $0B, $6B, $F5, $A2, $0B, $05, $F5, $A2, $0B, $05, $F5, $9A, $0B, $37, $F4, $9A, $0B, $9D, $F4,
$9A, $0B, $9D, $F4, $9B, $0B, $7B, $F4, $9B, $0B, $7B, $F4, $A2, $0B, $37, $F4, $A2, $0B, $37, $F4, $9A, $0B, $6B, $F3, $9A, $0B, $15, $F4, $9A, $0B, $15, $F4,
$9B, $0B, $AF, $F3, $9B, $0B, $AF, $F3, $A2, $0B, $6B, $F3, $A2, $0B, $6B, $F3, $9A, $0B, $E3, $F2, $9A, $0B, $49, $F3, $9A, $0B, $49, $F3, $A2, $0B, $E3, $F2,
$A2, $0B, $E3, $F2, $9A, $0B, $6B, $F1, $9A, $0B, $D1, $F1, $9A, $0B, $D1, $F1, $A2, $0B, $6B, $F1, $A2, $0B, $6B, $F1, $9A, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $15, $33, $28, $00, $00, $00, 
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00,
$05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $37, $F2, $9E, $0B, $37, $F2, $A7, $0B, $F3, $F1, $A7, $0B, $F3, $F1, $9E, $0B, $37, $F2, 
$9E, $0B, $8D, $F5, $9E, $0B, $AF, $F5, $9E, $0B, $AF, $F5, $A7, $0B, $8D, $F5, $A7, $0B, $8D, $F5, $9E, $0B, $05, $F5, $9E, $0B, $6B, $F5, $9E, $0B, $6B, $F5,
$A7, $0B, $05, $F5, $A7, $0B, $05, $F5, $9E, $0B, $37, $F4, $9E, $0B, $7B, $F4, $9E, $0B, $7B, $F4, $A7, $0B, $37, $F4, $A7, $0B, $37, $F4, $9E, $0B, $6B, $F3, 
$9E, $0B, $AF, $F3, $9E, $0B, $AF, $F3, $A7, $0B, $6B, $F3, $A7, $0B, $6B, $F3, $9E, $0B, $E3, $F2, $9E, $0B, $49, $F3, $9E, $0B, $49, $F3, $A7, $0B, $E3, $F2, 
$A7, $0B, $E3, $F2, $9E, $0B, $6B, $F1, $9E, $0B, $D1, $F1, $9E, $0B, $D1, $F1, $A7, $0B, $6B, $F1, $A7, $0B, $6B, $F1, $9E, $0B, $04, $00, $00, $00, $2D, $01,
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $15, $35, $2A, $00, $00, $00,
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5D, $00, $00, $00, $38, $05, $07, $00, 
$07, $00, $05, $00, $05, $00, $07, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $AB, $0B, $9D, $F2, $A7, $0B, $37, $F2, $A7, $0B, $37, $F2, $A2, $0B, $F3, $F1,
$A2, $0B, $F3, $F1, $AB, $0B, $9D, $F2, $AB, $0B, $8D, $F5, $A2, $0B, $AF, $F5, $A2, $0B, $AF, $F5, $AB, $0B, $8D, $F5, $AB, $0B, $8D, $F5, $A2, $0B, $05, $F5,
$A2, $0B, $6B, $F5, $A2, $0B, $6B, $F5, $AB, $0B, $05, $F5, $AB, $0B, $05, $F5, $A2, $0B, $37, $F4, $A2, $0B, $7B, $F4, $A2, $0B, $7B, $F4, $A7, $0B, $E3, $F4, 
$A7, $0B, $E3, $F4, $AB, $0B, $37, $F4, $AB, $0B, $37, $F4, $A2, $0B, $6B, $F3, $A2, $0B, $AF, $F3, $A2, $0B, $AF, $F3, $A7, $0B, $15, $F4, $A7, $0B, $15, $F4, 
$AB, $0B, $6B, $F3, $AB, $0B, $6B, $F3, $A2, $0B, $E3, $F2, $A2, $0B, $49, $F3, $A2, $0B, $49, $F3, $AB, $0B, $E3, $F2, $AB, $0B, $E3, $F2, $A2, $0B, $6B, $F1, 
$A2, $0B, $D1, $F1, $A2, $0B, $D1, $F1, $AB, $0B, $6B, $F1, $AB, $0B, $6B, $F1, $A2, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $16, $37, $2B, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5D, $00, $00, $00, $38, $05, $07, $00, $07, $00, $05, $00, $05, $00, $07, $00, 
$07, $00, $05, $00, $05, $00, $9D, $F2, $AF, $0B, $9D, $F2, $A7, $0B, $37, $F2, $A7, $0B, $37, $F2, $A7, $0B, $F3, $F1, $A7, $0B, $F3, $F1, $AF, $0B, $9D, $F2, 
$AF, $0B, $8D, $F5, $A7, $0B, $AF, $F5, $A7, $0B, $AF, $F5, $AF, $0B, $8D, $F5, $AF, $0B, $8D, $F5, $A7, $0B, $05, $F5, $A7, $0B, $6B, $F5, $A7, $0B, $6B, $F5, 
$AF, $0B, $05, $F5, $AF, $0B, $05, $F5, $A7, $0B, $37, $F4, $A7, $0B, $7B, $F4, $A7, $0B, $7B, $F4, $A7, $0B, $E3, $F4, $A7, $0B, $E3, $F4, $AF, $0B, $37, $F4,
$AF, $0B, $37, $F4, $A7, $0B, $6B, $F3, $A7, $0B, $AF, $F3, $A7, $0B, $AF, $F3, $A7, $0B, $15, $F4, $A7, $0B, $15, $F4, $AF, $0B, $6B, $F3, $AF, $0B, $6B, $F3, 
$A7, $0B, $E3, $F2, $A7, $0B, $49, $F3, $A7, $0B, $49, $F3, $AF, $0B, $E3, $F2, $AF, $0B, $E3, $F2, $A7, $0B, $6B, $F1, $A7, $0B, $D1, $F1, $A7, $0B, $D1, $F1, 
$AF, $0B, $6B, $F1, $AF, $0B, $6B, $F1, $A7, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $16, $39, $2D, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2,
$AB, $0B, $9D, $F2, $B3, $0B, $F3, $F1, $B3, $0B, $F3, $F1, $AB, $0B, $9D, $F2, $AB, $0B, $8D, $F5, $AB, $0B, $AF, $F5, $AB, $0B, $AF, $F5, $B3, $0B, $8D, $F5,
$B3, $0B, $8D, $F5, $AB, $0B, $05, $F5, $AB, $0B, $6B, $F5, $AB, $0B, $6B, $F5, $B3, $0B, $05, $F5, $B3, $0B, $05, $F5, $AB, $0B, $37, $F4, $AB, $0B, $E3, $F4,
$AB, $0B, $E3, $F4, $B3, $0B, $37, $F4, $B3, $0B, $37, $F4, $AB, $0B, $6B, $F3, $AB, $0B, $15, $F4, $AB, $0B, $15, $F4, $B3, $0B, $6B, $F3, $B3, $0B, $6B, $F3,
$AB, $0B, $E3, $F2, $AB, $0B, $49, $F3, $AB, $0B, $49, $F3, $B3, $0B, $E3, $F2, $B3, $0B, $E3, $F2, $AB, $0B, $6B, $F1, $AB, $0B, $D1, $F1, $AB, $0B, $D1, $F1,
$B3, $0B, $6B, $F1, $B3, $0B, $6B, $F1, $AB, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01,
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $17, $3A, $2E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, 
$AF, $0B, $9D, $F2, $B5, $0B, $F3, $F1, $B5, $0B, $F3, $F1, $AF, $0B, $9D, $F2, $AF, $0B, $8D, $F5, $AF, $0B, $AF, $F5, $AF, $0B, $AF, $F5, $B5, $0B, $8D, $F5,
$B5, $0B, $8D, $F5, $AF, $0B, $05, $F5, $AF, $0B, $6B, $F5, $AF, $0B, $6B, $F5, $B5, $0B, $05, $F5, $B5, $0B, $05, $F5, $AF, $0B, $37, $F4, $AF, $0B, $E3, $F4, 
$AF, $0B, $E3, $F4, $B5, $0B, $37, $F4, $B5, $0B, $37, $F4, $AF, $0B, $6B, $F3, $AF, $0B, $15, $F4, $AF, $0B, $15, $F4, $B5, $0B, $6B, $F3, $B5, $0B, $6B, $F3, 
$AF, $0B, $E3, $F2, $AF, $0B, $49, $F3, $AF, $0B, $49, $F3, $B7, $0B, $E3, $F2, $B7, $0B, $E3, $F2, $AF, $0B, $6B, $F1, $AF, $0B, $D1, $F1, $AF, $0B, $D1, $F1, 
$B7, $0B, $6B, $F1, $B7, $0B, $6B, $F1, $AF, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01,
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $17, $3C, $2F, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2,
$B3, $0B, $9D, $F2, $B5, $0B, $F3, $F1, $B5, $0B, $F3, $F1, $B3, $0B, $9D, $F2, $B3, $0B, $8D, $F5, $B3, $0B, $AF, $F5, $B3, $0B, $AF, $F5, $B5, $0B, $8D, $F5,
$B5, $0B, $8D, $F5, $B3, $0B, $05, $F5, $B3, $0B, $6B, $F5, $B3, $0B, $6B, $F5, $B5, $0B, $05, $F5, $B5, $0B, $05, $F5, $B3, $0B, $37, $F4, $B3, $0B, $E3, $F4,
$B3, $0B, $E3, $F4, $B5, $0B, $37, $F4, $B5, $0B, $37, $F4, $B3, $0B, $6B, $F3, $B3, $0B, $15, $F4, $B3, $0B, $15, $F4, $B5, $0B, $6B, $F3, $B5, $0B, $6B, $F3,
$B3, $0B, $E3, $F2, $B3, $0B, $49, $F3, $B3, $0B, $49, $F3, $BC, $0B, $E3, $F2, $BC, $0B, $E3, $F2, $B3, $0B, $6B, $F1, $B3, $0B, $D1, $F1, $B3, $0B, $D1, $F1, 
$BC, $0B, $6B, $F1, $BC, $0B, $6B, $F1, $B3, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $18, $3E, $31, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00, $05, $00, $05, $00, $E3, $F2, $B7, $0B, $49, $F3, $B7, $0B, $49, $F3, $C0, $0B,
$E3, $F2, $C0, $0B, $E3, $F2, $B7, $0B, $6B, $F1, $B7, $0B, $D1, $F1, $B7, $0B, $D1, $F1, $C0, $0B, $6B, $F1, $C0, $0B, $6B, $F1, $B7, $0B, $04, $00, $00, $00, 
$2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $18, $40, $32, $00, 
$00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $2C, $00, $00, $00, $38, $05, 
$02, $00, $0A, $00, $09, $00, $E3, $F2, $BC, $0B, $49, $F3, $BC, $0B, $49, $F3, $C1, $0B, $AF, $F3, $C1, $0B, $AF, $F5, $C1, $0B, $AF, $F5, $C4, $0B, $BF, $F2, 
$C4, $0B, $BF, $F2, $C1, $0B, $E3, $F2, $C1, $0B, $E3, $F2, $BC, $0B, $6B, $F1, $BC, $0B, $D1, $F1, $BC, $0B, $D1, $F1, $C1, $0B, $9D, $F2, $C1, $0B, $9D, $F2, 
$C4, $0B, $49, $F1, $C4, $0B, $49, $F1, $C1, $0B, $6B, $F1, $C1, $0B, $6B, $F1, $BC, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $19, $41, $33, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, 
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $2C, $00, $00, $00, $38, $05, $02, $00, $0A, $00, $09, $00, $E3, $F2, $C0, $0B, 
$49, $F3, $C0, $0B, $49, $F3, $C1, $0B, $AF, $F3, $C1, $0B, $AF, $F5, $C1, $0B, $AF, $F5, $C8, $0B, $BF, $F2, $C8, $0B, $BF, $F2, $C1, $0B, $E3, $F2, $C1, $0B, 
$E3, $F2, $C0, $0B, $6B, $F1, $C0, $0B, $D1, $F1, $C0, $0B, $D1, $F1, $C1, $0B, $9D, $F2, $C1, $0B, $9D, $F2, $C8, $0B, $49, $F1, $C8, $0B, $49, $F1, $C1, $0B, 
$6B, $F1, $C1, $0B, $6B, $F1, $C0, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00,
$07, $00, $00, $00, $FC, $02, $00, $00, $19, $43, $35, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00,
$00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00, $05, $00, $05, $00, $BF, $F2, $C4, $0B, $AF, $F5, $C4, $0B, $AF, $F5, $CC, $0B, $BF, $F2,
$CC, $0B, $BF, $F2, $C4, $0B, $49, $F1, $C4, $0B, $9D, $F2, $C4, $0B, $9D, $F2, $CC, $0B, $49, $F1, $CC, $0B, $49, $F1, $C4, $0B, $04, $00, $00, $00, $2D, $01,
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1A, $45, $36, $00, $00, $00,
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00,
$05, $00, $05, $00, $BF, $F2, $C8, $0B, $AF, $F5, $C8, $0B, $AF, $F5, $D1, $0B, $BF, $F2, $D1, $0B, $BF, $F2, $C8, $0B, $49, $F1, $C8, $0B, $9D, $F2, $C8, $0B,
$9D, $F2, $D1, $0B, $49, $F1, $D1, $0B, $49, $F1, $C8, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00,
$F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1B, $47, $38, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, 
$01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00, $05, $00, $05, $00, $BF, $F2, $CC, $0B, $AF, $F5, $CC, $0B, $AF, $F5, 
$D5, $0B, $BF, $F2, $D5, $0B, $BF, $F2, $CC, $0B, $49, $F1, $CC, $0B, $9D, $F2, $CC, $0B, $9D, $F2, $D5, $0B, $49, $F1, $D5, $0B, $49, $F1, $CC, $0B, $04, $00,
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $1B, $47, 
$38, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, 
$38, $05, $02, $00, $05, $00, $05, $00, $BF, $F2, $D1, $0B, $AF, $F5, $D1, $0B, $AF, $F5, $D9, $0B, $BF, $F2, $D9, $0B, $BF, $F2, $D1, $0B, $49, $F1, $D1, $0B,
$9D, $F2, $D1, $0B, $9D, $F2, $D9, $0B, $49, $F1, $D9, $0B, $49, $F1, $D1, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, 
$04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01,
$04, $00, $12, $00, $00, $00, $25, $03, $07, $00, $96, $F4, $50, $0B, $81, $F4, $50, $0B, $6C, $F4, $43, $0B, $81, $F4, $43, $0B, $81, $F4, $43, $0B, $96, $F4,
$35, $0B, $6C, $F4, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, 
$00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $08, $00, $00, $00, $25, $03, $02, $00, $42, $F4, $50, $0B, $42, $F4, $35, $0B, 
$04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, 
$22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $08, $00, $00, $00, $25, $03, $02, $00, $AF, $F3, $43, $0B, $C4, $F3, $43, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, 
$2D, $01, $04, $00, $08, $00, $00, $00, $25, $03, $02, $00, $2D, $F4, $50, $0B, $57, $F4, $50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00,
$F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0E, $00, 
$00, $00, $25, $03, $05, $00, $F2, $F2, $35, $0B, $F2, $F2, $50, $0B, $07, $F3, $50, $0B, $1C, $F3, $43, $0B, $F2, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, 
$2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $C8, $F2, $50, $0B, $DD, $F2, $43, $0B, $DD, $F2, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, 
$04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $03, $F4, $50, $0B, $18, $F4, $43, $0B, $18, $F4, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, 
$00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, 
$0A, $00, $00, $00, $25, $03, $03, $00, $EE, $F3, $35, $0B, $EE, $F3, $50, $0B, $03, $F4, $50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, 
$F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00,
$00, $00, $25, $03, $03, $00, $85, $F3, $50, $0B, $9A, $F3, $43, $0B, $9A, $F3, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01,
$04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00,
$25, $03, $03, $00, $70, $F3, $35, $0B, $70, $F3, $50, $0B, $85, $F3, $50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00,
$09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0C, $00, $00, $00, $25, $03,
$04, $00, $B3, $F2, $35, $0B, $B3, $F2, $50, $0B, $C8, $F2, $50, $0B, $C8, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $10, $00, $00, $00, 
$25, $03, $06, $00, $31, $F3, $43, $0B, $31, $F3, $35, $0B, $5B, $F3, $35, $0B, $5B, $F3, $50, $0B, $46, $F3, $50, $0B, $31, $F3, $43, $0B, $04, $00, $00, $00,
$2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00,
$00, $00, $2D, $01, $04, $00, $10, $00, $00, $00, $25, $03, $06, $00, $74, $F2, $43, $0B, $74, $F2, $35, $0B, $9E, $F2, $35, $0B, $9E, $F2, $50, $0B, $89, $F2, 
$50, $0B, $74, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, 
$00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0E, $00, $00, $00, $25, $03, $05, $00, $D9, $F3, $50, $0B, $C4, $F3, $50, $0B, 
$AF, $F3, $43, $0B, $AF, $F3, $35, $0B, $D9, $F3, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00,
$FA, $02, $00, $00, $00, $00, $00, $00, $00, $26, $14, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0E, $00, $00, $00, $25, $03, $05, $00, $5F, $F2,
$50, $0B, $4A, $F2, $50, $0B, $35, $F2, $43, $0B, $35, $F2, $35, $0B, $5F, $F2, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $03, $00, $00, $00, $00, $00);

FixedMeta_Data2: TFixedMeta_Data2 = 
($7A, $24, $00, $00, $D7, $CD, $C6, $9A, $00, $00, $00, $00, $00, $00, $A8, $AA, $C8, $74, $E8, $03, $00, $00, $00, $00, $99, $8A, $01, $00, $09, $00, $00, $03,
$30, $12, $00, $00, $05, $00, $5E, $00, $00, $00, $00, $00, $05, $00, $00, $00, $0B, $02, $28, $0E, $1A, $F0, $05, $00, $00, $00, $0C, $02, $67, $FB, $B8, $06, 
$04, $00, $00, $00, $06, $01, $01, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $00, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $00, $00, $09, $00, 
$00, $00, $FA, $02, $05, $00, $00, $00, $00, $00, $FF, $FF, $FF, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00,
$0E, $00, $00, $00, $24, $03, $05, $00, $1A, $F0, $28, $0E, $D2, $F6, $28, $0E, $D2, $F6, $8F, $09, $1A, $F0, $8F, $09, $1A, $F0, $28, $0E, $09, $00, $00, $00, 
$FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $02, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $FF, $FF, 
$FF, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $7C, $00, $00, $00, $04, $00, $00, $00, $2D, $01, 
$04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $0C, $00, $00, $00, $24, $03, $04, $00, $09, $F3, $D9, $0B, $AF, $F5, 
$CE, $0B, $AF, $F5, $D9, $0B, $09, $F3, $D9, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $7C, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00, $06, $00, $04, $00, $AF, $F5, $CE, $0B, $09, $F3, $D9, $0B, $BF, $F2, $D9, $0B, 
$BF, $F2, $D7, $0B, $AF, $F5, $CA, $0B, $AF, $F5, $CE, $0B, $23, $F2, $D9, $0B, $9D, $F2, $D7, $0B, $9D, $F2, $D9, $0B, $23, $F2, $D9, $0B, $04, $00, $00, $00, 
$2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $7B, $00, 
$00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1A, $00, $00, $00, $38, $05,
$02, $00, $05, $00, $05, $00, $9D, $F2, $D9, $0B, $96, $F2, $D9, $0B, $77, $F1, $D9, $0B, $9D, $F2, $D4, $0B, $9D, $F2, $D9, $0B, $AF, $F5, $CC, $0B, $BF, $F2,
$D9, $0B, $BF, $F2, $D4, $0B, $AF, $F5, $C7, $0B, $AF, $F5, $CC, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00,
$00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $79, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00,
$2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1C, $00, $00, $00, $38, $05, $02, $00, $06, $00, $05, $00, $9D, $F2, $D7, $0B, $23, $F2, $D9, $0B,
$49, $F1, $D9, $0B, $49, $F1, $D8, $0B, $9D, $F2, $D2, $0B, $9D, $F2, $D7, $0B, $AF, $F5, $CA, $0B, $BF, $F2, $D7, $0B, $BF, $F2, $D2, $0B, $AF, $F5, $C5, $0B, 
$AF, $F5, $CA, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00,
$FC, $02, $00, $00, $00, $00, $78, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01,
$01, $00, $1C, $00, $00, $00, $38, $05, $02, $00, $06, $00, $05, $00, $9D, $F2, $D4, $0B, $77, $F1, $D9, $0B, $49, $F1, $D9, $0B, $49, $F1, $D5, $0B, $9D, $F2, 
$CF, $0B, $9D, $F2, $D4, $0B, $AF, $F5, $C7, $0B, $BF, $F2, $D4, $0B, $BF, $F2, $CF, $0B, $AF, $F5, $C2, $0B, $AF, $F5, $C7, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $76, $00, $00, $00,
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1C, $00, $00, $00, $38, $05, $02, $00,
$05, $00, $06, $00, $9D, $F2, $D2, $0B, $49, $F1, $D8, $0B, $49, $F1, $D3, $0B, $9D, $F2, $CD, $0B, $9D, $F2, $D2, $0B, $AF, $F5, $C5, $0B, $BF, $F2, $D2, $0B, 
$BF, $F2, $CD, $0B, $47, $F5, $C1, $0B, $AF, $F5, $C1, $0B, $AF, $F5, $C5, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00,
$04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $75, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, 
$00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1C, $00, $00, $00, $38, $05, $02, $00, $05, $00, $06, $00, $9D, $F2, $CF, $0B, $49, $F1,
$D5, $0B, $49, $F1, $D0, $0B, $9D, $F2, $CA, $0B, $9D, $F2, $CF, $0B, $AF, $F5, $C2, $0B, $BF, $F2, $CF, $0B, $BF, $F2, $CA, $0B, $9B, $F4, $C1, $0B, $AF, $F5,
$C1, $0B, $AF, $F5, $C2, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, 
$00, $00, $FC, $02, $00, $00, $00, $00, $73, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, 
$06, $01, $01, $00, $1A, $00, $00, $00, $38, $05, $02, $00, $05, $00, $05, $00, $9D, $F2, $CD, $0B, $49, $F1, $D3, $0B, $49, $F1, $CE, $0B, $9D, $F2, $C8, $0B, 
$9D, $F2, $CD, $0B, $47, $F5, $C1, $0B, $BF, $F2, $CD, $0B, $BF, $F2, $C8, $0B, $28, $F4, $C1, $0B, $47, $F5, $C1, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $71, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1C, $00, $00, $00, $38, $05, $02, $00, $05, $00, 
$06, $00, $9D, $F2, $CA, $0B, $49, $F1, $D0, $0B, $49, $F1, $CB, $0B, $9D, $F2, $C5, $0B, $9D, $F2, $CA, $0B, $9B, $F4, $C1, $0B, $BF, $F2, $CA, $0B, $BF, $F2,
$C5, $0B, $7B, $F3, $C1, $0B, $AF, $F3, $C1, $0B, $9B, $F4, $C1, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, 
$00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $70, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, 
$2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $1E, $00, $00, $00, $38, $05, $02, $00, $05, $00, $07, $00, $9D, $F2, $C8, $0B, $49, $F1, $CE, $0B, 
$49, $F1, $C9, $0B, $9D, $F2, $C3, $0B, $9D, $F2, $C8, $0B, $28, $F4, $C1, $0B, $BF, $F2, $C8, $0B, $BF, $F2, $C3, $0B, $49, $F3, $C0, $0B, $49, $F3, $C1, $0B,
$AF, $F3, $C1, $0B, $28, $F4, $C1, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, 
$07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $6E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, 
$00, $00, $06, $01, $01, $00, $36, $00, $00, $00, $38, $05, $04, $00, $06, $00, $08, $00, $05, $00, $04, $00, $9D, $F2, $C5, $0B, $49, $F1, $CB, $0B, $49, $F1, 
$C7, $0B, $96, $F2, $C1, $0B, $9D, $F2, $C1, $0B, $9D, $F2, $C5, $0B, $7B, $F3, $C1, $0B, $BF, $F2, $C5, $0B, $BF, $F2, $C1, $0B, $E3, $F2, $C1, $0B, $E3, $F2,
$C0, $0B, $49, $F3, $BE, $0B, $49, $F3, $C1, $0B, $7B, $F3, $C1, $0B, $8D, $F5, $B4, $0B, $AF, $F5, $B4, $0B, $AF, $F5, $B5, $0B, $8D, $F5, $B5, $0B, $8D, $F5,
$B4, $0B, $47, $F5, $B5, $0B, $6B, $F5, $B5, $0B, $6B, $F5, $B5, $0B, $47, $F5, $B5, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01,
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $6D, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $3F, $00, $00, $00, $38, $05, $05, $00, $06, $00, $07, $00, $05, $00, $05, $00,
$04, $00, $9D, $F2, $C3, $0B, $49, $F1, $C9, $0B, $49, $F1, $C4, $0B, $EA, $F1, $C1, $0B, $9D, $F2, $C1, $0B, $9D, $F2, $C3, $0B, $49, $F3, $C0, $0B, $BF, $F2, 
$C3, $0B, $BF, $F2, $C1, $0B, $E3, $F2, $C1, $0B, $E3, $F2, $BD, $0B, $49, $F3, $BB, $0B, $49, $F3, $C0, $0B, $8D, $F5, $B1, $0B, $AF, $F5, $B1, $0B, $AF, $F5, 
$B5, $0B, $8D, $F5, $B5, $0B, $8D, $F5, $B1, $0B, $05, $F5, $B4, $0B, $6B, $F5, $B2, $0B, $6B, $F5, $B5, $0B, $05, $F5, $B5, $0B, $05, $F5, $B4, $0B, $9B, $F4,
$B5, $0B, $E3, $F4, $B4, $0B, $E3, $F4, $B5, $0B, $9B, $F4, $B5, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, 
$00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $6B, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, 
$2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $3F, $00, $00, $00, $38, $05, $05, $00, $06, $00, $05, $00, $06, $00, $05, $00, $05, $00, $96, $F2, 
$C1, $0B, $49, $F1, $C7, $0B, $49, $F1, $C2, $0B, $D1, $F1, $C0, $0B, $D1, $F1, $C1, $0B, $96, $F2, $C1, $0B, $49, $F3, $BE, $0B, $E3, $F2, $C0, $0B, $E3, $F2, 
$BB, $0B, $49, $F3, $B9, $0B, $49, $F3, $BE, $0B, $6B, $F5, $B5, $0B, $47, $F5, $B5, $0B, $05, $F5, $B5, $0B, $05, $F5, $B2, $0B, $6B, $F5, $B0, $0B, $6B, $F5,
$B5, $0B, $AF, $F5, $B4, $0B, $8D, $F5, $B4, $0B, $8D, $F5, $AF, $0B, $AF, $F5, $AF, $0B, $AF, $F5, $B4, $0B, $37, $F4, $B5, $0B, $E3, $F4, $B2, $0B, $E3, $F4,
$B5, $0B, $37, $F4, $B5, $0B, $37, $F4, $B5, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $69, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00,
$04, $00, $00, $00, $06, $01, $01, $00, $4C, $00, $00, $00, $38, $05, $06, $00, $08, $00, $05, $00, $06, $00, $05, $00, $05, $00, $04, $00, $EA, $F1, $C1, $0B,
$49, $F1, $C4, $0B, $49, $F1, $C1, $0B, $6B, $F1, $C1, $0B, $6B, $F1, $BF, $0B, $D1, $F1, $BD, $0B, $D1, $F1, $C1, $0B, $EA, $F1, $C1, $0B, $49, $F3, $BB, $0B,
$E3, $F2, $BD, $0B, $E3, $F2, $B8, $0B, $49, $F3, $B6, $0B, $49, $F3, $BB, $0B, $E3, $F4, $B4, $0B, $9B, $F4, $B5, $0B, $37, $F4, $B5, $0B, $37, $F4, $B2, $0B, 
$E3, $F4, $AF, $0B, $E3, $F4, $B4, $0B, $6B, $F5, $B2, $0B, $05, $F5, $B4, $0B, $05, $F5, $AF, $0B, $6B, $F5, $AD, $0B, $6B, $F5, $B2, $0B, $AF, $F5, $B1, $0B, 
$8D, $F5, $B1, $0B, $8D, $F5, $AC, $0B, $AF, $F5, $AC, $0B, $AF, $F5, $B1, $0B, $7B, $F3, $B5, $0B, $15, $F4, $B3, $0B, $15, $F4, $B5, $0B, $7B, $F3, $B5, $0B, 
$04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, 
$00, $00, $68, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $4A, $00,
$00, $00, $38, $05, $06, $00, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $D1, $F1, $C0, $0B, $49, $F1, $C2, $0B, $49, $F1, $C1, $0B, $6B, $F1, 
$C1, $0B, $6B, $F1, $BD, $0B, $D1, $F1, $BB, $0B, $D1, $F1, $C0, $0B, $49, $F3, $B9, $0B, $E3, $F2, $BB, $0B, $E3, $F2, $B6, $0B, $49, $F3, $B4, $0B, $49, $F3, 
$B9, $0B, $E3, $F4, $B2, $0B, $37, $F4, $B5, $0B, $37, $F4, $B0, $0B, $E3, $F4, $AD, $0B, $E3, $F4, $B2, $0B, $6B, $F5, $B0, $0B, $05, $F5, $B2, $0B, $05, $F5, 
$AD, $0B, $6B, $F5, $AB, $0B, $6B, $F5, $B0, $0B, $AF, $F5, $AF, $0B, $8D, $F5, $AF, $0B, $8D, $F5, $AA, $0B, $AF, $F5, $AA, $0B, $AF, $F5, $AF, $0B, $6B, $F3, 
$B4, $0B, $15, $F4, $B1, $0B, $15, $F4, $B5, $0B, $6B, $F3, $B5, $0B, $6B, $F3, $B4, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $66, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, 
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $04, $00, $05, $00, $05, $00, $06, $00, 
$05, $00, $05, $00, $05, $00, $9D, $F2, $B4, $0B, $9D, $F2, $B5, $0B, $5D, $F2, $B5, $0B, $9D, $F2, $B4, $0B, $D1, $F1, $BD, $0B, $6B, $F1, $BF, $0B, $6B, $F1, 
$BA, $0B, $D1, $F1, $B8, $0B, $D1, $F1, $BD, $0B, $49, $F3, $B6, $0B, $E3, $F2, $B8, $0B, $E3, $F2, $B3, $0B, $49, $F3, $B1, $0B, $49, $F3, $B6, $0B, $15, $F4,
$B3, $0B, $7B, $F3, $B5, $0B, $6B, $F3, $B5, $0B, $6B, $F3, $B1, $0B, $15, $F4, $AE, $0B, $15, $F4, $B3, $0B, $E3, $F4, $AF, $0B, $37, $F4, $B2, $0B, $37, $F4,
$AD, $0B, $E3, $F4, $AA, $0B, $E3, $F4, $AF, $0B, $6B, $F5, $AD, $0B, $05, $F5, $AF, $0B, $05, $F5, $AA, $0B, $6B, $F5, $A8, $0B, $6B, $F5, $AD, $0B, $AF, $F5,
$AC, $0B, $8D, $F5, $AC, $0B, $8D, $F5, $A7, $0B, $AF, $F5, $A7, $0B, $AF, $F5, $AC, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01,
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $65, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, 
$05, $00, $05, $00, $05, $00, $9D, $F2, $B2, $0B, $9D, $F2, $B5, $0B, $F3, $F1, $B5, $0B, $F3, $F1, $B5, $0B, $9D, $F2, $B2, $0B, $D1, $F1, $BB, $0B, $6B, $F1, 
$BD, $0B, $6B, $F1, $B8, $0B, $D1, $F1, $B6, $0B, $D1, $F1, $BB, $0B, $49, $F3, $B4, $0B, $E3, $F2, $B6, $0B, $E3, $F2, $B1, $0B, $49, $F3, $AF, $0B, $49, $F3,
$B4, $0B, $15, $F4, $B1, $0B, $6B, $F3, $B4, $0B, $6B, $F3, $AF, $0B, $15, $F4, $AC, $0B, $15, $F4, $B1, $0B, $E3, $F4, $AD, $0B, $37, $F4, $B0, $0B, $37, $F4, 
$AB, $0B, $E3, $F4, $A8, $0B, $E3, $F4, $AD, $0B, $6B, $F5, $AB, $0B, $05, $F5, $AD, $0B, $05, $F5, $A8, $0B, $6B, $F5, $A6, $0B, $6B, $F5, $AB, $0B, $AF, $F5, 
$AA, $0B, $8D, $F5, $AA, $0B, $8D, $F5, $A5, $0B, $AF, $F5, $A5, $0B, $AF, $F5, $AA, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $63, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, 
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $57, $00, $00, $00, $38, $05, $07, $00, $06, $00, $05, $00, $05, $00, $05, $00,
$07, $00, $05, $00, $05, $00, $9D, $F2, $AF, $0B, $9D, $F2, $B4, $0B, $5D, $F2, $B5, $0B, $F3, $F1, $B5, $0B, $F3, $F1, $B2, $0B, $9D, $F2, $AF, $0B, $D1, $F1,
$B8, $0B, $6B, $F1, $BA, $0B, $6B, $F1, $B5, $0B, $D1, $F1, $B3, $0B, $D1, $F1, $B8, $0B, $49, $F3, $B1, $0B, $E3, $F2, $B3, $0B, $E3, $F2, $AE, $0B, $49, $F3,
$AC, $0B, $49, $F3, $B1, $0B, $15, $F4, $AE, $0B, $6B, $F3, $B1, $0B, $6B, $F3, $AC, $0B, $15, $F4, $A9, $0B, $15, $F4, $AE, $0B, $E3, $F4, $AA, $0B, $37, $F4,
$AD, $0B, $37, $F4, $A8, $0B, $7B, $F4, $A7, $0B, $7B, $F4, $A7, $0B, $E3, $F4, $A7, $0B, $E3, $F4, $AA, $0B, $6B, $F5, $A8, $0B, $05, $F5, $AA, $0B, $05, $F5,
$A5, $0B, $6B, $F5, $A3, $0B, $6B, $F5, $A8, $0B, $AF, $F5, $A7, $0B, $8D, $F5, $A7, $0B, $8D, $F5, $A2, $0B, $AF, $F5, $A2, $0B, $AF, $F5, $A7, $0B, $04, $00, 
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, 
$61, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $57, $00, $00, $00, 
$38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $06, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $AD, $0B, $9D, $F2, $B2, $0B, $F3, $F1, $B5, $0B, $F3, $F1, 
$B0, $0B, $9D, $F2, $AD, $0B, $D1, $F1, $B6, $0B, $6B, $F1, $B8, $0B, $6B, $F1, $B3, $0B, $D1, $F1, $B1, $0B, $D1, $F1, $B6, $0B, $49, $F3, $AF, $0B, $E3, $F2, 
$B1, $0B, $E3, $F2, $AC, $0B, $49, $F3, $AA, $0B, $49, $F3, $AF, $0B, $15, $F4, $AC, $0B, $6B, $F3, $AF, $0B, $6B, $F3, $AA, $0B, $EE, $F3, $A7, $0B, $15, $F4, 
$A7, $0B, $15, $F4, $AC, $0B, $E3, $F4, $A8, $0B, $37, $F4, $AB, $0B, $37, $F4, $A6, $0B, $7B, $F4, $A5, $0B, $7B, $F4, $A7, $0B, $E3, $F4, $A7, $0B, $E3, $F4, 
$A8, $0B, $6B, $F5, $A6, $0B, $05, $F5, $A8, $0B, $05, $F5, $A3, $0B, $6B, $F5, $A1, $0B, $6B, $F5, $A6, $0B, $AF, $F5, $A5, $0B, $8D, $F5, $A5, $0B, $8D, $F5,
$A0, $0B, $AF, $F5, $A0, $0B, $AF, $F5, $A5, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, 
$04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $60, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, 
$04, $00, $00, $00, $06, $01, $01, $00, $55, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, 
$AA, $0B, $9D, $F2, $AF, $0B, $F3, $F1, $B2, $0B, $F3, $F1, $AD, $0B, $9D, $F2, $AA, $0B, $D1, $F1, $B3, $0B, $6B, $F1, $B5, $0B, $6B, $F1, $B0, $0B, $D1, $F1,
$AE, $0B, $D1, $F1, $B3, $0B, $49, $F3, $AC, $0B, $E3, $F2, $AE, $0B, $E3, $F2, $A9, $0B, $49, $F3, $A7, $0B, $49, $F3, $AC, $0B, $15, $F4, $A9, $0B, $6B, $F3, 
$AC, $0B, $6B, $F3, $A7, $0B, $AF, $F3, $A6, $0B, $AF, $F3, $A7, $0B, $15, $F4, $A7, $0B, $15, $F4, $A9, $0B, $7B, $F4, $A7, $0B, $37, $F4, $A8, $0B, $37, $F4, 
$A3, $0B, $7B, $F4, $A2, $0B, $7B, $F4, $A7, $0B, $6B, $F5, $A3, $0B, $05, $F5, $A5, $0B, $05, $F5, $A0, $0B, $6B, $F5, $9E, $0B, $6B, $F5, $A3, $0B, $AF, $F5,
$A2, $0B, $8D, $F5, $A2, $0B, $8D, $F5, $9D, $0B, $AF, $F5, $9D, $0B, $AF, $F5, $A2, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01,
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $5E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $55, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $06, $00,
$05, $00, $05, $00, $06, $00, $9D, $F2, $A8, $0B, $9D, $F2, $AD, $0B, $F3, $F1, $B0, $0B, $F3, $F1, $AB, $0B, $9D, $F2, $A8, $0B, $D1, $F1, $B1, $0B, $6B, $F1,
$B3, $0B, $6B, $F1, $AE, $0B, $D1, $F1, $AC, $0B, $D1, $F1, $B1, $0B, $49, $F3, $AA, $0B, $E3, $F2, $AC, $0B, $E3, $F2, $A7, $0B, $49, $F3, $A5, $0B, $49, $F3, 
$AA, $0B, $EE, $F3, $A7, $0B, $6B, $F3, $AA, $0B, $6B, $F3, $A5, $0B, $AF, $F3, $A4, $0B, $AF, $F3, $A7, $0B, $EE, $F3, $A7, $0B, $7B, $F4, $A5, $0B, $37, $F4, 
$A6, $0B, $37, $F4, $A1, $0B, $7B, $F4, $A0, $0B, $7B, $F4, $A5, $0B, $6B, $F5, $A1, $0B, $05, $F5, $A3, $0B, $05, $F5, $9E, $0B, $6B, $F5, $9C, $0B, $6B, $F5,
$A1, $0B, $AF, $F5, $A0, $0B, $8D, $F5, $A0, $0B, $8D, $F5, $9B, $0B, $7F, $F5, $9B, $0B, $AF, $F5, $9B, $0B, $AF, $F5, $A0, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $5D, $00, $00, $00, 
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $50, $00, $00, $00, $38, $05, $06, $00, 
$06, $00, $05, $00, $05, $00, $05, $00, $05, $00, $09, $00, $9D, $F2, $AA, $0B, $9D, $F2, $A7, $0B, $5C, $F2, $A7, $0B, $F3, $F1, $A9, $0B, $F3, $F1, $AD, $0B, 
$9D, $F2, $AA, $0B, $D1, $F1, $AE, $0B, $6B, $F1, $B0, $0B, $6B, $F1, $AC, $0B, $D1, $F1, $AA, $0B, $D1, $F1, $AE, $0B, $49, $F3, $A7, $0B, $E3, $F2, $A9, $0B, 
$E3, $F2, $A5, $0B, $49, $F3, $A3, $0B, $49, $F3, $A7, $0B, $AF, $F3, $A6, $0B, $6B, $F3, $A7, $0B, $6B, $F3, $A3, $0B, $AF, $F3, $A2, $0B, $AF, $F3, $A6, $0B,
$7B, $F4, $A2, $0B, $37, $F4, $A3, $0B, $37, $F4, $9F, $0B, $7B, $F4, $9E, $0B, $7B, $F4, $A2, $0B, $6B, $F5, $9E, $0B, $05, $F5, $A0, $0B, $05, $F5, $9C, $0B,
$AF, $F5, $99, $0B, $AF, $F5, $9D, $0B, $8D, $F5, $9D, $0B, $8D, $F5, $9B, $0B, $6B, $F5, $9B, $0B, $6B, $F5, $9E, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $5B, $00, $00, $00, $04, $00,
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $54, $00, $00, $00, $38, $05, $06, $00, $07, $00, 
$05, $00, $05, $00, $05, $00, $07, $00, $08, $00, $9D, $F2, $A8, $0B, $9D, $F2, $A7, $0B, $37, $F2, $A7, $0B, $37, $F2, $A5, $0B, $F3, $F1, $A6, $0B, $F3, $F1,
$AB, $0B, $9D, $F2, $A8, $0B, $D1, $F1, $AC, $0B, $6B, $F1, $AE, $0B, $6B, $F1, $A9, $0B, $D1, $F1, $A7, $0B, $D1, $F1, $AC, $0B, $49, $F3, $A5, $0B, $E3, $F2, 
$A7, $0B, $E3, $F2, $A2, $0B, $49, $F3, $A0, $0B, $49, $F3, $A5, $0B, $AF, $F3, $A4, $0B, $6B, $F3, $A5, $0B, $6B, $F3, $A0, $0B, $AF, $F3, $9F, $0B, $AF, $F3, 
$A4, $0B, $7B, $F4, $A0, $0B, $37, $F4, $A1, $0B, $37, $F4, $9C, $0B, $9D, $F4, $9A, $0B, $9D, $F4, $9B, $0B, $7B, $F4, $9B, $0B, $7B, $F4, $A0, $0B, $6B, $F5, 
$9C, $0B, $05, $F5, $9E, $0B, $05, $F5, $99, $0B, $AF, $F5, $96, $0B, $AF, $F5, $9B, $0B, $7F, $F5, $9B, $0B, $6B, $F5, $9B, $0B, $6B, $F5, $9C, $0B, $04, $00, 
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00,
$5A, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $55, $00, $00, $00, 
$38, $05, $07, $00, $06, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $04, $00, $5C, $F2, $A7, $0B, $37, $F2, $A7, $0B, $37, $F2, $A3, $0B, $F3, $F1, 
$A4, $0B, $F3, $F1, $A9, $0B, $5C, $F2, $A7, $0B, $D1, $F1, $AA, $0B, $6B, $F1, $AC, $0B, $6B, $F1, $A7, $0B, $D1, $F1, $A5, $0B, $D1, $F1, $AA, $0B, $49, $F3,
$A3, $0B, $E3, $F2, $A5, $0B, $E3, $F2, $A0, $0B, $49, $F3, $9E, $0B, $49, $F3, $A3, $0B, $AF, $F3, $A2, $0B, $6B, $F3, $A3, $0B, $6B, $F3, $9E, $0B, $AF, $F3, 
$9D, $0B, $AF, $F3, $A2, $0B, $7B, $F4, $9E, $0B, $37, $F4, $9F, $0B, $37, $F4, $9A, $0B, $9D, $F4, $98, $0B, $9D, $F4, $9B, $0B, $7B, $F4, $9B, $0B, $7B, $F4, 
$9E, $0B, $AF, $F5, $99, $0B, $05, $F5, $9C, $0B, $05, $F5, $97, $0B, $AF, $F5, $94, $0B, $AF, $F5, $99, $0B, $ED, $F3, $9B, $0B, $15, $F4, $9B, $0B, $15, $F4, 
$9B, $0B, $ED, $F3, $9B, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, 
$00, $00, $FC, $02, $00, $00, $00, $00, $58, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00,
$06, $01, $01, $00, $4A, $00, $00, $00, $38, $05, $06, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $05, $00, $37, $F2, $A0, $0B, $37, $F2, $A5, $0B,
$F3, $F1, $A6, $0B, $F3, $F1, $A1, $0B, $37, $F2, $A0, $0B, $D1, $F1, $A7, $0B, $6B, $F1, $A9, $0B, $6B, $F1, $A4, $0B, $D1, $F1, $A2, $0B, $D1, $F1, $A7, $0B,
$49, $F3, $A0, $0B, $E3, $F2, $A2, $0B, $E3, $F2, $9D, $0B, $49, $F3, $9B, $0B, $49, $F3, $A0, $0B, $AF, $F3, $9F, $0B, $6B, $F3, $A0, $0B, $6B, $F3, $9B, $0B,
$15, $F4, $98, $0B, $15, $F4, $9B, $0B, $AF, $F3, $9B, $0B, $AF, $F3, $9F, $0B, $9D, $F4, $9A, $0B, $37, $F4, $9C, $0B, $37, $F4, $97, $0B, $9D, $F4, $95, $0B,
$9D, $F4, $9A, $0B, $AF, $F5, $96, $0B, $05, $F5, $99, $0B, $05, $F5, $94, $0B, $AF, $F5, $91, $0B, $AF, $F5, $96, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $56, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $52, $00, $00, $00, $38, $05, $06, $00, $05, $00,
$05, $00, $05, $00, $08, $00, $05, $00, $08, $00, $37, $F2, $9E, $0B, $37, $F2, $A3, $0B, $F3, $F1, $A4, $0B, $F3, $F1, $9F, $0B, $37, $F2, $9E, $0B, $D1, $F1,
$A5, $0B, $6B, $F1, $A7, $0B, $6B, $F1, $A2, $0B, $D1, $F1, $A0, $0B, $D1, $F1, $A5, $0B, $49, $F3, $9E, $0B, $E3, $F2, $A0, $0B, $E3, $F2, $9B, $0B, $49, $F3, 
$99, $0B, $49, $F3, $9E, $0B, $AF, $F3, $9D, $0B, $6B, $F3, $9E, $0B, $6B, $F3, $99, $0B, $15, $F4, $96, $0B, $15, $F4, $9B, $0B, $ED, $F3, $9B, $0B, $AF, $F3, 
$9B, $0B, $AF, $F3, $9D, $0B, $9D, $F4, $98, $0B, $37, $F4, $9A, $0B, $37, $F4, $95, $0B, $9D, $F4, $93, $0B, $9D, $F4, $98, $0B, $AF, $F5, $94, $0B, $05, $F5, 
$97, $0B, $05, $F5, $92, $0B, $7F, $F5, $8F, $0B, $8D, $F5, $8F, $0B, $8D, $F5, $8F, $0B, $AF, $F5, $8F, $0B, $AF, $F5, $94, $0B, $04, $00, $00, $00, $2D, $01, 
$02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $55, $00, $00, $00,
$04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $52, $00, $00, $00, $38, $05, $06, $00, 
$07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $09, $00, $37, $F2, $A0, $0B, $37, $F2, $9B, $0B, $9D, $F2, $9B, $0B, $9D, $F2, $99, $0B, $F3, $F1, $9C, $0B,
$F3, $F1, $A1, $0B, $37, $F2, $A0, $0B, $D1, $F1, $A2, $0B, $6B, $F1, $A4, $0B, $6B, $F1, $9F, $0B, $D1, $F1, $9D, $0B, $D1, $F1, $A2, $0B, $49, $F3, $9B, $0B,
$E3, $F2, $9D, $0B, $E3, $F2, $98, $0B, $49, $F3, $96, $0B, $49, $F3, $9B, $0B, $15, $F4, $98, $0B, $6B, $F3, $9B, $0B, $6B, $F3, $96, $0B, $15, $F4, $93, $0B, 
$15, $F4, $98, $0B, $9D, $F4, $95, $0B, $37, $F4, $97, $0B, $37, $F4, $92, $0B, $9D, $F4, $90, $0B, $9D, $F4, $95, $0B, $AF, $F5, $91, $0B, $05, $F5, $94, $0B,
$05, $F5, $8F, $0B, $6B, $F5, $8D, $0B, $6B, $F5, $8F, $0B, $8D, $F5, $8F, $0B, $8D, $F5, $8C, $0B, $AF, $F5, $8C, $0B, $AF, $F5, $91, $0B, $04, $00, $00, $00, 
$2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $53, $00, 
$00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $57, $00, $00, $00, $38, $05, 
$07, $00, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $06, $00, $05, $00, $37, $F2, $9E, $0B, $37, $F2, $9B, $0B, $9D, $F2, $9B, $0B, $9D, $F2, $97, $0B, 
$F3, $F1, $9A, $0B, $F3, $F1, $9F, $0B, $37, $F2, $9E, $0B, $D1, $F1, $A0, $0B, $6B, $F1, $A2, $0B, $6B, $F1, $9D, $0B, $D1, $F1, $9B, $0B, $D1, $F1, $A0, $0B, 
$49, $F3, $99, $0B, $E3, $F2, $9B, $0B, $E3, $F2, $96, $0B, $49, $F3, $94, $0B, $49, $F3, $99, $0B, $15, $F4, $96, $0B, $6B, $F3, $99, $0B, $6B, $F3, $94, $0B, 
$15, $F4, $91, $0B, $15, $F4, $96, $0B, $9D, $F4, $93, $0B, $37, $F4, $95, $0B, $37, $F4, $90, $0B, $9D, $F4, $8E, $0B, $9D, $F4, $93, $0B, $7F, $F5, $8F, $0B,
$05, $F5, $92, $0B, $05, $F5, $8D, $0B, $6B, $F5, $8B, $0B, $6B, $F5, $8F, $0B, $7F, $F5, $8F, $0B, $AF, $F5, $8F, $0B, $8D, $F5, $8F, $0B, $8D, $F5, $8A, $0B, 
$AF, $F5, $8A, $0B, $AF, $F5, $8F, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, 
$07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $52, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00,
$00, $00, $06, $01, $01, $00, $55, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, $94, $0B,
$9D, $F2, $99, $0B, $F3, $F1, $9C, $0B, $F3, $F1, $97, $0B, $9D, $F2, $94, $0B, $D1, $F1, $9D, $0B, $6B, $F1, $9F, $0B, $6B, $F1, $9A, $0B, $D1, $F1, $98, $0B, 
$D1, $F1, $9D, $0B, $49, $F3, $96, $0B, $E3, $F2, $98, $0B, $E3, $F2, $93, $0B, $49, $F3, $91, $0B, $49, $F3, $96, $0B, $15, $F4, $93, $0B, $6B, $F3, $96, $0B,
$6B, $F3, $91, $0B, $D1, $F3, $8F, $0B, $D1, $F3, $8F, $0B, $15, $F4, $8F, $0B, $15, $F4, $93, $0B, $9D, $F4, $90, $0B, $37, $F4, $92, $0B, $37, $F4, $8D, $0B,
$9D, $F4, $8B, $0B, $9D, $F4, $90, $0B, $6B, $F5, $8D, $0B, $05, $F5, $8F, $0B, $05, $F5, $8A, $0B, $6B, $F5, $88, $0B, $6B, $F5, $8D, $0B, $AF, $F5, $8C, $0B,
$8D, $F5, $8C, $0B, $8D, $F5, $87, $0B, $AF, $F5, $87, $0B, $AF, $F5, $8C, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00,
$04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $50, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00,
$00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $55, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, 
$05, $00, $05, $00, $9D, $F2, $92, $0B, $9D, $F2, $97, $0B, $F3, $F1, $9A, $0B, $F3, $F1, $95, $0B, $9D, $F2, $92, $0B, $D1, $F1, $9B, $0B, $6B, $F1, $9D, $0B, 
$6B, $F1, $98, $0B, $D1, $F1, $96, $0B, $D1, $F1, $9B, $0B, $49, $F3, $94, $0B, $E3, $F2, $96, $0B, $E3, $F2, $91, $0B, $49, $F3, $8F, $0B, $49, $F3, $94, $0B,
$15, $F4, $91, $0B, $6B, $F3, $94, $0B, $6B, $F3, $8F, $0B, $D1, $F3, $8D, $0B, $D1, $F3, $8F, $0B, $15, $F4, $8F, $0B, $15, $F4, $91, $0B, $9D, $F4, $8E, $0B, 
$37, $F4, $90, $0B, $37, $F4, $8B, $0B, $9D, $F4, $89, $0B, $9D, $F4, $8E, $0B, $6B, $F5, $8B, $0B, $05, $F5, $8D, $0B, $05, $F5, $88, $0B, $6B, $F5, $86, $0B, 
$6B, $F5, $8B, $0B, $AF, $F5, $8A, $0B, $8D, $F5, $8A, $0B, $8D, $F5, $85, $0B, $AF, $F5, $85, $0B, $AF, $F5, $8A, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $4E, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $51, $00, $00, $00, $38, $05, $07, $00, $05, $00, 
$05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, $90, $0B, $9D, $F2, $94, $0B, $F3, $F1, $97, $0B, $F3, $F1, $93, $0B, $9D, $F2, $90, $0B,
$D1, $F1, $98, $0B, $6B, $F1, $9A, $0B, $6B, $F1, $96, $0B, $D1, $F1, $94, $0B, $D1, $F1, $98, $0B, $49, $F3, $91, $0B, $E3, $F2, $93, $0B, $E3, $F2, $8F, $0B, 
$49, $F3, $8D, $0B, $49, $F3, $91, $0B, $D1, $F3, $8F, $0B, $6B, $F3, $91, $0B, $6B, $F3, $8D, $0B, $D1, $F3, $8B, $0B, $D1, $F3, $8F, $0B, $9D, $F4, $8B, $0B,
$37, $F4, $8D, $0B, $37, $F4, $89, $0B, $9D, $F4, $87, $0B, $9D, $F4, $8B, $0B, $6B, $F5, $88, $0B, $05, $F5, $8A, $0B, $05, $F5, $86, $0B, $6B, $F5, $84, $0B,
$6B, $F5, $88, $0B, $AF, $F5, $87, $0B, $8D, $F5, $87, $0B, $8D, $F5, $83, $0B, $AF, $F5, $83, $0B, $AF, $F5, $87, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, 
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $4D, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $57, $00, $00, $00, $38, $05, $07, $00, $08, $00,
$05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $9D, $F2, $8D, $0B, $9D, $F2, $92, $0B, $F3, $F1, $95, $0B, $F3, $F1, $90, $0B, $22, $F2, $8F, $0B,
$37, $F2, $8F, $0B, $37, $F2, $8F, $0B, $9D, $F2, $8D, $0B, $D1, $F1, $96, $0B, $6B, $F1, $98, $0B, $6B, $F1, $93, $0B, $D1, $F1, $91, $0B, $D1, $F1, $96, $0B, 
$49, $F3, $8F, $0B, $E3, $F2, $91, $0B, $E3, $F2, $8C, $0B, $49, $F3, $8A, $0B, $49, $F3, $8F, $0B, $D1, $F3, $8D, $0B, $6B, $F3, $8F, $0B, $6B, $F3, $8A, $0B, 
$D1, $F3, $88, $0B, $D1, $F3, $8D, $0B, $9D, $F4, $89, $0B, $37, $F4, $8B, $0B, $37, $F4, $86, $0B, $9D, $F4, $84, $0B, $9D, $F4, $89, $0B, $6B, $F5, $86, $0B, 
$05, $F5, $88, $0B, $05, $F5, $83, $0B, $6B, $F5, $81, $0B, $6B, $F5, $86, $0B, $AF, $F5, $85, $0B, $8D, $F5, $85, $0B, $8D, $F5, $80, $0B, $AF, $F5, $80, $0B,
$AF, $F5, $85, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, 
$FC, $02, $00, $00, $00, $00, $4B, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, 
$01, $00, $5E, $00, $00, $00, $38, $05, $08, $00, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $05, $00, $04, $00, $9D, $F2, $8B, $0B, $9D, $F2, 
$90, $0B, $F3, $F1, $93, $0B, $F3, $F1, $8F, $0B, $37, $F2, $8F, $0B, $37, $F2, $8D, $0B, $9D, $F2, $8B, $0B, $D1, $F1, $94, $0B, $6B, $F1, $96, $0B, $6B, $F1, 
$91, $0B, $D1, $F1, $8F, $0B, $D1, $F1, $94, $0B, $49, $F3, $8D, $0B, $E3, $F2, $8F, $0B, $E3, $F2, $8A, $0B, $49, $F3, $88, $0B, $49, $F3, $8D, $0B, $D1, $F3, 
$8B, $0B, $6B, $F3, $8D, $0B, $6B, $F3, $88, $0B, $D1, $F3, $86, $0B, $D1, $F3, $8B, $0B, $9D, $F4, $87, $0B, $37, $F4, $89, $0B, $37, $F4, $84, $0B, $9D, $F4,
$82, $0B, $9D, $F4, $87, $0B, $6B, $F5, $84, $0B, $05, $F5, $86, $0B, $05, $F5, $81, $0B, $6B, $F5, $7F, $0B, $6B, $F5, $84, $0B, $AF, $F5, $83, $0B, $8D, $F5,
$83, $0B, $8D, $F5, $7E, $0B, $AF, $F5, $7E, $0B, $AF, $F5, $83, $0B, $D3, $F4, $81, $0B, $E3, $F4, $81, $0B, $E3, $F4, $81, $0B, $D3, $F4, $81, $0B, $04, $00,
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00,
$4A, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5E, $00, $00, $00,
$38, $05, $08, $00, $05, $00, $04, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $05, $00, $9D, $F2, $88, $0B, $9D, $F2, $8D, $0B, $37, $F2, $8F, $0B,
$37, $F2, $8A, $0B, $9D, $F2, $88, $0B, $22, $F2, $8F, $0B, $F3, $F1, $8F, $0B, $F3, $F1, $90, $0B, $22, $F2, $8F, $0B, $D1, $F1, $91, $0B, $6B, $F1, $93, $0B,
$6B, $F1, $8E, $0B, $D1, $F1, $8C, $0B, $D1, $F1, $91, $0B, $49, $F3, $8A, $0B, $E3, $F2, $8C, $0B, $E3, $F2, $87, $0B, $49, $F3, $85, $0B, $49, $F3, $8A, $0B, 
$D1, $F3, $88, $0B, $6B, $F3, $8A, $0B, $6B, $F3, $85, $0B, $D1, $F3, $83, $0B, $D1, $F3, $88, $0B, $9D, $F4, $84, $0B, $37, $F4, $86, $0B, $37, $F4, $81, $0B,
$E3, $F4, $7E, $0B, $E3, $F4, $81, $0B, $9D, $F4, $81, $0B, $9D, $F4, $84, $0B, $6B, $F5, $81, $0B, $05, $F5, $83, $0B, $05, $F5, $7E, $0B, $6B, $F5, $7C, $0B, 
$6B, $F5, $81, $0B, $AF, $F5, $80, $0B, $8D, $F5, $80, $0B, $8D, $F5, $7B, $0B, $AF, $F5, $7B, $0B, $AF, $F5, $80, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $48, $00, $00, $00, $04, $00, 
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $5B, $00, $00, $00, $38, $05, $07, $00, $05, $00, 
$05, $00, $05, $00, $07, $00, $08, $00, $05, $00, $05, $00, $9D, $F2, $86, $0B, $9D, $F2, $8B, $0B, $37, $F2, $8D, $0B, $37, $F2, $88, $0B, $9D, $F2, $86, $0B, 
$D1, $F1, $8F, $0B, $6B, $F1, $91, $0B, $6B, $F1, $8C, $0B, $D1, $F1, $8A, $0B, $D1, $F1, $8F, $0B, $49, $F3, $88, $0B, $E3, $F2, $8A, $0B, $E3, $F2, $85, $0B,
$49, $F3, $83, $0B, $49, $F3, $88, $0B, $D1, $F3, $86, $0B, $6B, $F3, $88, $0B, $6B, $F3, $83, $0B, $15, $F4, $80, $0B, $15, $F4, $81, $0B, $D1, $F3, $81, $0B,
$D1, $F3, $86, $0B, $9D, $F4, $82, $0B, $37, $F4, $84, $0B, $37, $F4, $7F, $0B, $E3, $F4, $7C, $0B, $E3, $F4, $81, $0B, $D3, $F4, $81, $0B, $9D, $F4, $81, $0B,
$9D, $F4, $82, $0B, $6B, $F5, $7F, $0B, $05, $F5, $81, $0B, $05, $F5, $7C, $0B, $6B, $F5, $7A, $0B, $6B, $F5, $7F, $0B, $AF, $F5, $7E, $0B, $8D, $F5, $7E, $0B,
$8D, $F5, $79, $0B, $AF, $F5, $79, $0B, $AF, $F5, $7E, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, 
$F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $46, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, 
$01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $55, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00, $07, $00, $05, $00, $05, $00, $05, $00, 
$9D, $F2, $83, $0B, $9D, $F2, $88, $0B, $37, $F2, $8A, $0B, $37, $F2, $85, $0B, $9D, $F2, $83, $0B, $D1, $F1, $8C, $0B, $6B, $F1, $8E, $0B, $6B, $F1, $89, $0B, 
$D1, $F1, $87, $0B, $D1, $F1, $8C, $0B, $49, $F3, $85, $0B, $E3, $F2, $87, $0B, $E3, $F2, $82, $0B, $49, $F3, $80, $0B, $49, $F3, $85, $0B, $D1, $F3, $83, $0B, 
$6B, $F3, $85, $0B, $6B, $F3, $80, $0B, $15, $F4, $7D, $0B, $15, $F4, $81, $0B, $D1, $F3, $81, $0B, $D1, $F3, $83, $0B, $E3, $F4, $7E, $0B, $37, $F4, $81, $0B,
$37, $F4, $7C, $0B, $E3, $F4, $79, $0B, $E3, $F4, $7E, $0B, $6B, $F5, $7C, $0B, $05, $F5, $7E, $0B, $05, $F5, $79, $0B, $6B, $F5, $77, $0B, $6B, $F5, $7C, $0B, 
$AF, $F5, $7B, $0B, $8D, $F5, $7B, $0B, $8D, $F5, $76, $0B, $AF, $F5, $76, $0B, $AF, $F5, $7B, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, 
$2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $45, $00, $00, $00, $04, $00, $00, $00, $2D, $01,
$04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $53, $00, $00, $00, $38, $05, $07, $00, $05, $00, $05, $00, $05, $00,
$05, $00, $05, $00, $06, $00, $05, $00, $9D, $F2, $81, $0B, $9D, $F2, $86, $0B, $37, $F2, $88, $0B, $37, $F2, $83, $0B, $9D, $F2, $81, $0B, $D1, $F1, $8A, $0B, 
$6B, $F1, $8C, $0B, $6B, $F1, $87, $0B, $D1, $F1, $85, $0B, $D1, $F1, $8A, $0B, $49, $F3, $83, $0B, $E3, $F2, $85, $0B, $E3, $F2, $80, $0B, $49, $F3, $7E, $0B, 
$49, $F3, $83, $0B, $15, $F4, $80, $0B, $6B, $F3, $83, $0B, $6B, $F3, $7E, $0B, $15, $F4, $7B, $0B, $15, $F4, $80, $0B, $E3, $F4, $7C, $0B, $37, $F4, $7F, $0B, 
$37, $F4, $7A, $0B, $E3, $F4, $77, $0B, $E3, $F4, $7C, $0B, $6B, $F5, $7A, $0B, $05, $F5, $7C, $0B, $05, $F5, $77, $0B, $46, $F5, $75, $0B, $6B, $F5, $75, $0B,
$6B, $F5, $7A, $0B, $AF, $F5, $79, $0B, $8D, $F5, $79, $0B, $8D, $F5, $75, $0B, $AF, $F5, $75, $0B, $AF, $F5, $79, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $43, $00, $00, $00, $04, $00,
$00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $57, $00, $00, $00, $38, $05, $07, $00, $07, $00,
$05, $00, $05, $00, $05, $00, $06, $00, $05, $00, $05, $00, $9D, $F2, $7E, $0B, $9D, $F2, $83, $0B, $37, $F2, $85, $0B, $37, $F2, $81, $0B, $F3, $F1, $81, $0B,
$F3, $F1, $81, $0B, $9D, $F2, $7E, $0B, $D1, $F1, $87, $0B, $6B, $F1, $89, $0B, $6B, $F1, $84, $0B, $D1, $F1, $82, $0B, $D1, $F1, $87, $0B, $49, $F3, $80, $0B,
$E3, $F2, $82, $0B, $E3, $F2, $7D, $0B, $49, $F3, $7B, $0B, $49, $F3, $80, $0B, $15, $F4, $7D, $0B, $6B, $F3, $80, $0B, $6B, $F3, $7B, $0B, $15, $F4, $78, $0B, 
$15, $F4, $7D, $0B, $E3, $F4, $79, $0B, $37, $F4, $7C, $0B, $37, $F4, $77, $0B, $99, $F4, $75, $0B, $E3, $F4, $75, $0B, $E3, $F4, $79, $0B, $6B, $F5, $77, $0B, 
$05, $F5, $79, $0B, $05, $F5, $75, $0B, $6B, $F5, $75, $0B, $6B, $F5, $77, $0B, $AF, $F5, $76, $0B, $8D, $F5, $76, $0B, $8D, $F5, $75, $0B, $AF, $F5, $75, $0B,
$AF, $F5, $76, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, 
$FC, $02, $00, $00, $00, $00, $42, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, 
$01, $00, $48, $00, $00, $00, $38, $05, $06, $00, $07, $00, $05, $00, $05, $00, $05, $00, $05, $00, $04, $00, $9D, $F2, $7C, $0B, $9D, $F2, $81, $0B, $37, $F2, 
$83, $0B, $37, $F2, $81, $0B, $F3, $F1, $81, $0B, $F3, $F1, $7F, $0B, $9D, $F2, $7C, $0B, $D1, $F1, $85, $0B, $6B, $F1, $87, $0B, $6B, $F1, $82, $0B, $D1, $F1, 
$80, $0B, $D1, $F1, $85, $0B, $49, $F3, $7E, $0B, $E3, $F2, $80, $0B, $E3, $F2, $7B, $0B, $49, $F3, $79, $0B, $49, $F3, $7E, $0B, $15, $F4, $7B, $0B, $6B, $F3, 
$7E, $0B, $6B, $F3, $79, $0B, $15, $F4, $76, $0B, $15, $F4, $7B, $0B, $E3, $F4, $77, $0B, $37, $F4, $7A, $0B, $37, $F4, $75, $0B, $E3, $F4, $75, $0B, $E3, $F4,
$77, $0B, $46, $F5, $75, $0B, $05, $F5, $77, $0B, $05, $F5, $75, $0B, $46, $F5, $75, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, 
$03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $40, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00,
$04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, $06, $01, $01, $00, $3B, $00, $00, $00, $38, $05, $05, $00, $05, $00, $05, $00, $05, $00, $06, $00,
$04, $00, $9D, $F2, $79, $0B, $9D, $F2, $7E, $0B, $F3, $F1, $81, $0B, $F3, $F1, $7C, $0B, $9D, $F2, $79, $0B, $D1, $F1, $82, $0B, $6B, $F1, $84, $0B, $6B, $F1, 
$7F, $0B, $D1, $F1, $7D, $0B, $D1, $F1, $82, $0B, $49, $F3, $7B, $0B, $E3, $F2, $7D, $0B, $E3, $F2, $78, $0B, $49, $F3, $76, $0B, $49, $F3, $7B, $0B, $15, $F4, 
$78, $0B, $6B, $F3, $7B, $0B, $6B, $F3, $76, $0B, $79, $F3, $75, $0B, $15, $F4, $75, $0B, $15, $F4, $78, $0B, $99, $F4, $75, $0B, $37, $F4, $77, $0B, $37, $F4, 
$75, $0B, $99, $F4, $75, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $07, $00,
$00, $00, $FC, $02, $00, $00, $00, $00, $3E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, $00, $00, 
$06, $01, $01, $00, $32, $00, $00, $00, $38, $05, $04, $00, $05, $00, $05, $00, $06, $00, $05, $00, $9D, $F2, $77, $0B, $9D, $F2, $7C, $0B, $F3, $F1, $7F, $0B, 
$F3, $F1, $7A, $0B, $9D, $F2, $77, $0B, $D1, $F1, $80, $0B, $6B, $F1, $82, $0B, $6B, $F1, $7D, $0B, $D1, $F1, $7B, $0B, $D1, $F1, $80, $0B, $49, $F3, $79, $0B, 
$E3, $F2, $7B, $0B, $E3, $F2, $76, $0B, $07, $F3, $75, $0B, $49, $F3, $75, $0B, $49, $F3, $79, $0B, $15, $F4, $76, $0B, $6B, $F3, $79, $0B, $6B, $F3, $75, $0B,
$15, $F4, $75, $0B, $15, $F4, $76, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00,
$07, $00, $00, $00, $FC, $02, $00, $00, $00, $00, $3E, $00, $00, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $04, $00, $00, $00, $2D, $01, $01, $00, $04, $00, 
$00, $00, $06, $01, $01, $00, $2E, $00, $00, $00, $38, $05, $04, $00, $05, $00, $05, $00, $05, $00, $04, $00, $9D, $F2, $79, $0B, $9D, $F2, $75, $0B, $F3, $F1, 
$75, $0B, $F3, $F1, $7C, $0B, $9D, $F2, $79, $0B, $D1, $F1, $7D, $0B, $6B, $F1, $7F, $0B, $6B, $F1, $75, $0B, $D1, $F1, $75, $0B, $D1, $F1, $7D, $0B, $49, $F3, 
$76, $0B, $E3, $F2, $78, $0B, $E3, $F2, $75, $0B, $49, $F3, $75, $0B, $49, $F3, $76, $0B, $79, $F3, $75, $0B, $6B, $F3, $76, $0B, $6B, $F3, $75, $0B, $79, $F3, 
$75, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $2D, $01, $03, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, 
$00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $12, $00, $00, $00, $25, $03, $07, $00, $96, $F4, $50, $0B,
$81, $F4, $50, $0B, $6C, $F4, $43, $0B, $81, $F4, $43, $0B, $81, $F4, $43, $0B, $96, $F4, $35, $0B, $6C, $F4, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01,
$04, $00, $08, $00, $00, $00, $25, $03, $02, $00, $42, $F4, $50, $0B, $42, $F4, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01,
$04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $08, $00, $00, $00,
$25, $03, $02, $00, $AF, $F3, $43, $0B, $C4, $F3, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, 
$FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $08, $00, $00, $00, $25, $03, $02, $00, $2D, $F4,
$50, $0B, $57, $F4, $50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00,
$00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0E, $00, $00, $00, $25, $03, $05, $00, $F2, $F2, $35, $0B, $F2, $F2, $50, $0B, 
$07, $F3, $50, $0B, $1C, $F3, $43, $0B, $F2, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, 
$FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $C8, $F2,
$50, $0B, $DD, $F2, $43, $0B, $DD, $F2, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, 
$00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $03, $F4, $50, $0B, 
$18, $F4, $43, $0B, $18, $F4, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00,
$00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $EE, $F3, $35, $0B, $EE, $F3, 
$50, $0B, $03, $F4, $50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00,
$00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $85, $F3, $50, $0B, $9A, $F3, $43, $0B,
$9A, $F3, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, 
$00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0A, $00, $00, $00, $25, $03, $03, $00, $70, $F3, $35, $0B, $70, $F3, $50, $0B, $85, $F3, 
$50, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, 
$66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $0C, $00, $00, $00, $25, $03, $04, $00, $B3, $F2, $35, $0B, $B3, $F2, $50, $0B, $C8, $F2, $50, $0B, 
$C8, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, 
$00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $10, $00, $00, $00, $25, $03, $06, $00, $31, $F3, $43, $0B, $31, $F3, $35, $0B, $5B, $F3, 
$35, $0B, $5B, $F3, $50, $0B, $46, $F3, $50, $0B, $31, $F3, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, 
$00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01, $04, $00, $10, $00, $00, $00, $25, $03, $06, $00, 
$74, $F2, $43, $0B, $74, $F2, $35, $0B, $9E, $F2, $35, $0B, $9E, $F2, $50, $0B, $89, $F2, $50, $0B, $74, $F2, $43, $0B, $04, $00, $00, $00, $2D, $01, $02, $00,
$04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, $04, $00, $00, $00, $2D, $01,
$04, $00, $0E, $00, $00, $00, $25, $03, $05, $00, $D9, $F3, $50, $0B, $C4, $F3, $50, $0B, $AF, $F3, $43, $0B, $AF, $F3, $35, $0B, $D9, $F3, $35, $0B, $04, $00,
$00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $09, $00, $00, $00, $FA, $02, $00, $00, $00, $00, $00, $00, $00, $00, $66, $00, $22, $00, 
$04, $00, $00, $00, $2D, $01, $04, $00, $0E, $00, $00, $00, $25, $03, $05, $00, $5F, $F2, $50, $0B, $4A, $F2, $50, $0B, $35, $F2, $43, $0B, $35, $F2, $35, $0B, 
$5F, $F2, $35, $0B, $04, $00, $00, $00, $2D, $01, $02, $00, $04, $00, $00, $00, $F0, $01, $04, $00, $03, $00, $00, $00, $00, $00);

FixedMeta_ChkPnts: TFixedMeta_ChkPnts =
(5740, 7901, 9148, 5279, 6209, 7370, 8650, 3992, 3949, 7712, 3968, 3734, 6606, 7442, 8154, 3833, 1708, 6988, 2933, 2242, 8266, 5550, 830, 3513, 5412, 1146, 3287, 4813, 236, 4055, 7395, 3632,
1187, 2440, 4019, 8600, 7024, 5642, 4653, 231, 3656, 7080, 7497, 2868, 451, 6095, 49, 7107, 1517, 9054, 5543, 830, 3472, 6103, 7662, 313, 2850, 5294, 5286, 2877, 7793, 5180, 8626, 6196,
4908, 1427, 2554, 1894, 446, 5403, 6668, 927, 8291, 8870, 4267, 2984, 7071, 6485, 3517, 8917, 1728, 5615, 7589, 2266, 4357, 1442, 4868, 3502, 462, 8270, 424, 7754, 5979, 493, 1558, 6507,
9123, 6322, 1667, 860);

FixedMeta_ChkPntVal: TFixedMeta_ChkPntVal =
($00, $00, $09, $00, $00, $18, $03, $15, $F2, $E3, $D1, $00, $AF, $C0, $01, $03, $BD, $AF, $00, $D3, $96, $9B, $2D, $0C, $9A, $06, $00, $01, $00, $0B, $00, $07, 
$00, $00, $0B, $04, $B5, $96, $F2, $01, $00, $AF, $00, $D3, $F0, $F4, $02, $F1, $00, $89, $00, $2D, $00, $F4, $01, $00, $01, $24, $00, $F0, $00, $9D, $00, $00, 
$89, $00, $00, $D3, $1B, $F3, $00, $00, $F4, $00, $0B, $02, $F3, $05, $0C, $00, $00, $0B, $0B, $04, $00, $72, $07, $D3, $2D, $81, $00, $00, $33, $00, $F0, $F2, 
$0B, $37, $00, $2D);


implementation

var
tsMetaFile: TtsMetaFile;
MetaFileLoaded: Boolean;


procedure LoadLogo(Canvas: TCanvas);
var TmpMs: TMemoryStream;
begin
  TmpMs := TMemoryStream.Create;
  if GetDeviceCaps(Canvas.Handle, BITSPIXEL) > 8 then
  TmpMs.Write(FixedMeta_Data1, 9224) else
  TmpMs.Write(FixedMeta_Data2, 9338);
  TmpMs.Position := 0;
  tsMetaFile.ReadData(TmpMs);
  MetaFileLoaded := TRUE;
  TmpMs.Free;
end;

procedure FIXWMF_DrawToCanvas(Canvas: TCanvas; x, y, w, h: Integer);
var r: TRect;
begin
If not MetaFileLoaded then LoadLogo(Canvas);
with r do begin
top := y;
left := x;
right := x + w - 1;
bottom := y + h - 1;
end;
  tsMetaFile.Draw(canvas, r);
end;





procedure TtsMetaFile.WriteData(Stream: TStream);
begin
  inherited WriteData(Stream);
end;

procedure TtsMetaFile.ReadData(Stream: TStream);
begin
  inherited ReadData(Stream);
end;

procedure TtsMetaFile.Draw(ACanvas: TCanvas; const Rect: TRect);
begin
  inherited Draw(ACanvas, Rect);
end;








initialization
tsMetaFile := TtsMetaFile.Create;
MetaFileLoaded := FALSE;
finalization
tsMetaFile.Free;
end.