{
tscap32 - Delphi Video Capture Component
Copyright (C) 1996-2003 Thomas Stuefe

contact: tstuefe@users.sourceforge.net
web:     tscap32.sourceforge.net


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
}


unit tsTechAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  //own:
  tsTechAboutFrm,
  tstlg2;

type
  TtsTechAbout = class(TComponent)
  private
    Lines: array[0..9] of string;
    procedure SetLine0(Txt: string);
    function GetLine0: string;
    procedure SetLine1(Txt: string);
    function GetLine1: string;
    procedure SetLine2(Txt: string);
    function GetLine2: string;
    procedure SetLine3(Txt: string);
    function GetLine3: string;
    procedure SetLine4(Txt: string);
    function GetLine4: string;
    procedure SetLine5(Txt: string);
    function GetLine5: string;
    procedure SetLine6(Txt: string);
    function GetLine6: string;
    procedure SetLine7(Txt: string);
    function GetLine7: string;
    procedure SetLine8(Txt: string);
    function GetLine8: string;
    procedure SetLine9(Txt: string);
    function GetLine9: string;
    function DummyBoolGetFalse: Boolean;
    procedure SetShow(status: Boolean);
  published
    property Line0: string Read GetLine0 Write SetLine0;
    property Line1: string Read GetLine1 Write SetLine1;
    property Line2: string Read GetLine2 Write SetLine2;
    property Line3: string Read GetLine3 Write SetLine3;
    property Line4: string Read GetLine4 Write SetLine4;
    property Line5: string Read GetLine5 Write SetLine5;
    property Line6: string Read GetLine6 Write SetLine6;
    property Line7: string Read GetLine7 Write SetLine7;
    property Line8: string Read GetLine8 Write SetLine8;
    property Line9: string Read GetLine9 Write SetLine9;
    property Show: Boolean read DummyBoolGetFalse Write SetShow;
  end;

procedure Register;

implementation


procedure TtsTechAbout.SetLine0(Txt: string);
begin
  Lines[0] := (Txt);
end;

function TtsTechAbout.GetLine0: string;
begin
  Result := (Lines[0]);
end;

procedure TtsTechAbout.SetLine1(Txt: string);
begin
  Lines[1] := (Txt);
end;

function TtsTechAbout.GetLine1: string;
begin
  Result := (Lines[1]);
end;

procedure TtsTechAbout.SetLine2(Txt: string);
begin
  Lines[2] := (Txt);
end;

function TtsTechAbout.GetLine2: string;
begin
  Result := (Lines[2]);
end;

procedure TtsTechAbout.SetLine3(Txt: string);
begin
  Lines[3] := (Txt);
end;

function TtsTechAbout.GetLine3: string;
begin
  Result := (Lines[3]);
end;

procedure TtsTechAbout.SetLine4(Txt: string);
begin
  Lines[4] := (Txt);
end;

function TtsTechAbout.GetLine4: string;
begin
  Result := (Lines[4]);
end;

procedure TtsTechAbout.SetLine5(Txt: string);
begin
  Lines[5] := (Txt);
end;

function TtsTechAbout.GetLine5: string;
begin
  Result := (Lines[5]);
end;

procedure TtsTechAbout.SetLine6(Txt: string);
begin
  Lines[6] := (Txt);
end;

function TtsTechAbout.GetLine6: string;
begin
  Result := (Lines[6]);
end;

procedure TtsTechAbout.SetLine7(Txt: string);
begin
  Lines[7] := (Txt);
end;

function TtsTechAbout.GetLine7: string;
begin
  Result := (Lines[7]);
end;

procedure TtsTechAbout.SetLine8(Txt: string);
begin
  Lines[8] := (Txt);
end;

function TtsTechAbout.GetLine8: string;
begin
  Result := (Lines[8]);
end;

procedure TtsTechAbout.SetLine9(Txt: string);
begin
  Lines[9] := (Txt);
end;

function TtsTechAbout.GetLine9: string;
begin
  Result := (Lines[9]);
end;

function TtsTechAbout.DummyBoolGetFalse: Boolean;
begin
  Result := FALSE;
end;

procedure TtsTechAbout.SetShow(status: Boolean);
var
  Frm: TtsTechAboutFrm;
  i: Integer;
begin
  if status then begin
    Application.CreateForm(TtsTechAboutFrm, Frm);
    with Frm do begin
      for i := 0 to 9 do
        Txt[i] := Lines[i];
      ShowModal;
      Free;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('tsTech', [TtsTechAbout]);
end;

end.
