{
This example demonstrates how the CapWndDimension-property can be used to
specify the size and the offse3t of the displayed video.

Try this demo in both preview and overlay mode.
}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, tscap32, ExtCtrls, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    tsCap321: TtsCap32;
    tsCap32PopupMenu1: TtsCap32PopupMenu;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    sets1: TMenuItem;
    soFitIn1: TMenuItem;
    soFitInProportional1: TMenuItem;
    soFitInPower21: TMenuItem;
    soOriginalSize1: TMenuItem;
    x21: TMenuItem;
    N21: TMenuItem;
    center1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure soFitIn1Click(Sender: TObject);
    procedure soFitInProportional1Click(Sender: TObject);
    procedure soFitInPower21Click(Sender: TObject);
    procedure soOriginalSize1Click(Sender: TObject);
    procedure x21Click(Sender: TObject);
    procedure N21Click(Sender: TObject);
    procedure center1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  with Trackbar1 do begin
    Max := Width;
    Frequency := 10;
  end;
  with Trackbar2 do begin
    Max := Height;
    Frequency := 10;
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    x := TrackBar1.Position;
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    y := TrackBar2.Position;
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    w := TrackBar3.Position;
end;

procedure TForm1.TrackBar4Change(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    h := TrackBar4.Position;
end;

procedure TForm1.soFitIn1Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soFitIn;
end;

procedure TForm1.soFitInProportional1Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soFitInProportional;

end;

procedure TForm1.soFitInPower21Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soFitInPower2;
end;

procedure TForm1.soOriginalSize1Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soOriginalSize;
end;

procedure TForm1.x21Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soHalf;
end;

procedure TForm1.N21Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do
    ScaleOrder := soDouble;
end;

procedure TForm1.center1Click(Sender: TObject);
begin
  with tsCap321.CapWndDimensions do begin
    Center := not Center;
    center1.Checked := Center;
    Trackbar1.Visible := not center;
    Trackbar2.Visible := not center;
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
var
  InteriorX, InteriorY: Integer;
begin
  InteriorX := ClientWidth - 66;
  InteriorY := ClientHeight - 66;

  tsCap321.Width := InteriorX;
  tsCap321.Height := InteriorY;
  tsCap321.Top := 33;
  tsCap321.left := 33;

  TrackBar1.Width := InteriorX;
  TrackBar3.Width := InteriorX;
  TrackBar2.Height := InteriorY;
  TrackBar4.Height := InteriorY;
  TrackBar3.top := InteriorY + 33;
  TrackBar4.left := InteriorX + 33;

end;

end.
