{
example:
Grabbing into Memory using CopyToClipboard and the OnDib/OnBitmap-events.

Slow(compared wirth the direct use of the Frame-callback),
but it works also fine with compressed images

}



unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, tscap32, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Button1: TButton;
    PaintBox2: TPaintBox;
    Label1: TLabel;
    Label2: TLabel;
    tsCap32PopupMenu1: TtsCap32PopupMenu;
    Label3: TLabel;
    tsCap321: TtsCap32;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure tsCap321Bitmap(Sender: TObject; Bitmap: TBitmap;
    msSinceFirstFrame: Integer);
    procedure tsCap321Dib(Sender: TObject; pBmi: PBitmapInfo; pBits: PChar;
      msSinceFirstFrame: Integer);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  tsCap321.CopyToClipboard := TRUE;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
  with tscap321 do
    //Connect first
    Connected := TRUE;
end;

procedure TForm1.tsCap321Bitmap(Sender: TObject; Bitmap: TBitmap; msSinceFirstFrame: Integer);
var
  r: TRect;
begin
  if Bitmap <> nil then begin
    with r do begin
      topleft.x := 0;
      topleft.y := 0;
      bottomright.x := PaintBox2.Width;
      bottomright.y := PaintBox2.Height;
    end;
    PaintBox2.Canvas.StretchDraw(r, Bitmap);
    Bitmap.Free;
  end;
end;

procedure TForm1.tsCap321Dib(Sender: TObject; pBmi: PBitmapInfo;
  pBits: PChar; msSinceFirstFrame: Integer);
begin
//display the delivered DIB into the Paintbox
//instead of tsCap321.Parameter.ImageWidth/Height the pVideoFomat^-DIB-Header or
//the delivered pBmi^-DIB-Header may also be used
  StretchDIBits(PaintBox1.Canvas.Handle,
                0, 0, PaintBox1.Width, PaintBox1.Height,
                0, 0, tsCap321.Parameter.ImageWidth, tsCap321.Parameter.ImageHeight,
                pBits, pBmi^,
                DIB_RGB_COLORS, SRCCOPY);
  //display the time the frame was captured
  Label3.Caption := IntToStr(msSinceFirstFrame);
end;

end.
