{
example 2:
Grabbing into Memory using CapTechnique == ctManualIntoMem and
the OnDib/OnBitmap-events.

This demo works only properly when the driver dialogs offer the option
to deliver uncompressed images. In case of compressed formats, OnDib gets also
compressed DIBs StretchDIBits cannot draw, and OnBitmap gets nil
instead of a TBitmap - object.

}



unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, tscap32, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Button1: TButton;
    PaintBox2: TPaintBox;
    Label1: TLabel;
    Label2: TLabel;
    tsCap32PopupMenu1: TtsCap32PopupMenu;
    Label3: TLabel;
    tsCap321: TtsCap32;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure tsCap321Bitmap(Sender: TObject; Bitmap: TBitmap;
    msSinceFirstFrame: Integer);
    procedure tsCap321Dib(Sender: TObject; pBmi: PBitmapInfo; pBits: PChar;
      msSinceFirstFrame: Integer);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  tsCap321.CapOrder := grab;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
  with tscap321 do begin
    //Connect first
    Connected := TRUE;

    //check whether the used video format is compressed
    LoadVideoFormat;
    if pVideoFormat^.bmiHeader.biCompression <> BI_RGB then begin
      pVideoFormat^.bmiHeader.biCompression := BI_RGB;
      SetVideoFormat;
    end;

    LoadVideoFormat;
    if pVideoFormat^.bmiHeader.biCompression <> BI_RGB then begin
      //call driver dialogues
      MessageDlg('Please adjust an uncompressed videoformat!', mtInformation, [mbOk], 0);
      if DriverCaps.HasDlgVideoFormat then
        Parameter.DlgFormat := TRUE;
      Parameter.DlgCompression := TRUE;
    end;

    if pVideoFormat^.bmiHeader.biCompression <> BI_RGB then
      //call driver dialogues
      MessageDlg('The video format is still compressed - the demo may not work correctly. You can adjust the video format with the driver dialogs (right muse button).', mtInformation, [mbOk], 0);

     //prepare manual grabbing. (If no overlay is available, the capture window
    //will be hidden now)
    CapOrder := start;

  end;
end;

procedure TForm1.tsCap321Bitmap(Sender: TObject; Bitmap: TBitmap; msSinceFirstFrame: Integer);
begin
  if Bitmap <> nil then begin
    PaintBox2.Canvas.Draw(0, 0, Bitmap);
    Bitmap.Free;
  end;
end;

procedure TForm1.tsCap321Dib(Sender: TObject; pBmi: PBitmapInfo;
  pBits: PChar; msSinceFirstFrame: Integer);
begin
//display the delivered DIB into the Paintbox
//instead of tsCap321.Parameter.ImageWidth/Height the pVideoFomat^-DIB-Header or
//the delivered pBmi^-DIB-Header may also be used
  StretchDIBits(PaintBox1.Canvas.Handle,
                0, 0, PaintBox1.Width, PaintBox1.Height,
                0, 0, tsCap321.Parameter.ImageWidth, tsCap321.Parameter.ImageHeight,
                pBits, pBmi^,
                DIB_RGB_COLORS, SRCCOPY);
  //display the time the frame was captured
  Label3.Caption := IntToStr(msSinceFirstFrame);
end;

end.
