unit demoun;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,TreeColl;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button7: TButton;
    Button8: TButton;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    aCollection : TTreeCollection;
    procedure RefreshTree;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   aCollection:=TTreeCollection.Create(nil);
end;

procedure TForm1.Button1Click(Sender: TObject);
var aColl,anewColl : TTreeCollection;
begin
   if (TreeView1.Selected<>nil) and (TreeView1.Selected<>TreeView1.items[0]) then
   begin
      aColl:=TTreeCollection(TreeView1.Selected.Data);
      if aColl<>nil then
         anewColl:=aColl.Add('Item# '+inttostr(aColl.Count+1));
   end
   else
      anewColl:=aCollection.Add('Item# '+inttostr(aCollection.Count+1));
   RefreshTree;
   TreeView1.setFocus;
end;

procedure TForm1.RefreshTree;
var anode : TTreeNode;
 procedure AddingNodes(aNode : TTreeNode; Collection : TTreeCollection);
 var i : integer;
     Node : TTreeNode;

 begin
    for i:=0 to Collection.Count-1 do
    begin
       Node:=aNode.owner.AddChildobject(aNode,Collection[i].caption,Collection[i]);
       if Collection[i].Count>0 then AddingNodes(Node,Collection[i]);
    end
 end;
begin
    TreeView1.Items.Clear;
    anode:=TreeView1.items.add(nil,aCollection.Caption);
    addingNodes(aNode,aCollection);
    TreeView1.FullExpand;
end;
procedure TForm1.Button5Click(Sender: TObject);
begin
   if SaveDialog1.execute then
   begin
       if SaveDialog1.FileName<>'' then
          aCollection.SaveToFile(SaveDialog1.FileName);
   end;
   TreeView1.setFocus;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
    If Opendialog1.Execute then
       if Opendialog1.Filename<>'' then
          aCollection.LoadFromFile(OpenDialog1.FileName);
    RefreshTree;
    TreeView1.setFocus;
end;

function DescSort(Item1, Item2: TTreeCollection): Integer;
begin
     Result:=CompareStr(item1.caption,item2.caption)*-1;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
    aCollection.CustomSort(DescSort,true);
    RefreshTree;
    TreeView1.setFocus;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
    aCollection.AlphaSort(true);
    RefreshTree;
    TreeView1.setFocus;

end;

procedure TForm1.Button2Click(Sender: TObject);
var aColl,aParent : TTreeCollection;
begin
   if (TreeView1.Selected<>nil) and (TreeView1.Selected<>TreeView1.items[0]) then
   begin
      aColl:=TTreeCollection(TreeView1.Selected.Data);
      aParent:=aColl.TreeCollection;
      aParent.DeleteItem(aColl);
   end
   else Showmessage('Cannot Delete Root TreeCollection');
   RefreshTree;
   TreeView1.setFocus;

end;

procedure TForm1.Button3Click(Sender: TObject);
var aColl,aPrev,aparent : TTreeCollection;
begin
   if (TreeView1.Selected<>nil) and (TreeView1.Selected<>TreeView1.items[0]) then
   begin
      aColl:=TTreeCollection(TreeView1.Selected.Data);
      aPrev:=aColl.GetPrevSibling;
      aParent:=aColl.TreeCollection;
      if aPrev<>nil then
      begin
         aparent.Exchange(aPrev.index,aColl.index);
         RefreshTree;
      end
      else Showmessage('Cannot Move Up');
   end
   else Showmessage('Cannot Move Root TreeCollection');

   TreeView1.setFocus;

end;

procedure TForm1.Button4Click(Sender: TObject);
var aColl,aNext,aparent : TTreeCollection;
begin
   if (TreeView1.Selected<>nil) and (TreeView1.Selected<>TreeView1.items[0]) then
   begin
      aColl:=TTreeCollection(TreeView1.Selected.Data);
      aNext:=aColl.GetNextSibling;
      aParent:=aColl.TreeCollection;
      if aNext<>nil then
      begin
         aparent.Exchange(aNext.index,aColl.index);
         RefreshTree;
      end
      else Showmessage('Cannot Move Down');
   end
   else Showmessage('Cannot Move Root TreeCollection');
   RefreshTree;
   TreeView1.setFocus;


end;

end.
