unit Readme;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes,
  Forms, StdCtrls, DsgnIntf;

type
  TReadMe = class(Tcomponent)
  end;

  TReadMeEditor = class(TDefaultEditor)
  private
    procedure ActivateNote;
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

procedure TReadMeEditor.ExecuteVerb(Index: Integer);
begin
  {we only have one verb, so exit if this ain't it}
  if Index <> 0 then Exit;
    ActivateNote;
end;

function TReadMeEditor.GetVerb(Index: Integer): String;
begin
  Result := 'Open';
end;

function TReadMeEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure TReadMeEditor.Edit;
begin
   ActivateNote;
end;

procedure TReadMeEditor.ActivateNote;
var NotePadHandle: Thandle;
    TmpSL: TstringList;
    FullFileName, WinExecCommandLine, WindowName: string;
    PWinExecCommandLine, PWindowName: Pchar;
begin
   GetDir(0,FullFileName);
   FullFileName:= FullFileName +'\'+TReadMe(Component).Name+'.TXT';
   if not FileExists(FullFileName) then begin
     TmpSL:= TstringList.Create;
     TmpSL.Add(' ');
     TmpSL.SaveToFile(FullFileName);
     TmpSL.Clear;
     TmpSL.Free;
   end;
   {$IFDEF WIN32}
      WindowName:= TReadMe(Component).Name+'.txt'+' - Notepad'+#0;
   {$ELSE}
      WindowName:= 'Notepad - '+UpperCase(TReadMe(Component).Name+'.TXT')+#0;
   {$ENDIF}
   PWindowName:= @WindowName[1];
   NotePadHandle:= FindWindow('Notepad',PWindowName);
   WinExecCommandLine:= 'NOTEPAD '+ FullFileName+#0;
   PWinExecCommandLine:= @WinExecCommandLine[1];
   if NotePadHandle > 0 then
     BringWindowToTop(NotePadHandle)
   else
     WinExec(PWinExecCommandLine,SW_SHOW);
end;


procedure Register;
begin
  RegisterComponents('Samples', [TReadMe]);
  RegisterComponentEditor(TReadMe, TReadMeEditor);
end;

end.
