unit TomCgi;

// TCGI Ver 1.02
// Freeware Unit (OCT 22 1996) , Help You Write A Console Mode 32 Bit CGI Program
// Written By Tom Lee
// Taiwan , Republic Of China
// E-Mail Address: Tomm.bbs@csie.nctu.edu.tw
// Home Page: http://www.aaa.hinet.net/delphi
// (Chinese BIG-5 Encode Home Page)
//
//  History
//  Ver 1.0   First Release , Only Support Request method "Post"
//  Ver 1.01  Support Request method "Post" and "Get"
//  Ver 1.02  This Release , Support Many Server Variable


interface

uses
    Windows,SysUtils,Classes;


const
     DefaultBufferSize=4096;
type

TCgi = Class(TObject)
private
    {Private Part Declare}
    FInputRawData:String;
    function ParamCount:Integer;
    function GetToken(aString, SepChar: String; TokenNum: Byte):String;
    function NumToken(aString, SepChar: String):integer;
    function GetParamItemValue(inpStr:string;Cnt:integer):string;
    function GetParamItemName(inpStr:string;Cnt:integer):string;
public
    {Public Part Declare}
    ContentLength:integer;
    ContentType:string;
    GatewayInterface:string;
    HttpAccept:string;
    HttpUserAgent:string;
    Params:TStrings;
    QueryString:string;
    RemoteAddr:string;
    RemoteHost:string;
    RemoteUser:string;
    RequestMethod:string;
    ScriptName:string;
    ServerName:string;
    ServerProtocol:string;
    ServerSoftware:string;
    constructor Create;
    destructor destroy ; override ;
    function ParamRawData:string;
end;

implementation

constructor TCgi.Create;
var
   buf:PChar;
   ContentLengthStr:string;
   ret,idx:integer;
begin
    inherited Create;
    Params:=TStringList.Create;

    // Get Server Variable
    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('REQUEST_METHOD',Buf,DefaultBufferSize);
       RequestMethod:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('CONTENT_LENGTH',Buf,DefaultBufferSize);
       try
          ContentLength:=StrToInt(StrPas(Buf));
       except
             ContentLength:=0;
       end;
    finally
           freeMem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('SERVER_SOFTWARE',Buf,DefaultBufferSize);
       ServerSoftware:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('SERVER_NAME',Buf,DefaultBufferSize);
       ServerName:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('GATEWAY_INTERFACE',Buf,DefaultBufferSize);
       GatewayInterface:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('SERVER_PROTOCOL',Buf,DefaultBufferSize);
       ServerProtocol:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('HTTP_ACCEPT',Buf,DefaultBufferSize);
       HttpAccept:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('SCRIPT_NAME',Buf,DefaultBufferSize);
       ScriptName:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('REMOTE_ADDR',Buf,DefaultBufferSize);
       RemoteAddr:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('REMOTE_HOST',Buf,DefaultBufferSize);
       RemoteHost:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('REMOTE_USER',Buf,DefaultBufferSize);
       RemoteUser:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    try
       GetMem(Buf,DefaultBufferSize);
       ret:=GetEnvironmentVariable('CONTENT_TYPE',Buf,DefaultBufferSize);
       ContentType:=StrPas(Buf);
    finally
           Freemem(Buf);
    end;

    if Uppercase(RequestMethod)='POST' then
       read(FInputRawData)
    else
    begin
        // Get Request Method
        try
           GetMem(Buf,DefaultBufferSize);
           ret:=GetEnvironmentVariable('QUERY_STRING',Buf,DefaultBufferSize);
           FInputRawData:=StrPas(Buf);
        finally
               Freemem(Buf);
        end;
    end;

    for idx:= 1 to ParamCount do
        Params.Add(GetParamItemName(FInputRawData,idx)+'='+GetParamItemValue(FInputRawData,idx));

end;

destructor TCgi.destroy;
begin
     Params.Free;
     inherited Destroy;
end;

function TCgi.ParamRawData:string;
begin
    Result:=FInputRawData;
end;

function TCgi.GetToken(aString, SepChar: String; TokenNum: Byte):String;
var
   Token     : String;
   StrLen    : Byte;
   TNum      : Byte;
   TEnd      : Byte;

begin
     StrLen := Length(aString);
     TNum   := 1;
     TEnd   := StrLen;
     while ((TNum <= TokenNum) and (TEnd <> 0)) do
     begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               Token := Copy(aString,1,TEnd-1);
               Delete(aString,1,TEnd);
               Inc(TNum);
          end
          else
          begin
               Token := aString;
          end;
     end;
     if TNum >= TokenNum then
     begin
          GetToken := Token;
     end
     else
     begin
          GetToken := '';
     end;
end;

function TCgi.NumToken(aString, SepChar: String):integer;
{
parameters: aString : the complete string
            SepChar : a single character used as separator
                      between the substrings
result    : the number of substrings
}

var
   RChar     : Char;
   StrLen    : integer;
   TNum      : integer;
   TEnd      : integer;

begin
     if SepChar = '#' then
     begin
          RChar := '*'
     end
     else
     begin
         RChar := '#'
     end;
     StrLen := Length(aString);
     TNum   := 0;
     TEnd   := StrLen;
     while TEnd <> 0 do
     begin
          Inc(TNum);
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               aString[TEnd] := RChar;
          end;
     end;
     NumToken := TNum;
end;

function TCgi.GetParamItemName(inpStr:string;Cnt:integer):string;
var
   tmpStr:string;
begin
     tmpStr:= GetToken(inpStr,'&',Cnt);
     result:=GetToken(tmpStr,'=',1);
end;

function TCgi.GetParamItemValue(inpStr:string;Cnt:integer):string;
var
   idx:integer;
   tmpStr,OutStr:string;
begin
     tmpStr:= GetToken(inpStr,'&',Cnt);
     tmpStr:= GetToken(tmpStr,'=',2);
     idx:=1;
     while (idx<=length(tmpStr)) do
     begin
          if tmpStr[idx]='%' then
           begin
               OutStr:=OutStr+ chr(StrToint('$'+Copy(tmpStr,idx+1,2)));
               inc(idx,3);
           end
          else
           begin
              if tmpStr[idx]='+' then
                OutStr:=OutStr+chr(32)
               else
                OutStr:=OutStr+tmpStr[idx];
              inc(idx);
           end
     end;
     result:=OutStr;
end;

function Tcgi.ParamCount:Integer;
begin
     Result:=NumToken(FInputRawData,'&');
end;

end.
