unit TomCard;
// 32 Bit CARDS.DLL Freeware VCL Component
// Ver 1.03
// By Tom Lee , Taiwan
// E-Mail Address : tom@libra.aaa.hinet.net
// Web : http://www.aaa.hinet.net/delphi

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

const
  Err1 = 'Unable to load %s ';
  Err2 = 'Resource #%d not found (%s)';
  Err3 = 'Bitmap #%d hasn''t been stored properly';

type
  TCardSuit = (csClubs,csDiamonds,csHearts,csSpades);
  TCardState = (ctFront,ctBack,ctJoker,ctO,ctX);

  TCards = class(TGraphicControl)
  private
    { Private declarations }
    FBitmap:TBitmap;
    FCardBackStyle:integer;
    FState:TCardState;
    FSuit:TCardSuit;
    FValue:integer;
    procedure LoadResBmp(Name:string;Dest:TBitmap);
    procedure LoadDLLBmp(FileName:string; BmpId:Integer; Dest:TBitmap);
    procedure SetState(value:TCardState);
    procedure SetCardBackStyle(value:integer);
    procedure SetValue(value:integer);
    procedure SetSuit(value:TCardSuit);
    procedure GetCardFromDLL;
  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    property  Canvas;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property CardBackStyle:integer read FCardBackStyle write SetCardBackStyle default 1;
    property Cursor;
    property DragMode;
    property Enabled;
    property Height;
    property Hint;
    property Left;
    property Name;
    property ShowHint;
    property State:TCardState read Fstate write SetState default ctFront ;
    property Suit:TCardSuit read FSuit write SetSuit default csClubs;
    property Tag;
    property Top;
    property Value:integer read FValue write SetValue default 1;
    property Visible;
    property Width;
    property OnClick;
    property OnDragDrop;
    property OnDblClick;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{$R TomCard.res}

procedure Register;
begin
  RegisterComponents('Samples', [TCards]);
end;

procedure TCards.LoadDLLBmp(FileName:String ; BmpId:Integer; Dest:TBitmap);
var
  Lib,rInfo,hMemory: THandle;
  rSize: Longint;
  pData: PByte;
  BmpHdr: TBitmapFileHeader;
  stream: TMemoryStream;
begin
  Lib := LoadLibrary(PChar(FileName));
  if Lib < HINSTANCE_ERROR then raise Exception.CreateFmt(Err1,['Cards.DLL']);
  { locate bitmap within library }
  rInfo := FindResource(Lib, MakeIntResource(BmpId), rt_Bitmap);
  if rInfo = 0 then raise Exception.CreateFmt(Err2,[BmpId,'FindResource']);
  { load bitmap into global memory }
  hMemory := LoadResource(Lib,rInfo);
  try
    if hMemory = 0 then raise Exception.CreateFmt(Err2,[BmpId,'LoadResource']);
    { pin down the global memory to a specific address }
    pData := LockResource(hMemory);
    try
      { find upperbound of bitmap library usage }
      rSize := SizeofResource(Lib,rInfo);
      if rSize = 0 then raise Exception.CreateFmt(Err3,[BmpId]);
      { write to a stream so we can use TBitmap.LoadFromStream }
      stream := TMemoryStream.Create;
      try
        { fake a BM header to keep LoadFromStream happy }
        BmpHdr.bfType := $4D42;
        stream.SetSize(sizeof(BmpHdr)+rSize);
        stream.Write(BmpHdr,sizeof(BmpHdr));
        stream.Write(pData^,rSize);
        stream.Seek(0,0);
        Dest.LoadFromStream(stream);
      finally
        stream.Free;
      end;
    finally
      UnlockResource(hMemory);
    end;
  finally
    FreeResource(hMemory);
  end;
end;

constructor TCards.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     Width:=30;
     Height:=30;
     FState:=ctFront ;
     FCardBackStyle:=1;
     FValue:=1;
     FSuit:=csClubs;
     FBitmap:=TBitmap.Create;
end;

procedure TCards.SetState(value:TCardState);
var
   ID:integer;
begin
     if value<>FState then
     begin
          FState:=value;
          Invalidate;
     end;
end;

procedure TCards.SetCardBackStyle(value:integer);
begin
     if (value>13) or (value<1) then exit;
     if value<>FCardBackStyle then
     begin
          FCardBackStyle:=value;
          Invalidate;
     end;
end;

procedure TCards.SetValue(value:integer);
begin
     if (value>13) or (value<1) then exit;
     if value<>FValue then
     begin
          FValue:=value;
          Invalidate;
     end;
end;

procedure TCards.SetSuit(value:TCardSuit);
begin
     if value<>FSuit then
     begin
          FSuit:=value;
          Invalidate;
     end;
end;

Procedure TCards.GetCardFromDLL;
var
   Id:integer;
begin
     if FState =  ctJoker then
        LoadResBmp('JOKER',FBitmap)
     else
     begin
        case FState of
            ctFront:
                ID:=FValue+Ord(FSuit)*13;
            ctBack:
                ID:=52+FCardBackStyle;
            ctO:
                ID:=68;
            ctX:
                ID:=67;
         end;
         LoadDLLBmp('Cards.DLL',ID,FBitmap);
     end;
end;

Procedure TCards.Paint;
begin
     inherited;

     GetCardFromDLL;
     With Canvas do
     begin
          Draw(0,0,FBitmap);
          MoveTo(1,0);
	      Pen.Color:=clBlack;
          LineTo(Width-1,0);
          LineTo(Width-1,1);
          LineTo(Width-1,Height-1);
          LineTo(Width-1,Height-1);
          LineTo(1,Height-1);
          LineTo(0,Height-1);
          LineTo(0,1);
          LineTo(1,0);
	      Pixels[1,1]:=clBlack;
 	      Pixels[1,Height-2]:=clBlack;
          Pixels[Width-2,1]:=clBlack;
          Pixels[Width-2,Height-2]:=clBlack;
          Pixels[0,0]:=TForm(Parent).Color;
          Pixels[0,Height-1]:=TForm(Parent).Color;
          Pixels[Width-1,0]:=TForm(Parent).Color;
	      Pixels[Width-1,Height-1]:=TForm(Parent).Color;
     end;
     Width:=FBitmap.Width;
     Height:=FBitmap.Height;
end;

destructor TCards.Destroy;
begin
     FBitmap.Free;
     inherited Destroy;
end;

procedure TCards.LoadResBmp(Name:string;Dest:TBitmap);
var
  HResInfo: THandle;
  BMF: TBitmapFileHeader;
  MemHandle: THandle;
  Stream: TMemoryStream;
  ResPtr: PByte;
  ResSize: Longint;
begin
  BMF.bfType := $4D42;
  HResInfo := FindResource(HInstance,PChar(Name),RT_Bitmap);
  ResSize := SizeofResource(HInstance, HResInfo);
  MemHandle := LoadResource(HInstance, HResInfo);
  ResPtr := LockResource(MemHandle);
  Stream := TMemoryStream.Create;
  Stream.SetSize(ResSize + SizeOf(BMF));
  Stream.Write(BMF, SizeOf(BMF));
  Stream.Write(ResPtr^, ResSize);
  FreeResource(MemHandle);
  Stream.Seek(0, 0);
  Dest.LoadFromStream(Stream);
  Stream.Free;
end;

end.
