{ Mutex object component
  all rights reserved by Troels S Eriksen - email: TSEriksen@cyberdude.com

  rev. 01 - object written
  
}

{ properties:
  identifier - unique name identifing this mutex for the system
  timeout    - the time an application should wait before executing Access denied
  
  events:
  CriticalSection - The system specific critical section, only one appl. can be here at a time
  AccessDenied	- Non-critical section to perform instead when timeout occurs

  methods:
  Execute - Executes the CriticalSection-event or if another instance / thread is doing 
            that, the AccessDenied-event instead.
}

unit Mutex;

interface

uses
  Windows, Messages, Classes, Controls, Forms;

type
  TMutex = Class(TComponent)
  private
    FIdentifier : string;
    FTimeout    : integer;
    FCriticalSection : TNotifyEvent;
    FAccessDenied : TNotifyEvent;
    procedure SetIdentifier(value:string);
    function GetIdentifier:string;
  protected
  public
    constructor Create(AnOwner:TComponent); override;
    procedure Free;
    procedure Execute;
  published
    property Identifier : string read GetIdentifier write SetIdentifier;
    property TimeOut : integer read FTimeout write FTimeout;
    property CriticalSection : TNotifyEvent read FCriticalSection write FCriticalSection;
    property AccessDenied : TNotifyEvent read FAccessDenied write FAccessDenied;
  end;

procedure Register;

implementation
uses
  SysUtils;

constructor TMutex.Create(AnOwner:TComponent);
begin
  inherited ;
  Timeout   :=5000;
end;

procedure TMutex.Free;
begin
  inherited ;
end;

procedure TMutex.SetIdentifier(value:string);
begin
  if value='' then value:=application.title+'_'+name;
  FIdentifier:=Value;
end;

function TMutex.GetIdentifier:string;
begin
  if FIdentifier='' then FIdentifier:=application.title+'_'+name;
  Result:=FIdentifier;
end;

procedure TMutex.Execute;
var
  Handle : THandle;
  Ident  : Array[0..99] of char;
begin
  try
    StrPCopy(Ident,FIdentifier);
    handle:=CreateMutex(NIL,FALSE,Ident);
    case WaitForSingleObject(handle,FTimeout)=WAIT_TIMEOUT of
      true : if assigned(FAccessDenied) then FAccessDenied(self);
      false: if assigned(FCriticalSection) then FCriticalSection(Self);
    end;
  finally
    ReleaseMutex(handle);
    CloseHandle(handle);
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TMutex]);
end;

end.
