unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, msOffice, Buttons;

type
  TForm1 = class(TForm)
    GridToExcel1: TGridToExcel;
    ExportButton: TButton;
    StringGrid1: TStringGrid;
    CloseButton: TBitBtn;
    MemoToword1: TMemoToword;
    Memo1: TMemo;
    Export2Button: TButton;
    Close2Button: TButton;
    Save2Button: TButton;
    SaveButton: TButton;
    procedure FormShow(Sender: TObject);
    procedure ExportButtonClick(Sender: TObject);
    procedure GridToExcel1Open(Sender: TObject);
    procedure GridToExcel1Error(Sender: TObject; piErrNo: Integer;
      psErrMsg: String);
    procedure Export2ButtonClick(Sender: TObject);
    procedure MemoToword1Open(Sender: TObject);
    procedure GridToExcel1Quit(Sender: TObject);
    procedure MemoToword1Quit(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure Save2ButtonClick(Sender: TObject);
    procedure Close2ButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
var li_col, li_row: LongInt;
begin
   for li_row := 0 to StringGrid1.rowCount-1 do
      for li_col := 0 to StringGrid1.ColCount-1 do
          StringGrid1.Cells[li_col, li_row] := 'Cells' + inttostr(li_col) + inttostr(li_row);
end;

procedure TForm1.ExportButtonClick(Sender: TObject);
begin
   GridToExcel1.Open;
   GridToExcel1.Exportdata;
   SaveButton.Enabled := True;
   CloseButton.Enabled := True;
end;

procedure TForm1.GridToExcel1Open(Sender: TObject);
begin
//   showmessage('Open OK');
end;

procedure TForm1.GridToExcel1Error(Sender: TObject; piErrNo: Integer;
  psErrMsg: String);
begin
   showmessage(psErrMsg);
end;

procedure TForm1.Export2ButtonClick(Sender: TObject);
begin
   MemoToword1.Open;
   MemoToword1.Exportdata;
   Save2Button.Enabled := True;
   Close2Button.Enabled := True;
end;

procedure TForm1.MemoToword1Open(Sender: TObject);
begin
//   showmessage('Opened');
end;

procedure TForm1.GridToExcel1Quit(Sender: TObject);
begin
     showmessage('excel closed');
end;

procedure TForm1.MemoToword1Quit(Sender: TObject);
begin
     showmessage('Word closed');
end;

procedure TForm1.SaveButtonClick(Sender: TObject);
var lo_SaveDlg : TSaveDialog;
begin
    lo_SaveDlg := TSaveDialog.Create(Application);
         if lo_SaveDlg.Execute then
             GridToExcel1.Save(lo_SaveDlg.Filename);
    lo_SaveDlg.Free;
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
    GridToExcel1.Close;
end;

procedure TForm1.Save2ButtonClick(Sender: TObject);
var lo_SaveDlg : TSaveDialog;
begin
    lo_SaveDlg := TSaveDialog.Create(Application);
         if lo_SaveDlg.Execute then
             MemoToword1.Save(lo_SaveDlg.Filename);
    lo_SaveDlg.Free;

end;

procedure TForm1.Close2ButtonClick(Sender: TObject);
begin
    MemoToword1.Close;
end;

end.
