(******************************************************************************
 * TACLogFile                                                                 *
 *                                                                            *
 * Versione 1.0 23/11/1997                                                    *
 *   Questo componente permette di scrivere su di un file di testo la stringa *
 *   assegnata al campo "LogText"                                             *
 *   Se la propriet "DeleteOnChangeName"  True quando si cambia nome il     *
 *   nuovo file verr eliminato                                               *
 *                                                                            *
 * Autore: Andrea Creola                                                      *
 *         Via Marconi, 30                                                    *
 *         28010 Gargallo (NO)                                                *
 *         Italy                                                              *
 *         a.creola@mythos.it                                                 *
 ******************************************************************************)
unit TLog;

(******************************************************************************
 * Interface                                                                  *
 ******************************************************************************)
interface

(******************************************************************************
 * Uses                                                                       *
 ******************************************************************************)
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DsgnIntf;

(******************************************************************************
 * Type                                                                       *
 ******************************************************************************)
type
  TACFileLog = class(TComponent)
  private
    FDelete:Boolean;(* Quando ottiene il nome indica se deve cancellare *)
                    (* il file                                          *)
    FName : String; (* Nome del file *)
    LastLogTxt : String; (* Ultima stringa inserita *)
    FEnabled   : Boolean; (* Indica se la scrittura su file  abilitata oppure no *)
    { Private declarations }
  protected
    { Protected declarations }
    Procedure Set_FName(nome:String);
    Procedure put_log_txt(txt:string);
  public
    constructor Create(AOwner: TComponent);override;
    destructor Destroy;override;
    { Public declarations }
  published
    { Published declarations }
    property DeleteOnChangeName : Boolean Read FDelete Write FDelete;
    property FileName : String Read Fname Write Set_Fname;
    property LogText : String Read LastLogTxt Write put_log_txt;
    property Enabled : Boolean Read FEnabled Write FEnabled;
  end;

(******************************************************************************
 * Register                                                                   *
 ******************************************************************************)
procedure Register;

(******************************************************************************
 * Implementation                                                             *
 ******************************************************************************)
implementation

(******************************************************************************
 * Put_Log_Txt                                                                *
 ******************************************************************************)
procedure TACFileLog.put_log_txt(txt:string);
var f : Text;
begin
(*$i-*)
  if (FileName<>'') And (Enabled) then
  begin
    AssignFile(F,FileName);
    if (FileExists(FileName)=True) Then Append(F)
    else ReWrite(F);
    WriteLn(F,Txt);
    Close(F);
    LastLogTxt := txt;
  End;
(*$i+*)
end;
(******************************************************************************
 * Set_F_Name                                                                 *
 ******************************************************************************)
Procedure TACFileLog.Set_FName(nome:String);
Begin
  FName := nome;
(*$i-*)
  if(FDelete=True)Then
  Begin
    DeleteFile(FileName);
  End;
(*$i+*)
End;
(******************************************************************************
 * Constructor                                                                *
 ******************************************************************************)
constructor TACFileLog.Create(AOwner: TComponent);
Begin
  Inherited;
  FileName := '';
  LastLogTxt := '';
  DeleteOnChangeName := True;
  Enabled := True;
End;

(******************************************************************************
 * destructor                                                                 *
 ******************************************************************************)
destructor TACFileLog.Destroy;
Begin
 Inherited;
End;
(******************************************************************************
 * Register                                                                   *
 ******************************************************************************)
procedure Register;
begin
  RegisterComponents('Samples', [TACFileLog]);
end;

end.
