unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Keyboard;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    KeyIH: TKeyboard;
    KeyIM: TKeyboard;
    KeyFH: TKeyboard;
    KeyFM: TKeyboard;
    ComboBoxSEL1: TComboBox;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    KeyboardABC: TKeyboard;
    Keyboard1: TKeyboard;
    Keyboard2: TKeyboard;
    KeyPet: TKeyboard;
    ComboBoxSEL2: TComboBox;
    ComboBoxRANGE: TComboBox;
    Label4: TLabel;
    procedure ComboBoxRANGEChange(Sender: TObject);
    procedure ComboBoxSEL1Change(Sender: TObject);
    procedure ComboBoxSEL2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ComboBoxRANGEChange(Sender: TObject);
var i, ih, fh, im, fm, nValue: integer;

begin
  case ComboBoxRANGE.ItemIndex of
    0: begin               { F r e e }
         ih := 0;
         fh := 99;
         im := 0;
         fm := 99;
       end;
    1: begin               {08.00 -> 09.50}
         ih := 8;
         fh := 9;
         im := 0;
         fm := 50;
       end;
    2: begin               {10.10 -> 12.10}
         ih := 10;
         fh := 12;
         im := 10;
         fm := 10;
       end;
  end;

  for i := KeyIH.KeyCaptions.Count-1 downto 0 do
    KeyIH.Down(i, False);
  for i := KeyFH.KeyCaptions.Count-1 downto 0 do
    KeyFH.Down(i, False);
  for i := KeyIM.KeyCaptions.Count-1 downto 0 do
    KeyIM.Down(i, False);
  for i := KeyFM.KeyCaptions.Count-1 downto 0 do
    KeyFM.Down(i, False);

  with KeyIH do
    for i := KeyCaptions.Count-1 downto 0 do begin
      Enable(i, True);
      nValue := StrToInt(KeyCaptions.Strings[i]);
      if (nValue < ih) or (nValue > fh ) then
        Enable(i, False);
      if nValue = ih then
        Down(i, True);
    end;

  with KeyFH do
    for i := KeyCaptions.Count-1 downto 0 do begin
      Enable(i, True);
      nValue := StrToInt(KeyCaptions.Strings[i]);
      if (nValue < ih) or (nValue > fh ) then
        Enable(i, False);
      if nValue = fh then
        Down(i, True);
    end;

end;



procedure TForm1.ComboBoxSEL1Change(Sender: TObject);
var i, ih, fh, im, fm, nValue: integer;

begin
  case ComboBoxSEL1.ItemIndex of
    0: begin               { N o n e }
         ih := 0;
         fh := 0;
         im := 0;
         fm := 0;
       end;
    1: begin               {08.00 -> 09.50}
         ih := 8;
         fh := 9;
         im := 0;
         fm := 50;
       end;
    2: begin               {10.10 -> 12.10}
         ih := 10;
         fh := 12;
         im := 10;
         fm := 10;
       end;
  end;

  for i := KeyIH.KeyCaptions.Count-1 downto 0 do
    KeyIH.Enable(i, True);
  for i := KeyFH.KeyCaptions.Count-1 downto 0 do
    KeyFH.Enable(i, True);

  with KeyIH do begin
    for i := KeyCaptions.Count-1 downto 0 do begin
      Down(i, False);
      nValue := StrToInt(KeyCaptions.Strings[i]);
      if nValue = ih then begin
        Down(i, True);
        Break;
      end;
    end;
  end;

  with KeyFH do begin
    for i := KeyCaptions.Count-1 downto 0 do begin
      Down(i, False);
      nValue := StrToInt(KeyCaptions.Strings[i]);
      if nValue = fh then begin
        Down(i, True);
        Break;
      end;
    end;
  end;

  with KeyIM do begin
    for i := KeyCaptions.Count-1 downto 0 do begin
      Down(i, False);
      if StrToInt(KeyCaptions.Strings[i]) = im then begin
        Down(i, True);
        Break;
      end;
    end;
  end;

  with KeyFM do begin
    for i := KeyCaptions.Count-1 downto 0 do begin
      Down(i, False);
      if StrToInt(KeyCaptions.Strings[i]) = fm then begin
        Down(i, True);
        Break;
      end;
    end;
  end;

end;


procedure TForm1.ComboBoxSEL2Change(Sender: TObject);
var i: integer;
begin
  with KeyPet do begin

    for i := KeyCaptions.Count-1 downto 0 do begin
      Down(i, False);
      Enable(i, True);
    end;

    case ComboBoxSEL2.ItemIndex of
    1: begin               { Dog }
         Down(0, True);
       end;
    2: begin               { Cat }
         Down(1, True);
       end;
    3: begin               { Mouse }
         Down(2, True);
       end;
    4: begin               { Dog only}
         Down(0, True);
         Enable(1, False);
         Enable(2, False);
       end;
    5: begin               { Cat only }
         Down(1, True);
         Enable(0, False);
         Enable(2, False);
       end;
    6: begin               { Mouse only }
         Down(2, True);
         Enable(0, False);
         Enable(1, False);
       end;
    end;
  end;
end;

end.
