{$A+}

LIBRARY DBArtikel;

USES  Windows,
  SysUtils,
  IsapiConn,
  IsapiVars,
  DBTables,
  DB,
  BDE;

TYPE  TIsapiTable = CLASS(TTable)
        FKategorie : STRING[40];
        FLand      : STRING[40];
        FRegion    : STRING[40];

        PROCEDURE FilterKL(DataSet : TDataSet; VAR Accept : BOOLEAN);
        PROCEDURE FilterKLR(DataSet : TDataSet; VAR Accept : BOOLEAN);
        PROCEDURE FilterArtikel(DataSet : TDataSet; VAR Accept : BOOLEAN);
      END;

{--- Database Filtering ------------------------------------}
  PROCEDURE TIsapiTable.FilterArtikel(DataSet : TDataSet; VAR Accept : BOOLEAN);
  BEGIN
    Accept := TRUE;
    IF FKategorie <> '' THEN Accept := Accept AND (UpperCase(DataSet['Kategorie']) = UpperCase(FKategorie));
    IF FLand      <> '' THEN Accept := Accept AND (UpperCase(DataSet['Land'])      = UpperCase(FLand));
    IF FRegion    <> '' THEN Accept := Accept AND (UpperCase(DataSet['Region'])    = UpperCase(FRegion));
  END;

  PROCEDURE TIsapiTable.FilterKL(DataSet : TDataSet; VAR Accept : BOOLEAN);
  BEGIN
    Accept := (UpperCase(DataSet['Kategorie']) = UpperCase(FKategorie)) AND
              (UpperCase(DataSet['Land']) <> 'N/A');
  END;

  PROCEDURE TIsapiTable.FilterKLR(DataSet : TDataSet; VAR Accept : BOOLEAN);
  BEGIN
    Accept := (UpperCase(DataSet['Kategorie']) = UpperCase(FKategorie)) AND
              (UpperCase(DataSet['Land']) = UpperCase(FLand)) AND
              (UpperCase(DataSet['Region']) <> 'N/A');
  END;
{---------------------------------------------------------------------}


FUNCTION GetExtensionVersion (VAR VerInfo : TVerInfo) : BOOL; EXPORT; STDCALL;
BEGIN
  VerInfo.ExtensionVersion := MAKELONG(HSE_VERSION_MINOR,HSE_VERSION_MAJOR);
  StrPCopy( VerInfo.ExtensionDesc,'Delphi 2.0 ISAPI Extension');
  Result := TRUE;
END;

FUNCTION HttpExtensionProc(ECB : PECB) : CARDINAL; EXPORT; STDCALL;
CONST
  FilesPath = 'C:\IISERVER\SCRIPTS\ARTIKEL\';

  getKat    = 'GETKAT';
  getLand   = 'GETLAND';
  getRegion = 'GETREGION';
  getWein   = 'GETWEIN';
  getArt    = 'GETART';

  trKategorie = '%KAT%';
  trLand      = '%LAND%';
  trRegion    = '%REG%';

  WithHTML    = TRUE;
  WithoutHTML = FALSE;

  bRedirect    = TRUE;
  bNoRedirect  = FALSE;

VAR
  WebConn      : TIsapiConn;
  tblQuery     : TIsapiTable;
  sesQuery     : TSession;
  Count        : INTEGER;
  Redirect     : BOOLEAN;

  {--- Parses a HTML File for placeholders and sends then the lines with filled in data -----}
  PROCEDURE SendParsedRedirectFile(ISAPIDataSet : TIsapiTable; FileName : STRING; VAR redir : BOOLEAN);
  VAR Line    : STRING;
      f       : TextFile;

      PROCEDURE Parse;
      VAR s       : STRING;
          v       : STRING[40];

      BEGIN
        TRY
          IF Line <> '' THEN BEGIN
            IF NOT redir THEN BEGIN
              IF Pos('%REDIRECT%',Line) = 0 THEN WebConn.Send(Line)
                                            ELSE redir := bRedirect;
            END ELSE
            BEGIN
              IF Pos('%',Line) <> 0 THEN BEGIN
                s := '';
                WHILE Pos('%',Line) <> 0 DO BEGIN
                  IF (Length(s)+Length(Copy(Line,1,Pos('%',Line)-1))) > 255 THEN BEGIN
                    WebConn.Send(s);
                    s := '';
                  END;
                  s := s+Copy(Line,1,Pos('%',Line)-1);
                  Delete(Line,1,Pos('%',Line));
                  v := UpperCase('%'+Copy(Line,1,Pos('%',Line)));
                  Delete(Line,1,Pos('%',Line));
                 {--- Field Vars ---------------------------------------------}
                  IF v = trKategorie THEN s := s+ISAPIDataSet.FKategorie ELSE
                  IF v = trLand THEN s := s+ISAPIDataSet.FLand ELSE
                  IF v = trRegion THEN s := s+ISAPIDataSet.FRegion ELSE
                 {--- AppName Var ---------------------------------------------}
                  IF v = tvAppName THEN BEGIN
                    IF (Length(s)+Length(WebConn.AppName)) > 255 THEN BEGIN
                      WebConn.Send(s);
                      s := '';
                    END;
                    s := s+WebConn.AppName;
                 {--- ServerName Var ------------------------------------------}
                  END ELSE IF v = tvServer THEN BEGIN
                    IF (Length(s)+Length(WebConn.Server)) > 255 THEN BEGIN
                      WebConn.Send(s);
                      s := '';
                    END;
                    s := s+WebConn.Server;
                {--- ScriptPath Var ------------------------------------------}
                  END ELSE IF v = tvScriptPath THEN BEGIN
                    IF (Length(s)+Length(WebConn.ScriptPath)) > 255 THEN BEGIN
                      WebConn.Send(s);
                      s := '';
                    END;
                    s := s+WebConn.ScriptPath;
                {--- LocalPath Var ------------------------------------------}
                  END ELSE IF v = tvLocalPath THEN BEGIN
                    IF (Length(s)+Length(WebConn.LocalPath)) > 255 THEN BEGIN
                      WebConn.Send(s);
                      s := '';
                    END;
                    s := s+WebConn.LocalPath;
                  END;
                END;
              END;
              IF (Length(s)+Length(Line)) > 255 THEN BEGIN
                WebConn.Send(s);
                s := '';
              END;
              s := s+Line;
              IF s <> '' THEN WebConn.Send(s);
              s := '';
            END;
          END;
        EXCEPT
          ON e : EXCEPTION DO Raise;
        END;
      END;

  BEGIN
    TRY
      TRY
        AssignFile(f,FileName);
        Reset(f);
        redir := bNoRedirect;
        WHILE NOT EOF(f) DO BEGIN
          ReadLn(f,Line);
          Parse;
        END;
      FINALLY
        CloseFile(f);
      END;
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;


  {-----------------------------------------------}
  { Very important for Database-Handling!!!!!!!   }
  {-----------------------------------------------}

  FUNCTION MakeSession: TSession;
  VAR SessionName : STRING;
  BEGIN
    SessionName := 'DBArtikel'+IntToStr(GetCurrentThreadID);
    Result := Sessions.OpenSession(SessionName);
  END;
  {-----------------------------------------------}



  PROCEDURE GetWeinList(wHTML : BOOLEAN);
  BEGIN
    TRY
      tblQuery.FKategorie := WebConn.ExtractFromQuery('KAT');
      tblQuery.FLand := WebConn.ExtractFromQuery('LAND');
      tblQuery.FRegion := WebConn.ExtractFromQuery('GEBIET');
      tblQuery.TableName := FilesPath+'ARTIKEL.DB';
      tblQuery.IndexName := 'IndxBez';
      tblQuery.OnFilterRecord := tblQuery.FilterArtikel;
      tblQuery.Open;
      tblQuery.Filtered := TRUE;
      tblQuery.Refresh;
      IF wHTML THEN WebConn.SendHTMLFile(FilesPath+'GWEINH.HTM');
      Count := 0;
      IF NOT tblQuery.EOF THEN BEGIN
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GWEINDBH.HTM');
        WHILE NOT tblQuery.EOF DO BEGIN
          WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GWEINDB.HTM');
          tblQuery.Next;
          Inc(Count);
        END;
        tblQuery.First;
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GWEINDBF.HTM');
      END;
      IF Count = 0 THEN WebConn.SendHTMLFile(FilesPath+'NOWEIN.HTM');
      tblQuery.Filtered := FALSE;
      IF wHTML THEN WebConn.SendHTMLFile(FilesPath+'GWEINF.HTM');
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;

  PROCEDURE GetKatList;
  BEGIN
    TRY
      tblQuery.TableName := FilesPath+'KAT.DB';
      tblQuery.Open;
      WebConn.SendHTMLFile(FilesPath+'GKATH.HTM');
      Count := 0;
      IF NOT tblQuery.EOF THEN BEGIN
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GKATDBH.HTM');
        WHILE NOT tblQuery.EOF DO BEGIN
          WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GKATDB.HTM');
          tblQuery.Next;
          Inc(Count);
        END;
        tblQuery.First;
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GKATDBF.HTM');
      END;
      tblQuery.Close;
      IF Count = 0 THEN WebConn.SendHTMLFile(FilesPath+'NOKAT.HTM');
      WebConn.SendHTMLFile(FilesPath+'GKATF.HTM');
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;

  PROCEDURE GetLandList;
  BEGIN
    TRY
      tblQuery.FKategorie := WebConn.ExtractFromQuery('KAT');
      tblQuery.FLand := '';
      tblQuery.FRegion := '';
      tblQuery.TableName := FilesPath+'KL.DB';
      tblQuery.IndexName := 'IndxLand';
      tblQuery.OnFilterRecord := tblQuery.FilterKL;
      tblQuery.Open;
      tblQuery.Filtered := TRUE;
      tblQuery.Refresh;
      WebConn.SendHTMLFile(FilesPath+'GLANDH.HTM');
      Count := 0;
      IF NOT tblQuery.EOF THEN BEGIN
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GLANDDBH.HTM');
        WHILE NOT tblQuery.EOF DO BEGIN
          WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GLANDDB.HTM');
          tblQuery.Next;
          Inc(Count);
        END;
        tblQuery.First;
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GLANDDBF.HTM');
      END;
      tblQuery.Filtered := FALSE;
      tblQuery.Close;
      IF Count = 0 THEN BEGIN
        SendParsedRedirectFile(tblQuery, FilesPath+'NOLAND.HTM',Redirect);
        IF NOT Redirect THEN GetWeinList(WithoutHTML);
      END;
      WebConn.SendHTMLFile(FilesPath+'GLANDF.HTM');
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;

  PROCEDURE GetRegionList;
  BEGIN
    TRY
      tblQuery.FKategorie := WebConn.ExtractFromQuery('KAT');
      tblQuery.FLand := WebConn.ExtractFromQuery('LAND');
      tblQuery.FRegion := '';
      tblQuery.TableName := FilesPath+'KLR.DB';
      tblQuery.IndexName := 'IndxRegion';
      tblQuery.OnFilterRecord := tblQuery.FilterKLR;
      tblQuery.Open;
      tblQuery.Filtered := TRUE;
      tblQuery.Refresh;
      WebConn.SendHTMLFile(FilesPath+'GREGH.HTM');
      Count := 0;
      IF NOT tblQuery.EOF THEN BEGIN
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GREGDBH.HTM');
        WHILE NOT tblQuery.EOF DO BEGIN
          WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GREGDB.HTM');
          tblQuery.Next;
          Inc(Count);
        END;
        tblQuery.First;
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GREGDBF.HTM');
      END;
      tblQuery.Close;
      IF Count = 0 THEN BEGIN
        SendParsedRedirectFile(tblQuery, FilesPath+'NOREG.HTM',Redirect);
        IF NOT Redirect THEN GetWeinList(WithoutHTML);
      END;
      WebConn.SendHTMLFile(FilesPath+'GREGF.HTM');
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;

  PROCEDURE GetArtikel;
  VAR ID : LONGINT;
      Code : INTEGER;
  BEGIN
    TRY
      Val(WebConn.ExtractFromQuery('ID'),ID,Code);
      tblQuery.TableName := FilesPath+'ARTIKEL.DB';
      tblQuery.Open;
      WebConn.SendHTMLFile(FilesPath+'GARTH.HTM');
      IF tblQuery.Locate('Index',ID,[loCaseInsensitive]) THEN
        WebConn.SendParsedTemplateFile(tblQuery,FilesPath+'GARTDB.HTM')
      ELSE
        WebConn.SendHTMLFile(FilesPath+'NOART.HTM');
      WebConn.SendHTMLFile(FilesPath+'GARTF.HTM');
    EXCEPT
      ON e : EXCEPTION DO Raise;
    END;
  END;

  PROCEDURE SendErrorMessage(MSG : STRING);
  BEGIN
    WebConn.Send('<BR><BR><FONT FACE="Arial" SIZE=8>Error: '+MSG+'</FONT><BR><BR>');
  END;
{-------------------------------------------------------------------}
{--- Main begin ----------------------------------------------------}
{-------------------------------------------------------------------}

BEGIN
  WebConn := TIsapiConn.Create(ECB, 30000);
  IF WebConn.Status = eOK THEN
  BEGIN
    WebConn.AppName    := 'dbartikel.dll';
    WebConn.Server     := 'www.iag.ch';
    WebConn.ScriptPath := 'scripts/artikel/';
    WebConn.LocalPath  := FilesPath;
    WebConn.FilterOn   := True;
    WebConn.SendHeader;
    TRY
      TRY
        sesQuery   := MakeSession;
        tblQuery := TIsapiTable.Create(NIL);
        tblQuery.SessionName := sesQuery.Name;
        {------------------------------------------------}
        {--- Liste Kategorien ---------------------------}
        IF WebConn.ExtractFromQuery('MTH') = getKat THEN GetKatList
        {--- Liste Lnder mit Kategorie -----------------}
        ELSE IF WebConn.ExtractFromQuery('MTH') = getLand THEN GetLandList
        {--- Liste Regionen mit Land und Kategorie ------}
        ELSE IF WebConn.ExtractFromQuery('MTH') = getRegion THEN GetRegionList
        {--- Liste Weine ------}
        ELSE IF WebConn.ExtractFromQuery('MTH') = getWein THEN GetWeinList(withHTML)
        {--- Artikel Anzeige ------}
        ELSE IF WebConn.ExtractFromQuery('MTH') = getArt THEN GetArtikel
        ELSE SendErrorMessage('Function not supported!');
        {------------------------------------------------}
        {------------------------------------------------}
      FINALLY
        tblQuery.Close;
        tblQuery.Free;
        sesQuery.Close;
        sesQuery.Free;
      END;
    EXCEPT
      ON e : EXCEPTION DO BEGIN
               SendErrorMessage(e.Message);
             END;
    END;
  END;
  Result := WebConn.Result;
  WebConn.Free;
END;

EXPORTS
  HttpExtensionProc,
  GetExtensionVersion;
END.
