
{*******************************************************}
{                                                       }
{       Delphi ISAPI Interface                          }
{       Version 1.0 HTTP Server Extension interface.    }
{                                                       }
{       Copyright (c) 1996 Borland International        }
{                                                       }
{*******************************************************}


UNIT IsapiVars;

INTERFACE

USES Windows;

CONST
  HSE_VERSION_MAJOR         =   1;      // major version of this spec
  HSE_VERSION_MINOR         =   0;      // minor version of this spec
  HSE_LOG_BUFFER_LEN        =  80;
  HSE_MAX_EXT_DLL_NAME_LEN  = 256;

TYPE
  HCONN = THandle;

// the following are the status codes returned by the Extension DLL

CONST
  HSE_STATUS_SUCCESS                      = 1;
  HSE_STATUS_SUCCESS_AND_KEEP_CONN        = 2;
  HSE_STATUS_PENDING                      = 3;
  HSE_STATUS_ERROR                        = 4;

// The following are the values to request services with the ServerSupportFunction.
//  Values from 0 to 1000 are reserved for future versions of the interface

  HSE_REQ_BASE                             = 0;
  HSE_REQ_SEND_URL_REDIRECT_RESP           = ( HSE_REQ_BASE + 1 );
  HSE_REQ_SEND_URL                         = ( HSE_REQ_BASE + 2 );
  HSE_REQ_SEND_RESPONSE_HEADER             = ( HSE_REQ_BASE + 3 );
  HSE_REQ_DONE_WITH_SESSION                = ( HSE_REQ_BASE + 4 );
  HSE_REQ_END_RESERVED                     = 1000;

//
//  These are Microsoft specific extensions
//

  HSE_REQ_MAP_URL_TO_PATH                  = (HSE_REQ_END_RESERVED+1);
  HSE_REQ_GET_SSPI_INFO                    = (HSE_REQ_END_RESERVED+2);


//
// passed to GetExtensionVersion
//

TYPE
  PVerInfo = ^TVerInfo;
  TVerInfo = PACKED RECORD
               ExtensionVersion : DWORD;
               ExtensionDesc : ARRAY [0..HSE_MAX_EXT_DLL_NAME_LEN-1] OF Char;
             END;

TYPE
  TGetServerVariableProc = FUNCTION ( hConn: HCONN;
                                      VariableName: PCHAR;
				      Buffer: POINTER;
                                      VAR Size: DWORD ): BOOL STDCALL;

  TWriteClientProc = FUNCTION ( ConnID: HCONN;
                                Buffer: Pointer;
                                VAR Bytes: DWORD;
                                dwReserved: DWORD ): BOOL STDCALL;

  TReadClientProc  = FUNCTION ( ConnID: HCONN;
                                Buffer: Pointer;
                                VAR Size: DWORD ): BOOL STDCALL;

  TServerSupportFunctionProc = FUNCTION ( hConn: HCONN;
                                          HSERRequest: DWORD;
                                          Buffer: Pointer;
                                          Size : POINTER;
                                          DataType: POINTER): BOOL STDCALL;

//
// passed to extension procedure on a new request
//
TYPE

  PECB = ^TECB;
  TECB = PACKED RECORD
           cbSize    : DWORD;              // size of this struct.
           dwVersion : DWORD;              // version info of this spec
           ConnID: HCONN;                  // Context number not to be modified!
           dwHttpStatusCode   : DWORD;     // HTTP Status code
                                           // null terminated log info specific to this Extension DLL
           lpszLogData        : ARRAY [0..HSE_LOG_BUFFER_LEN-1] OF Char;
           lpszMethod         : PChar;     // REQUEST_METHOD
           lpszQueryString    : PChar;     // QUERY_STRING
           lpszPathInfo       : PChar;     // PATH_INFO
           lpszPathTranslated : PChar;     // PATH_TRANSLATED
           cbTotalBytes       : DWORD;     // Total bytes indicated from client
           cbAvailable        : DWORD;     // Available number of bytes
           lpbData            : Pointer;   // pointer to cbAvailable bytes
           lpszContentType    : PChar;     // Content type of client data

           GetServerVariable     : TGetServerVariableProc;
           WriteClient           : TWriteClientProc;
           ReadClient            : TReadClientProc;
           ServerSupportFunction : TServerSupportFunctionProc;
         END;

//
//  these are the prototypes that must be exported from the extension DLL
//

//  function GetExtensionVersion( var Ver: THSE_VERSION_INFO ): BOOL; stdcall;
//  function HttpExtensionProc( var ECB: TEXTENSION_CONTROL_BLOCK ): DWORD; stdcall;

// the following type declarations is for the server side

// typedef BOOL  (WINAPI * PFN_GETEXTENSIONVERSION)( HSE_VERSION_INFO  *pVer );
// typedef DWORD (WINAPI * PFN_HTTPEXTENSIONPROC )( EXTENSION_CONTROL_BLOCK *pECB );

IMPLEMENTATION

END.

