{#######################################################################################}
{#                                                                                     #}
{#   TIsapiConn is a small Unit that allows to recieve and send Data trough the        #}
{#   ISAPI interface to IIS from Microsoft.                                            #}
{#                                                                                     #}
{#   This Unit is usefull for small ISAPI Applications with or without Database        #}
{#   Connectivity. For bigger Projects use instead WebSbt from Steven Genusa           #}
{#                                                                                     #}
{#     http://rampages.onramp.net/~steveg/                                             #}
{#                                                                                     #}
{#   Not all features are implemented yet, but you can add other features without      #}
{#   problems, for further information read the Doc's.                                 #}
{#                                                                                     #}
{#   TIsapiConn V1.01.00  (c) 1996 Ivan Magrini (Last modification 21.2.1997)          #}
{#                                                                                     #}
{#   For bugs and sugestions mail me at imagrini@iag.ch                                #}
{#                                                                                     #}
{#   This unit is released to PD, you are free to use it as you like                   #}
{#                                                                                     #}
{#   Please do not remove this Header!                                                 #}
{#                                                                                     #}
{#                                                                                     #}
{#   This unit was built after studying the ISAPI Components from Steven Genusa        #}
{#   (WebSbt) and Bill Chosiad (TIsapi, Acadians software), they did a real good       #}
{#   work!!!!!!                                                                        #}
{#                                                                                     #}
{#   PS: If you don't need Database Support, use the ISAPIConn Unit                    #}
{#                                                                                     #}
{#       If you like to work with Tables and Filters, no problem!                      #}
{#       You should define an descendent of TTable like this:                          #}
{#                                                                                     #}
{#                                                                                     #}
{#    USES  Windows, SysUtils, IsapiConn, IsapiVars, DBTables, DB, BDE, StrConv;       #}
{#                                                                                     #}
{#    TYPE  TIsapiTable = CLASS(TTable)                                                #}
{#                                                                                     #}
{#              FKategorie : STRING[40];    This are local vars that you use for       #}
{#              FLand      : STRING[40];    filtering DataSets, don't use Ranges       #}
{#              FRegion    : STRING[40];    I had a lot of troubles!!!!!!!!!!          #}
{#                                                                                     #}
{#        PROCEDURE FilterDataSet(DataSet : TDataSet; VAR Accept : BOOLEAN);           #}
{#      END;                                                                           #}
{#      .                                                                              #}
{#      .                                                                              #}
{#      PROCEDURE TIsapiTable.FilterDataSet(DataSet : TDataSet; VAR Accept : BOOLEAN); #}
{#      BEGIN                                                                          #}
{#        Accept := (UpperCase(DataSet['Land'] = FLand) AND                            #}
{#                  (UpperCase(DataSet['Region'] = FRegion);                           #}
{#      END;                                                                           #}
{#                                                                                     #}
{#######################################################################################}

UNIT IsapiConnDB;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, DB, IsapiVars;

CONST

  svReqMethod   = 'REQUEST_METHOD';  { Var Definition fot "GetServerVar"}
  svQueryString = 'QUERY_STRING';
  svContentLen  = 'CONTENT_LENGTH';
  svContentType = 'CONTENT_TYPE';
  svAuthType    = 'AUTH_TYPE';
  svPathInfo    = 'PATH_INFO';
  svRemoteAddr  = 'REMOTE_ADDR';
  svRemoteHost  = 'REMOTE_HOST';
  svRemoteUser  = 'REMOTE_USER';
  svScriptName  = 'SCRIPT_NAME';
  svServerName  = 'SERVER_NAME';
  svServerPort  = 'SERVER_PORT';

  tvAppName    = '%APPNAME%';         { Var Definition for parsing Template files}
  tvServer     = '%SERVER%';
  tvScriptPath = '%SCRIPTPATH%';
  tvLocalPath  = '%LOCALPATH%';
  tvDBField    = '%DB';
  tvDBQueryFld = '%QDB';

  MaxReqBufferSize = 49152;          { First 48K Data recieved in ECB.lpbData}

  GET              = 0;              { Const to use in a "CASE Methode OF" clause}
  POST             = 1;

TYPE

  TBuffer = RECORD
              Addr : DWORD;
            END;

  TIsapiConnStatus = (eOk, eNoMem);

  TIsapiConn = CLASS(TObject)
  PRIVATE
    FECB              : IsapiVars.PECB;
    FBuffer           : POINTER;                { Pointer to SendBuffer}
    FRecBuffer        : POINTER;                { Pointer to ECB.lpbData}
    FBufferSize       : DWORD;
    FBufferPos        : DWORD;                  { Position in the  SendBuffer}
    FStatus           : TIsapiConnStatus;
    FResult           : WORD;
    FMethod           : WORD;
    FContentLen       : DWORD;
    FAvailable        : DWORD;
    FContentType      : STRING;
    FQueryString      : STRING;
    FPathInfo         : STRING;
    FPathTrans        : STRING;
    FRemoteAddr       : STRING;
    FRemoteUser       : STRING;
    FScriptName       : STRING;
    FServerName       : STRING;
    FServerPort       : STRING;
    FFilterOn         : BOOLEAN;

    FAppName          : STRING;            { Name of the DLL ex. "DBARTIKEL.DLL"}
    FServer           : STRING;            { Name of the Server: you put "www.iag.ch" and recieve "http://www.iag.ch/ }
    FScriptPath       : STRING;            { Path were the DLL is located ex. "scripts/artikel/" , can be combined with FServer to a URL }
    FLocalPath        : STRING;            { Path were the DLL is located locally ex. "C:\IISERVER\SCRIPTS\" }

    PROCEDURE AddLine(s : STRING);
    PROCEDURE SetAppName(Name : STRING);
    PROCEDURE SetServer(Server : STRING);
    PROCEDURE SetLocalPath(Path : STRING);

  PUBLIC
    CONSTRUCTOR Create(ptrECB : POINTER; BufferSize : DWORD); VIRTUAL;
    DESTRUCTOR  Destroy; OVERRIDE;

    FUNCTION  GetFormVar(VarName : STRING): STRING;
    FUNCTION  GetServerVar(VarName : STRING): STRING;
    FUNCTION  ExtractFromQuery(VarName : STRING): STRING; { Extracts Vars from the Querystring}
    PROCEDURE SetServerLogString(LogMsg : STRING);        { For debuging purposes }

    PROCEDURE Send(s : STRING);                           { Sends a STRING, with CRLF!}
    PROCEDURE SendBreak;                                  { Sends an <BR> }
    PROCEDURE SendHTMLFile(FileName : STRING);            { Read a Text-File that contains HTML-Data (for Header- and Footer-Files }
    PROCEDURE SendParsedTemplateFile(DataSet : TDataSet; FileName : STRING);   {Parss an Textfile where placeholders are chnaged with real Data, read the Doc for more information}
    PROCEDURE HTMLBegin(Title : STRING; BodyBkg : STRING; BodyInit : STRING);
    PROCEDURE HTMLEnd;

    PROCEDURE SendHeader;                                 { Sends a standart HTTP-Header }
    PROCEDURE SendSpecialHeader(ContentType : STRING);

    PROPERTY Status       : TIsapiConnStatus  READ FStatus;
    PROPERTY Result       : WORD              READ FResult;
    PROPERTY Method       : WORD              READ FMethod;
    PROPERTY QueryString  : STRING            READ FQueryString;
    PROPERTY ContentLen   : DWORD             READ FContentLen;
    PROPERTY Available    : DWORD             READ FAvailable;
    PROPERTY ContentType  : STRING            READ FContentType;
    PROPERTY PathInfo     : STRING            READ FPathInfo;
    PROPERTY PathTrans    : STRING            READ FPathTrans;
    PROPERTY RemoteAddr   : STRING            READ FRemoteAddr;
    PROPERTY RemoteUser   : STRING            READ FRemoteUser;
    PROPERTY ScriptName   : STRING            READ FScriptName;
    PROPERTY ServerName   : STRING            READ FServerName;
    PROPERTY ServerPort   : STRING            READ FServerPort;
    PROPERTY RecBuffer    : POINTER           READ FRecBuffer;     { Pointer To RecBuffer}
    PROPERTY FilterOn     : BOOLEAN           READ FFilterOn   WRITE FFilterOn    DEFAULT FALSE;   {Scan String for Special Chars and replaces them with HTML-Tags}

    PROPERTY AppName      : STRING            READ FAppName    WRITE SetAppName;
    PROPERTY Server       : STRING            READ FServer     WRITE SetServer;
    PROPERTY ScriptPath   : STRING            READ FScriptPath WRITE FScriptPath;
    PROPERTY LocalPath    : STRING            READ FLocalPath  WRITE SetLocalPath;

  END;

FUNCTION ASCIIToHTML(s : STRING): STRING;        {Filters a String and replaces special Charackters}
FUNCTION ReplaceSpaces(s : STRING): STRING; {Filters all spaces in a string and replaces with a '+', to use in a quera string}

{#####################################################################################}
IMPLEMENTATION

{--- Component Functions -----------------------------------------------}
{-----------------------------------------------------------------------}

FUNCTION ASCIIToHTML(s : STRING): STRING;
VAR i : BYTE;
    f : STRING;
BEGIN
  f := '';
  FOR i := 1 TO Length(s) DO BEGIN
    IF s[i] IN ['','','','','',
                '','','',
                '','','','','',
                '','','','','',
                '','','','','',
                '','','','','','',''] THEN
    BEGIN
      IF Length(f) < 248 THEN
        CASE s[i] OF
          '' : f := f+'&auml;';
          '' : f := f+'&euml;';
          '' : f := f+'&ouml;';
          '' : f := f+'&uuml;';
          '' : f := f+'&iuml;';


          '' : f := f+'&Auml;';
          '' : f := f+'&Ouml;';
          '' : f := f+'&Uuml;';

          '' : f := f+'&aacute;';
          '' : f := f+'&eacute;';
          '' : f := f+'&oacute;';
          '' : f := f+'&uacute;';
          '' : f := f+'&iacute;';

          '' : f := f+'&agrave;';
          '' : f := f+'&egrave;';
          '' : f := f+'&ograve;';
          '' : f := f+'&ugrave;';
          '' : f := f+'&igrave;';

          '' : f := f+'&acirc';
          '' : f := f+'&ocirc';
          '' : f := f+'&ucirc';
          '' : f := f+'&ecirc';
          '' : f := f+'&icirc';

          '' : f := f+'&Eacute;';
          '' : f := f+'&Egrave;';
          '' : f := f+'&Agrave;';

          '' : f := f+'&ntilde;';
          '' : f := f+'&Ntilde;';
          '' : f := f+'&ccedil;';
          '' : f := f+'&Ccedil;';

        END;
    END ELSE BEGIN
      IF Length(f) < 255 THEN f := f+s[i];
    END;
  END;
  Result := f;
END;


CONSTRUCTOR TIsapiConn.Create(ptrECB : POINTER; BufferSize : DWORD);
VAR CLenStr   : STRING;
    CLenErr   : INTEGER;
    p         : PChar;
    MethodStr : STRING[20];
BEGIN
  INHERITED Create;
  FECB := ptrECB;
  FStatus := eOk;
  FResult := HSE_STATUS_SUCCESS;
  FBufferPos := 0;
  FBufferSize := BufferSize;
  FFilterOn := FALSE;
  {Get ServerVars}
  MethodStr    := StrPas(FECB.lpszMethod);
  IF MethodStr = 'GET' THEN FMethod := GET
                       ELSE FMethod := POST;
  FQueryString := StrPas(FECB.lpszQueryString);
  FContentType := StrPas(FECB.lpszContentType);
  FContentLen  := FECB.cbTotalBytes;
  FAvailable   := FECB.cbAvailable;
  FPathInfo    := StrPas(FECB.lpszPathInfo);
  FPathTrans   := StrPas(FECB.lpszPathTranslated);
  FRemoteAddr  := GetServerVar(svRemoteAddr);
  FRemoteUser  := GetServerVar(svRemoteUser);
  FScriptName  := GetServerVar(svScriptName);
  FServerName  := GetServerVar(svServerName);
  FServerPort  := GetServerVar(svServerPort);
  FAppName     := '';
  FServer      := '';
  FScriptPath  := 'scripts/';
  FLocalPath   := 'C:\IISERVER\SCRIPTS\';
  {Setup LogBuffer}
  FECB.lpszLogData[0] := #0;
  {Set FRecBuffer to ECB.lpbData}
  FRecBuffer := FECB.lpbData;
  TRY
    FBuffer := AllocMem(FBufferSize);
  EXCEPT
    FBufferSize := 0;
    FStatus := eNoMem;
    FResult := HSE_STATUS_ERROR;
  END;
END;

DESTRUCTOR TIsapiConn.Destroy;
VAR Response : ARRAY[0..8] OF CHAR;
BEGIN
  TRY
    StrPCopy(Response,'200 OK');
    FECB.ServerSupportFunction(FECB.ConnID,HSE_REQ_SEND_RESPONSE_HEADER,
                               @Response,@FBufferPos,FBuffer);
    IF FBufferSize <> 0 THEN
    BEGIN
      FreeMem(FBuffer,FBufferSize);
    END;
  FINALLY
    INHERITED Destroy;
  END;
END;

PROCEDURE TIsapiConn.AddLine(s : STRING);
VAR p : PChar;
BEGIN
  IF (FBufferPos + Length(s) + 2) < FBufferSize THEN
  BEGIN
    s := s+#13+#10;
    p := FBuffer;
    TBuffer(p).Addr := TBuffer(p).Addr+FBufferPos;
    StrPCopy(p,s);
    FBufferPos := FBufferPos + Length(s);
  END;
END;

PROCEDURE TIsapiConn.SetLocalPath(Path : STRING);
BEGIN
  IF Path[Length(Path)] <> '\' THEN Path := Path+'\';
END;

PROCEDURE TIsapiConn.SetServer(Server : STRING);
BEGIN
  FServer := 'http://'+Server+'/';
END;

PROCEDURE TIsapiConn.SetAppName(Name : STRING);
BEGIN
  IF Pos('.dll',Name) = 0 THEN Name := Name+'.dll';
  FAppName := Name;
END;

{--- User Functions ----------------------------------------------------}
{-----------------------------------------------------------------------}

FUNCTION ReplaceSpaces(s : STRING): STRING;
BEGIN
  WHILE Result[Length(Result)] = ' ' DO Delete(Result,Length(Result),1);
  WHILE Pos(' ',s) <> 0 DO s[Pos(' ',s)] := '+';
  Result := s;
END;

FUNCTION TIsapiConn.GetServerVar(VarName : STRING): STRING;
VAR Buffer  : ARRAY[0..1023] OF CHAR;
    HVarName : PChar;
    dwLen   : DWORD;
BEGIN
  HVarName := StrAlloc(48);
  StrPCopy(HVarName,VarName);
  dwLen := 1024;
  IF FECB.GetServerVariable(FECB.ConnID,HVarName,@Buffer,dwLen) THEN
    Result := Buffer
  ELSE
    Result := '';
  StrDispose(HVarName);
END;

FUNCTION TIsapiConn.GetFormVar(VarName : STRING): STRING;
VAR b : PChar;
    v : PChar;
    r : STRING;
    Count : WORD;
    Pos   : WORD;

BEGIN
  r := '';
  TRY
    v := StrAlloc(Length(VarName)+1);
    StrPCopy(v,VarName);
    b := FRecBuffer;
    b := StrPos(b,v);
    IF b <> NIL THEN BEGIN
      Pos := 0;
      WHILE (Pos < 255) AND (b[Pos] <> '=') DO Inc(Pos);
      Inc(Pos);
      WHILE (Length(r) < 255) AND (b[Pos] <> '&') AND (b[Pos] <> #0) DO BEGIN
        r := r+b[Pos];
        Inc(Pos);
      END;
    END;
    StrDispose(v);
    Result := r;
  EXCEPT
    FResult := HSE_STATUS_ERROR;
  END;
END;

FUNCTION TIsapiConn.ExtractFromQuery(VarName : STRING): STRING;
VAR Value : STRING;
    sQueryString : STRING;
BEGIN
  sQueryString := FQueryString;
  VarName := UpperCase(VarName);
  IF Pos(VarName,UpperCase(sQueryString)) <> 0 THEN BEGIN
    Delete(sQueryString,1,Pos(VarName,UpperCase(sQueryString)));
    Delete(sQueryString,1,Pos('=',sQueryString));
    IF Pos('&',sQueryString) <> 0 THEN Result := Copy(sQueryString,1,Pos('&',sQueryString)-1)
                                  ELSE Result := sQueryString;
    WHILE Pos('+',Result) <> 0 DO Result[Pos('+',Result)] := ' ';
  END ELSE Result := '';
END;

PROCEDURE TIsapiConn.HTMLBegin(Title : STRING; BodyBkg : STRING; BodyInit : STRING);
BEGIN
  IF FFilterOn THEN Title := ASCIIToHTML(Title);
  Addline('<HTML><HEAD><TITLE>'+Title+'</TITLE></HEAD>');
  AddLine('<BODY '+BodyBkg+' '+BodyInit+'>');
END;

PROCEDURE TIsapiConn.HTMLEnd;
BEGIN
  AddLine('</BODY></HTML>');
END;

PROCEDURE TIsapiConn.SetServerLogString(LogMsg : STRING);
BEGIN
  IF Length(LogMsg) > 79 THEN SetLength(LogMsg,79);
  StrPCopy(FECB.lpszLogData,LogMsg);
END;

PROCEDURE TIsapiConn.Send(s : STRING);
BEGIN
  IF FFilterOn THEN s := ASCIIToHTML(s);
  AddLine(s);
END;

PROCEDURE TIsapiConn.SendBreak;
BEGIN
  AddLine('<BR>');
END;

PROCEDURE TIsapiConn.SendHeader;
BEGIN
  AddLine('Content-Type: text/html'+#13#10);
END;

PROCEDURE TIsapiConn.SendSpecialHeader(ContentType : STRING);
BEGIN
  AddLine('Content-Type: '+ContentType+#13#10);
END;

{--- Reads a HTML File and sends it's content ---------------------}
PROCEDURE TIsapiConn.SendHTMLFile(FileName : STRING);
VAR Line : STRING;
    f    : TextFile;
BEGIN
  TRY
    TRY
      AssignFile(F,FileName);
      Reset(F);
      WHILE NOT EOF(F) DO BEGIN
        ReadLn(F,Line);
        IF Line <> '' THEN AddLine(Line);
      END;
    FINALLY
      CloseFile(f);
    END;
  EXCEPT
    ON e : Exception DO Raise;
  END;
END;

{--- Parses a HTML File for placeholders and sends then the lines with filled in data -----}
PROCEDURE TIsapiConn.SendParsedTemplateFile(DataSet : TDataSet; FileName : STRING);
VAR Line    : STRING;
    f       : TextFile;

    PROCEDURE Parse;
    VAR s       : STRING;
        v       : STRING[40];
        Field   : INTEGER;
        Code    : INTEGER;
        Ext     : STRING[20];

    BEGIN
      TRY
        IF Line <> '' THEN BEGIN
          IF Pos('%',Line) <> 0 THEN BEGIN
            s := '';
            WHILE Pos('%',Line) <> 0 DO BEGIN
              IF (Length(s)+Length(Copy(Line,1,Pos('%',Line)-1))) > 255 THEN BEGIN
                AddLine(s);
                s := '';
              END;
              s := s+Copy(Line,1,Pos('%',Line)-1);
              Delete(Line,1,Pos('%',Line));
              v := UpperCase('%'+Copy(Line,1,Pos('%',Line)));
              Delete(Line,1,Pos('%',Line));
            {--- AppName Var ---------------------------------------------}
              IF v = tvAppName THEN BEGIN
                IF (Length(s)+Length(FAppName)) > 255 THEN BEGIN
                  AddLine(s);
                  s := '';
                END;
                s := s+FAppName;
            {--- ServerName Var ------------------------------------------}
              END ELSE IF v = tvServer THEN BEGIN
                IF (Length(s)+Length(FServer)) > 255 THEN BEGIN
                  AddLine(s);
                  s := '';
                END;
                s := s+FServer;
            {--- ScriptPath Var ------------------------------------------}
              END ELSE IF v = tvScriptPath THEN BEGIN
                IF (Length(s)+Length(FScriptPath)) > 255 THEN BEGIN
                  AddLine(s);
                  s := '';
                END;
                s := s+FScriptPath;
            {--- LocalPath Var ------------------------------------------}
              END ELSE IF v = tvLocalPath THEN BEGIN
                IF (Length(s)+Length(FLocalPath)) > 255 THEN BEGIN
                  AddLine(s);
                  s := '';
                END;
                s := s+FLocalPath;
            {--- Database Field Var ------------------------------------------ Will be Converted if FilterOn}
              END ELSE IF Pos(tvDBField,v) <> 0 THEN BEGIN
                Delete(v,1,3);
                IF Pos('+',v) <> 0 THEN BEGIN
                  Val(Copy(v,1,Pos('+',v)-1),Field,Code);
                  Delete(v,1,Pos('+',v));
                END ELSE BEGIN
                  Val(Copy(v,1,Pos('%',v)-1),Field,Code);
                  v := '';
                END;
                Ext := '';
                IF v <> '' THEN Ext := Copy(v,1,Pos('%',v)-1);
                IF Field >= DataSet.FieldCount THEN Field := DataSet.FieldCount-1;
                IF Field >= 0 THEN BEGIN
                  IF DataSet.Fields[Field].AsString <> 'N/A' THEN BEGIN
                    IF (Length(s)+Length(DataSet.Fields[Field].AsString)+Length(Ext)) > 255 THEN BEGIN
                      Send(s);
                      s := '';
                    END;
                    s := s+DataSet.Fields[Field].AsString+Ext;
                  END;
                END;
            {--- Database Query Field Var (to use in a query string )---------- No Conversion }
              END ELSE IF Pos(tvDBQueryFld,v) <> 0 THEN BEGIN
                Delete(v,1,4);
                IF Pos('+',v) <> 0 THEN BEGIN
                  Val(Copy(v,1,Pos('+',v)-1),Field,Code);
                  Delete(v,1,Pos('+',v));
                END ELSE BEGIN
                  Val(Copy(v,1,Pos('%',v)-1),Field,Code);
                  v := '';
                END;
                Ext := '';
                IF v <> '' THEN Ext := Copy(v,1,Pos('%',v)-1);
                IF Field >= DataSet.FieldCount THEN Field := DataSet.FieldCount-1;
                IF Field >= 0 THEN BEGIN
                  IF DataSet.Fields[Field].AsString <> 'N/A' THEN BEGIN
                    IF (Length(s)+Length(DataSet.Fields[Field].AsString)+Length(Ext)) > 255 THEN BEGIN
                      AddLine(s);
                      s := '';
                    END;
                    s := s+ReplaceSpaces(DataSet.Fields[Field].AsString+Ext);
                  END;
                END;
              END;
            END;
            IF (Length(s)+Length(Line)) > 255 THEN BEGIN
              AddLine(s);
              s := '';
            END;
            s := s+Line;
            IF s <> '' THEN AddLine(s);
          END ELSE AddLine(Line);
        END;
      EXCEPT
        ON e : EXCEPTION DO Raise;
      END;
    END;

BEGIN
  TRY
    IF NOT DataSet.EOF THEN BEGIN
      TRY
        AssignFile(f,FileName);
        Reset(f);
        WHILE NOT EOF(f) DO BEGIN
          ReadLn(f,Line);
          Parse;
        END;
      FINALLY
        CloseFile(f);
      END;
    END;
  EXCEPT
    ON e : EXCEPTION DO Raise;
  END;
END;

END.
