unit AsciiTime;
{
	FUNCTION NAME: TimeToAscii
	DESCRIPTION: Convert the Actual time to alphanumeric ASCII. string
	AUTHOR: L.Kovri (lkovari@freemail.c3.hu)
	LAST UPDATE: May.12.1993.
}
interface

Uses
	SysUtils, Classes, Registry, Windows, Dialogs;

function TimeToAscii: string;

implementation

// Display the time with ASCII. string
function TimeToAscii: string;
const
	 hr: array[0..20] of string[12]=('Zero','One','Two','Three','Four','Five',
																	 'Six','Seven','Eigh','Nine','Ten','Eleven',
																	 'Twelve','Thirteen','Fourteen','Fifteen',
																	 'Sixteen','Seventeen','Eighteen','Nineteen',
																	 'Twenty');
	 Tn: array[1..5] of string[12]=('Ten','Twenty','Thirty','Forty','Fifty');
var
	 h,m,s,s100: word;
					 tm: string;

// Set the Minute
procedure SetM(min: integer);
var
	v1: real;
begin
	v1:=min;
	if v1>10 then	begin
			if v1>30 then
				v1:=60-v1;
			if v1<20 then	begin
				v1:=trunc(v1);
				tm:=tm+hr[trunc(v1)];
			end
			else begin
				v1:=v1 / 10;
				v1:=trunc(v1);
				tm:=tm+tn[trunc(v1)];
				v1:=min;
				if v1>30 then
					v1:=60-v1;
					v1:=v1 / 10;
					v1:=frac(v1);
					v1:=v1*10;
					if v1<>0 then	begin
						tm:=tm+'-';
						tm:=tm+hr[trunc(v1)];
					end;
			end;
			tm:=tm+' ';
		end
	else begin
		v1:=min;
		tm:=tm+hr[trunc(v1)];
		tm:=tm+' ';
	end;
end;

// Main
begin
	tm:='The Time is ';
	h:=0;
	m:=0;
	s:=0;
	s100:=0;
	DecodeTime(Now,h,m,s,s100);
	if h>12 then h:=h-12;
	if m=0 then	begin
		tm:=tm+hr[h];
		tm:=tm+' o''clock';
	end
	else
	if m=30 then begin
		tm:=tm+'Half past ';
		tm:=tm+hr[h];
	end
	else
	if m=15 then begin
		tm:=tm+'Quater past ';
		tm:=tm+hr[h];
	end
	else
	if m<30 then begin
		SetM(m);
		tm:=tm+'past ';
		tm:=tm+hr[h];
	end
	else
	if m>30 then begin
		setm(m);
		tm:=tm+'to ';
		if h=12 then h:=0;
		tm:=tm+hr[h+1];
	end;
	if h=12 then
		Tm:=Tm+' PM'
	 else
	 	Tm:=Tm+' AM';
	//tm:=tm+'...';
	Result:=Tm;
end;

end.
