{ ****************************************************************** }
{                                                                    }
{   Delphi component TThreadTestPanel                                }
{                                                                    }
{   Panel for testing thread component                               }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\demos\coderobt\thredtst.cd  }
{   on 17 Jan 1997 at 18:07                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Thredtst;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Extctrls, Stdctrls, CCthread;

type
  TThreadTestPanel = class(TCustomPanel)
    private
      { Private fields of TThreadTestPanel }
        FThread : TNewThread;

      { Private methods of TThreadTestPanel }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        function GetCaption : String;
        procedure SetCaption(Value : String);
        procedure SetThread(Value : TNewThread);

    protected
      { Protected fields of TThreadTestPanel }
        HeaderLabel1 : TLabel;
        StartButton1 : TButton;
        SuspendButton1 : TButton;
        ResumeButton1 : TButton;
        StopButton1 : TButton;

      { Protected methods of TThreadTestPanel }
        { Resets prop of component type if referenced component deleted }
        procedure Notification(AComponent : TComponent; Operation : TOperation); override;
        procedure Click; override;
        procedure KeyPress(var Key : Char); override;
        procedure Loaded; override;
        procedure Paint; override;

    public
      { Public fields and properties of TThreadTestPanel }

      { Public methods of TThreadTestPanel }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        { Response to StartButton1 click }
        procedure DoStartButton1Click(Sender : TObject);
        { Response to SuspendButton1 click }
        procedure DoSuspendButton1Click(Sender : TObject);
        { Response to ResumeButton1 click }
        procedure DoResumeButton1Click(Sender : TObject);
        { Response to StopButton1 click }
        procedure DoStopButton1Click(Sender : TObject);
        procedure SetupButtons;

    published
      { Published properties of TThreadTestPanel }
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property OnKeyUp;
        property OnKeyDown;
        property OnKeyPress;
        property OnEnter;
        property OnExit;
        property OnResize;
        property Height default 257;
        property Width default 185;
        property Caption : String read GetCaption write SetCaption;
        property Thread : TNewThread read FThread write SetThread;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TThreadTestPanel with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TThreadTestPanel]);
end;

{ Method to set variable and property values and create objects }
procedure TThreadTestPanel.AutoInitialize;
begin
     HeaderLabel1 := TLabel.Create(Self);
     HeaderLabel1.Parent := Self;
     with HeaderLabel1 do
          begin
          Left := 56;
          Top := 24;
          Width := 53;
          Height := 13;
          end;
     StartButton1 := TButton.Create(Self);
     StartButton1.Parent := Self;
     with StartButton1 do
          begin
          Left := 24;
          Top := 58;
          Width := 105;
          Height := 25;
          Caption := 'Start';
          TabOrder := 0;
          OnClick := DoStartButton1Click;
          end;
     SuspendButton1 := TButton.Create(Self);
     SuspendButton1.Parent := Self;
     with SuspendButton1 do
          begin
          Left := 24;
          Top := 98;
          Width := 105;
          Height := 25;
          Caption := 'Suspend';
          Enabled := False;
          TabOrder := 1;
          OnClick := DoSuspendButton1Click;
          end;
     ResumeButton1 := TButton.Create(Self);
     ResumeButton1.Parent := Self;
     with ResumeButton1 do
          begin
          Left := 24;
          Top := 138;
          Width := 105;
          Height := 25;
          Caption := 'Resume';
          Enabled := False;
          TabOrder := 2;
          OnClick := DoResumeButton1Click;
          end;
     StopButton1 := TButton.Create(Self);
     StopButton1.Parent := Self;
     with StopButton1 do
          begin
          Left := 24;
          Top := 178;
          Width := 105;
          Height := 25;
          Caption := 'Request Stop';
          Enabled := False;
          TabOrder := 3;
          OnClick := DoStopButton1Click;
          end;
     Height := 257;
     Width := 185;
     FThread := nil;
end; { of AutoInitialize }

{ Resets prop of component type if referenced component deleted }
procedure TThreadTestPanel.Notification(AComponent : TComponent; Operation : TOperation);
begin
     inherited Notification(AComponent, Operation);
     if Operation <> opRemove then
        Exit;
     { Has a component referenced by a property of 
       this component been deleted?  If so, update 
       the property. }
     if AComponent = FThread then
        FThread := nil;
end;

{ Method to free any objects created by AutoInitialize }
procedure TThreadTestPanel.AutoDestroy;
begin
     HeaderLabel1.Free;
     StartButton1.Free;
     SuspendButton1.Free;
     ResumeButton1.Free;
     StopButton1.Free;
end; { of AutoDestroy }

function TThreadTestPanel.GetCaption : String;
begin
     { Return the HeaderLabel1.Caption property }
     Result := HeaderLabel1.Caption
end;

procedure TThreadTestPanel.SetCaption(Value : String);
begin
     { Set the HeaderLabel1.Caption property }
     HeaderLabel1.Caption := Value;
end;

procedure TThreadTestPanel.SetThread(Value : TNewThread);
begin
     FThread := Value;
     SetupButtons;
     { Shanging this property affects the appearance of
       the component, so update the image }
     Invalidate;
end;

{ Override OnClick handler from TCustomPanel }
procedure TThreadTestPanel.Click;
begin
     { Call method of parent class }
     inherited Click;
end;

{ Override OnKeyPress handler from TCustomPanel }
procedure TThreadTestPanel.KeyPress(var Key : Char);
begin
     { Call method of parent class }
     inherited KeyPress(Key);
end;

constructor TThreadTestPanel.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TThreadTestPanel.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TThreadTestPanel.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }
     inherited Caption := '';
     SetupButtons
end;

procedure TThreadTestPanel.Paint;
begin
     { Make this component look like its parent component by calling
       its parent's Paint method. }
     inherited Paint;

     { To change the appearance of the component, use the methods
       supplied by the component's Canvas property (which is of
       type TCanvas).  For example, }

     { Canvas.Rectangle(0, 0, Width, Height); }
end;

{ Response to StartButton1 click }
procedure TThreadTestPanel.DoStartButton1Click(Sender : TObject);
begin
     if Thread <> nil then
        begin
        Thread.Start;
        StartButton1.Enabled := False;
        SuspendButton1.Enabled := True;
        ResumeButton1.Enabled := True;
        StopButton1.Enabled := True;
        end
end;

{ Response to SuspendButton1 click }
procedure TThreadTestPanel.DoSuspendButton1Click(Sender : TObject);
begin
     if Thread <> nil then
        begin
        Thread.Suspend;
        StopButton1.Enabled := False;
        end
end;

{ Response to ResumeButton1 click }
procedure TThreadTestPanel.DoResumeButton1Click(Sender : TObject);
begin
     if Thread <> nil then
        begin
        Thread.Resume;
        StopButton1.Enabled := True;
        end
end;

{ Response to StopButton1 click }
procedure TThreadTestPanel.DoStopButton1Click(Sender : TObject);
begin
     if Thread <> nil then
        begin
        Thread.RequestStop;
        StartButton1.Enabled := True;
        SuspendButton1.Enabled := False;
        ResumeButton1.Enabled := False;
        StopButton1.Enabled := False
        end
end;

procedure TThreadTestPanel.SetupButtons;
var
     ThreadPresent : Boolean;
begin
     ThreadPresent := not (Thread = nil);
     StartButton1.Enabled := ThreadPresent;
     SuspendButton1.Enabled := False;
     ResumeButton1.Enabled := False;
     StopButton1.Enabled := False;
end;


end.
