{ ****************************************************************** }
{                                                                    }
{   Delphi component TPrinterThread                                  }
{                                                                    }
{   Prints a string list while running as separate thread            }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\demos\coderobt\thredprt.cd  }
{   on 18 Jan 1997 at 10:05                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Thredprt;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread, Printers;

type
  TPrinterThread = class(TNewThread)
    private
      { Private fields of TPrinterThread }
        FFont : TFont;
        FTitle : String;
        FLines : TStrings;

      { Private methods of TPrinterThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        procedure SetFont(Value : TFont);
        procedure SetLines(Value : TStrings);

    protected
      { Protected fields of TPrinterThread }

      { Protected methods of TPrinterThread }
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        procedure Loaded; override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TPrinterThread }

      { Public methods of TPrinterThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TPrinterThread }
        { Termination of thread }
        property OnTerminate;
        property Font : TFont read FFont write SetFont;
        property Title : String read FTitle write FTitle;
        property Lines : TStrings read FLines write SetLines;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TPrinterThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TPrinterThread]);
end;

{ Method to set variable and property values and create objects }
procedure TPrinterThread.AutoInitialize;
begin
     FFont := TFont.Create;
     FTitle := '';
     FLines := TStringList.Create;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TPrinterThread.AutoDestroy;
begin
     FFont.Free;
     FLines.Free;
end; { of AutoDestroy }

procedure TPrinterThread.SetFont(Value : TFont);
begin
     { Use Assign method because TFont is an object type }
     FFont.Assign(Value);
end;

procedure TPrinterThread.SetLines(Value : TStrings);
begin
     { Use Assign method because TStrings is an object type }
     FLines.Assign(Value);
end;

{ Termination of thread }
procedure TPrinterThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TPrinterThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TPrinterThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TPrinterThread.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

{ Method for thread to execute when started }
procedure TPrinterThread.Execute(Sender : TObject);
var
   PrintDevice : TextFile;
   I : Longint;
begin
     { Call method in parent class }
     inherited Execute(Sender);

     { Code to define component's behavior when thread is running }
     AssignPrn(PrintDevice);
     Printer.Title := FTitle;
     Rewrite(PrintDevice);
     Printer.Canvas.Font.Assign(FFont);
     for I := 0 to FLines.Count - 1 do
         Writeln(PrintDevice, FLines[I]);
     CloseFile(PrintDevice)
end;


end.
